/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.specialFunctions;

import de.jtem.mfc.field.Complex;
import de.jtem.numericalMethods.calculus.odeSolving.Extrap;
import de.jtem.numericalMethods.calculus.odeSolving.ODE;

public class HyperGeometric2F1 {
    private static final int MAX_ITER = 10000;
    private static final double EPS = 1.0E-14;
    private final Complex a = new Complex();
    private final Complex b = new Complex();
    private final Complex c = new Complex();
    private final Complex fac = new Complex();
    private final Complex last = new Complex();
    private final Complex aa = new Complex();
    private final Complex bb = new Complex();
    private final Complex cc = new Complex();
    private final Extrap integrator = new Extrap(4);
    private final Complex z0 = new Complex();
    private final Complex fOfZ0 = new Complex();
    private final Complex dfOfZ0 = new Complex();
    HyperGeometricODE hgODE = new HyperGeometricODE();

    public HyperGeometric2F1() {
    }

    public HyperGeometric2F1(Complex a, Complex b, Complex c) {
        this.setABC(a, b, c);
    }

    public static Complex evaluateSeries(Complex a, Complex b, Complex c, Complex z) {
        Complex result = new Complex();
        new HyperGeometric2F1().evaluateSeries(a, b, c, z, result, new Complex());
        return result;
    }

    public Complex evaluateSeries(Complex z) {
        return HyperGeometric2F1.evaluateSeries(this.a, this.b, this.c, z);
    }

    public void evaluateSeries(Complex a, Complex b, Complex c, Complex z, Complex f, Complex df) {
        if (z.absSqr() >= 1.0) {
            throw new RuntimeException("z is not inner point of the unit disc!");
        }
        f.assign(1.0);
        df.assign(0.0);
        this.fac.assign(1.0);
        this.last.assign(0.0);
        this.aa.assign(a);
        this.bb.assign(b);
        this.cc.assign(c);
        for (int n = 1; n < 10000; ++n) {
            this.fac.assignTimes(this.bb);
            this.fac.assignDivide(this.cc);
            this.fac.assignTimes(this.aa);
            df.assignPlus(this.fac);
            this.fac.assignTimes(z);
            this.fac.assignDivide(n);
            f.assignPlus(this.fac);
            if (f.re == this.last.re && f.im == this.last.im) {
                return;
            }
            this.last.assign(f);
            this.aa.assignPlus(1.0);
            this.bb.assignPlus(1.0);
            this.cc.assignPlus(1.0);
        }
        throw new RuntimeException("hypergeometric series did not converge");
    }

    public static Complex evaluate(Complex a, Complex b, Complex c, Complex z) {
        Complex result = new Complex();
        new HyperGeometric2F1().evaluate(a, b, c, z, result, new Complex());
        return result;
    }

    public Complex evaluate(Complex z) {
        return HyperGeometric2F1.evaluate(this.a, this.b, this.c, z);
    }

    public void evaluate(Complex a, Complex b, Complex c, Complex z, Complex f, Complex df) {
        if (z.absSqr() < 0.25) {
            this.evaluateSeries(a, b, c, z, f, df);
            return;
        }
        if (z.re < 0.0) {
            this.z0.assign(-0.5, 0.0);
        } else if (z.re <= 1.0) {
            this.z0.assign(0.5, 0.0);
        } else {
            this.z0.assign(0.0, z.im >= 0.0 ? 0.5 : -0.5);
        }
        this.hgODE.a.assign(a);
        this.hgODE.b.assign(b);
        this.hgODE.c.assign(c);
        this.hgODE.dz.assignMinus(z, this.z0);
        this.evaluateSeries(a, b, c, this.z0, this.fOfZ0, this.dfOfZ0);
        double[] x = new double[]{this.fOfZ0.re, this.fOfZ0.im, this.dfOfZ0.re, this.dfOfZ0.im};
        this.integrator.odex((ODE)this.hgODE, x, 1.0E-14, 0.0, 1.0);
        f.assign(x[0], x[1]);
        df.assign(x[2], x[3]);
    }

    public Complex getA() {
        return new Complex(this.a);
    }

    public void setA(Complex a) {
        this.a.assign(a);
    }

    public Complex getB() {
        return new Complex(this.b);
    }

    public void setB(Complex b) {
        this.b.assign(b);
    }

    public Complex getC() {
        return new Complex(this.c);
    }

    public void setC(Complex c) {
        this.c.assign(c);
    }

    public void setABC(Complex a, Complex b, Complex c) {
        this.setA(a);
        this.setB(b);
        this.setC(c);
    }

    class HyperGeometricODE
    implements ODE {
        final Complex f0 = new Complex();
        final Complex f1 = new Complex();
        final Complex df0 = new Complex();
        final Complex df1 = new Complex();
        final Complex z = new Complex();
        final Complex dz = new Complex();
        final Complex tmp = new Complex();
        final Complex a = new Complex();
        final Complex b = new Complex();
        final Complex c = new Complex();

        HyperGeometricODE() {
        }

        @Override
        public int getNumberOfEquations() {
            return 4;
        }

        @Override
        public void eval(double t, double[] x, double[] y) {
            this.f0.assign(x[0], x[1]);
            this.f1.assign(x[2], x[3]);
            this.z.assignTimes(this.dz, t);
            this.z.assignPlus(HyperGeometric2F1.this.z0);
            this.df0.assignTimes(this.f1, this.dz);
            this.df1.assignTimes(this.a, this.b);
            this.df1.assignTimes(this.f0);
            this.tmp.assignPlus(this.a, this.b);
            this.tmp.assignPlus(1.0);
            this.tmp.assignTimes(this.z);
            this.tmp.assignMinus(this.c);
            this.tmp.assignTimes(this.f1);
            this.df1.assignPlus(this.tmp);
            this.tmp.assignMinus(1.0, this.z);
            this.tmp.assignTimes(this.z);
            this.df1.assignDivide(this.tmp);
            this.df1.assignTimes(this.dz);
            y[0] = this.df0.re;
            y[1] = this.df0.im;
            y[2] = this.df1.re;
            y[3] = this.df1.im;
        }
    }
}

