/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.vector;

import de.jtem.mfc.geometry.ComplexProjective1;
import java.io.Serializable;

public class Real3
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final double EPSILON = 1.0E-14;
    public double x;
    public double y;
    public double z;

    public Real3() {
        this.assign(0.0, 0.0, 0.0);
    }

    public Real3(double theX, double theY, double theZ) {
        this.assign(theX, theY, theZ);
    }

    public Real3(Real3 v) {
        this.assign(v);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double v) {
        this.x = v;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double v) {
        this.y = v;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double v) {
        this.z = v;
    }

    public Real3 copy() {
        return new Real3(this);
    }

    public void assignZero() {
        this.assign(0.0, 0.0, 0.0);
    }

    public void assign(double newX, double newY, double newZ) {
        this.x = newX;
        this.y = newY;
        this.z = newZ;
    }

    public void assign(Real3 v) {
        this.assign(v.x, v.y, v.z);
    }

    public void assignPlus(Real3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Real3 plus(Real3 v) {
        return new Real3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Real3 times(double t) {
        return new Real3(t * this.x, t * this.y, t * this.z);
    }

    public Real3 divide(double t) {
        return new Real3(this.x / t, this.y / t, this.z / t);
    }

    public void assignMinus(Real3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public Real3 minus(Real3 v) {
        return new Real3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public void assignTimes(double a) {
        this.x *= a;
        this.y *= a;
        this.z *= a;
    }

    public void assignDivide(double a) {
        this.x /= a;
        this.y /= a;
        this.z /= a;
    }

    public void assignLinearCombination(double a, Real3 v, double b, Real3 w) {
        double dummyX = a * v.x + b * w.x;
        double dummyY = a * v.y + b * w.y;
        double dummyZ = a * v.z + b * w.z;
        this.assign(dummyX, dummyY, dummyZ);
    }

    public void assignCrossProduct(Real3 v, Real3 w) {
        double dummyX = v.y * w.z - v.z * w.y;
        double dummyY = v.z * w.x - v.x * w.z;
        double dummyZ = v.x * w.y - v.y * w.x;
        this.assign(dummyX, dummyY, dummyZ);
    }

    public Real3 crossProduct(Real3 v) {
        Real3 result = new Real3();
        result.assignCrossProduct(this, v);
        return result;
    }

    public static final double dotProduct(Real3 v, Real3 w) {
        return v.x * w.x + v.y * w.y + v.z * w.z;
    }

    public final double dot(Real3 v) {
        return Real3.dotProduct(this, v);
    }

    public double normSquared() {
        return Real3.dotProduct(this, this);
    }

    public double norm() {
        return Math.sqrt(this.normSquared());
    }

    public double distSquared(Real3 v) {
        return (this.x - v.x) * (this.x - v.x) + (this.y - v.y) * (this.y - v.y) + (this.z - v.z) * (this.z - v.z);
    }

    public double dist(Real3 v) {
        return Math.sqrt(this.distSquared(v));
    }

    public void normalize() {
        this.assignDivide(this.norm());
    }

    public void projectTo(ComplexProjective1 cp) throws IllegalArgumentException {
        if (Math.abs(this.normSquared() - 1.0) > 1.0E-14) {
            throw new IllegalArgumentException("Norm must be 1.0. Norm is " + this.norm() + ". ");
        }
        if (this.z > 0.0) {
            this.y = -this.y;
            this.z = -this.z;
            this.belowXYProjectTo(cp);
            this.y = -this.y;
            this.z = -this.z;
            double dummyRe = cp.aRe;
            double dummyIm = cp.aIm;
            cp.aRe = cp.bRe;
            cp.aIm = cp.bIm;
            cp.bRe = dummyRe;
            cp.bIm = dummyIm;
        } else {
            this.belowXYProjectTo(cp);
        }
    }

    private final void belowXYProjectTo(ComplexProjective1 cp) {
        double bRe = 1.0 - this.z;
        double bIm = 0.0;
        double aRe = this.x;
        double aIm = this.y;
        cp.assign(aRe, aIm, bRe, 0.0);
    }

    public String toString() {
        return new String("(" + this.x + ", " + this.y + ", " + this.z + ")");
    }
}

