/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.group;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class Permutation {
    private static final long serialVersionUID = 1L;

    public static int[] identity(int len) {
        int[] result = new int[len];
        Permutation.identity(result);
        return result;
    }

    public static void identity(int[] s) {
        int i = s.length;
        while (--i >= 0) {
            s[i] = i;
        }
    }

    public static int[] random(int len) {
        int[] s = new int[len];
        Permutation.random(s);
        return s;
    }

    public static int[] random(int len, int derangement) {
        int[] s = new int[len];
        Permutation.random(s, derangement);
        return s;
    }

    public static void random(int[] s) {
        Permutation.random(s, 0);
    }

    public static void random(int[] s, int derangement) {
        boolean d = derangement != 0;
        Permutation.identity(s);
        Random rnd = new Random();
        int i = s.length;
        while (i > 1) {
            int r = rnd.nextInt(d ? --i : i--);
            int copy = s[i];
            s[i] = s[r];
            s[r] = copy;
        }
    }

    public static boolean isPermutation(int[] p) {
        boolean[] flags = new boolean[p.length];
        return Permutation.isPermutation(p, flags);
    }

    public static boolean isPermutation(int[] p, int[] garbage) {
        if (p.length > garbage.length) {
            throw new IllegalArgumentException("mfc.de.jtem.numericalMethods.group.Permutation.isPermutation called with int[] of insufficient size.");
        }
        Arrays.fill(garbage, 1);
        int i = p.length;
        while (--i >= 0) {
            try {
                int n = p[i];
                garbage[n] = garbage[n] - 1;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        i = p.length;
        while (--i >= 0) {
            if (garbage[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isPermutation(int[] p, boolean[] flags) {
        if (p.length > flags.length) {
            throw new IllegalArgumentException("mfc.de.jtem.numericalMethods.group.Permutation.isPermutation called with int[] of insufficient size.");
        }
        Arrays.fill(flags, true);
        int i = p.length;
        while (--i >= 0) {
            try {
                if (flags[p[i]]) {
                    flags[p[i]] = false;
                    continue;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        i = p.length;
        while (--i >= 0) {
            if (!flags[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isDerangement(int[] p) {
        boolean[] flags = new boolean[p.length];
        return Permutation.isDerangement(p, flags);
    }

    public static boolean isDerangement(int[] p, int[] garbage) {
        int i = p.length;
        while (--i >= 0) {
            if (p[i] != i) continue;
            return false;
        }
        return Permutation.isPermutation(p, garbage);
    }

    public static boolean isDerangement(int[] p, boolean[] flags) {
        int i = p.length;
        while (--i >= 0) {
            if (p[i] != i) continue;
            return false;
        }
        return Permutation.isPermutation(p, flags);
    }

    public static int[][] cycles(int[] s) {
        int n = s.length;
        boolean[] flag = new boolean[n];
        int[][] c = new int[n][];
        int[] grow = new int[n];
        int number = 0;
        for (int i = 0; i < n; ++i) {
            if (flag[i]) continue;
            int len = 0;
            try {
                int j = s[i];
                while (!flag[j]) {
                    grow[n - ++len] = j;
                    flag[j] = true;
                    j = s[j];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1." + e.getMessage());
            }
            if (grow[n - len] != i) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1.");
            }
            c[number] = new int[len];
            System.arraycopy(grow, n - len, c[number], 0, len);
            ++number;
        }
        int[][] result = new int[number][];
        System.arraycopy(c, 0, result, 0, number);
        return result;
    }

    public static int[][] cyclesFun(int[] s) {
        int n = s.length;
        boolean[] flag = new boolean[n];
        int[][] c = new int[n][];
        int[] grow = new int[n];
        int number = 0;
        for (int i = 0; i < n; ++i) {
            if (flag[i]) continue;
            int len = 0;
            try {
                int j = i;
                while (!flag[j]) {
                    grow[len++] = j;
                    flag[j] = true;
                    j = s[j];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1." + e.getMessage());
            }
            if (s[grow[len - 1]] != i) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1.");
            }
            c[number] = new int[len];
            System.arraycopy(grow, 0, c[number], 0, len);
            ++number;
        }
        int[][] result = new int[number][];
        System.arraycopy(c, 0, result, 0, number);
        return result;
    }

    public static void fromCycles(int[][] c, int[] result) throws ArrayIndexOutOfBoundsException {
        int len = result.length;
        Permutation.identity(result);
        for (int i = 0; i < c.length; ++i) {
            int last = c[i].length - 1;
            result[c[i][0]] = c[i][last];
            int k = last;
            while (k > 0) {
                result[c[i][k]] = c[i][--k];
            }
        }
    }

    public static void fromCyclesFun(int[][] c, int[] result) throws ArrayIndexOutOfBoundsException {
        int len = result.length;
        Permutation.identity(result);
        for (int i = 0; i < c.length; ++i) {
            int last = c[i].length - 1;
            result[c[i][last]] = c[i][0];
            int k = 0;
            while (k < last) {
                result[c[i][k]] = c[i][++k];
            }
        }
    }

    public static int[] fromCycles(int[][] c) {
        int len = 0;
        for (int i = 0; i < c.length; ++i) {
            len += c[i].length;
        }
        int[] result = new int[len];
        try {
            Permutation.fromCycles(c, result);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Permutation.fromCycles called with a non valid array of cycles.");
        }
        return result;
    }

    public static int[] inverse(int[] s) {
        int[] result = new int[s.length];
        Permutation.inverse(s, result);
        return result;
    }

    public static void inverse(int[] s, int[] result) throws IllegalArgumentException {
        int i = s.length;
        while (--i >= 0) {
            try {
                result[s[i]] = i;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.inverse called with a non valid permutation of its indices 0..n-1.");
            }
        }
    }

    public static int numTranspos(int[] p) {
        return Permutation.numTranspos(p, new int[p.length]);
    }

    public static int numTranspos(int[] p, int[] garbage) {
        Arrays.fill(garbage, 0);
        int result = 0;
        int i = p.length;
        while (--i >= 0) {
            int j = i;
            if (garbage[i] != 0) continue;
            do {
                garbage[j] = 1;
                j = p[j];
                ++result;
            } while (garbage[j] == 0);
            --result;
        }
        return result;
    }

    public static int numTranspos(int[] p, boolean[] flags) {
        Arrays.fill(flags, true);
        int result = 0;
        int i = p.length;
        while (--i >= 0) {
            int j = i;
            if (!flags[i]) continue;
            do {
                flags[j] = false;
                j = p[j];
                ++result;
            } while (flags[j]);
            --result;
        }
        return result;
    }

    public static int numInversions(int[] p) {
        int len;
        int result = 0;
        int i = len = p.length;
        while (--i >= 0) {
            for (int j = 0; p[j] != i && j < len; ++j) {
                if (p[j] <= i) continue;
                ++result;
            }
        }
        return result;
    }

    public static int parity(int[] p) {
        return Permutation.numInversions(p) % 2;
    }

    public static int order(int[] p) {
        return Permutation.order(p, new boolean[p.length]);
    }

    public static int order(int[] p, int[] garbage) {
        Arrays.fill(garbage, 0);
        int result = 1;
        int i = p.length;
        while (--i >= 0) {
            int j = i;
            if (garbage[i] != 0) continue;
            int len = 0;
            do {
                garbage[j] = 1;
                j = p[j];
                ++len;
            } while (garbage[j] == 0);
            result = Permutation.lcm(result, len);
        }
        return result;
    }

    public static int order(int[] p, boolean[] flags) {
        Arrays.fill(flags, true);
        int result = 1;
        int i = p.length;
        while (--i >= 0) {
            int j = i;
            if (!flags[i]) continue;
            int len = 0;
            do {
                flags[j] = false;
                j = p[j];
                ++len;
            } while (flags[j]);
            result = Permutation.lcm(result, len);
        }
        return result;
    }

    public static int lcm(int m, int n) {
        return m * n / Permutation.gcd(m, n);
    }

    public static int gcd(int m, int n) {
        if (m < 0) {
            m = -m;
        }
        if (n < 0) {
            n = -n;
        }
        while (m > 0) {
            if (n > m) {
                int t = m;
                m = n;
                n = t;
            }
            m -= n;
        }
        return n;
    }

    public static int lcm(int[] nums) {
        int i = nums.length - 1;
        int d = nums[i];
        while (--i >= 0) {
            d = Permutation.lcm(d, nums[i]);
        }
        return d;
    }

    public static int gcd(int[] nums) {
        int i = nums.length - 1;
        int d = nums[i];
        while (--i >= 0) {
            d = Permutation.gcd(d, nums[i]);
        }
        return d;
    }

    public static int factorial(int n) {
        int result = 1;
        for (int i = n; i > 0; --i) {
            result *= i;
        }
        return result;
    }

    public static int subFactorial(int n) {
        int sNm1 = 0;
        int sN = n > 1 ? 1 : 0;
        for (int i = 2; i < n; ++i) {
            int sC = sN;
            sN = i * (sN + sNm1);
            sNm1 = sC;
        }
        return sN;
    }

    public static void next(int[] p) {
        int last = p.length - 1;
        int current = p[last];
        int i = last;
        while (--i >= 0) {
            if (p[i] < current) {
                int pi = p[i];
                int j = p.length;
                while (p[--j] < pi) {
                }
                p[i] = p[j];
                p[j] = pi;
                int crossing = last + i + 1;
                for (j = crossing >> 1; j > i; --j) {
                    int reflect = crossing - j;
                    pi = p[j];
                    p[j] = p[reflect];
                    p[reflect] = pi;
                }
                return;
            }
            current = p[i];
        }
        Permutation.identity(p);
    }

    public static void nextDerangement(int[] p) {
        int last = p.length - 1;
        int current = p[last];
        int i = last;
        while (--i >= 0) {
            if (p[i] < current) {
                int pi = p[i];
                int j = p.length;
                while (p[--j] < pi) {
                }
                if (p[j] != i) {
                    p[i] = p[j];
                    p[j] = pi;
                } else if (j > i + 1) {
                    p[j] = pi;
                    p[i] = p[--j];
                    p[j] = i;
                } else {
                    p[i] = p[j];
                    p[j] = pi;
                    current = p[i];
                    continue;
                }
                int crossing = last + i + 1;
                for (j = crossing >> 1; j > i; --j) {
                    int reflect = crossing - j;
                    pi = p[j];
                    p[j] = p[reflect];
                    p[reflect] = pi;
                }
                for (j = i; j < last; ++j) {
                    if (p[j] != j) continue;
                    pi = p[j];
                    p[j++] = p[j];
                    p[j] = pi;
                }
                if (p[last] == last) {
                    p[last] = p[last - 1];
                    p[last - 1] = last;
                }
                return;
            }
            current = p[i];
        }
        Permutation.firstDerangement(p);
    }

    public static void firstDerangement(int[] p) {
        int last = p.length - 1;
        for (int i = 0; i < last; ++i) {
            p[i++] = i;
            p[i] = i - 1;
        }
        if (last % 2 == 0) {
            p[last] = last - 2;
            p[last - 1] = last;
            p[last - 2] = last - 1;
        }
    }

    public static void flipLR(int[] s) {
        int last = s.length - 1;
        int i = s.length >> 1;
        while (i-- >= 0) {
            int bucket = s[i];
            int flippedI = last - i;
            s[i] = s[flippedI];
            s[flippedI] = bucket;
        }
    }

    public static void flipUD(int[] s) {
        int last = s.length - 1;
        int i = s.length;
        while (--i >= 0) {
            s[i] = last - s[i];
        }
    }

    public static void previous(int[] p) {
        Permutation.flipUD(p);
        Permutation.next(p);
        Permutation.flipUD(p);
    }

    public static int applyTo(int[] s, int i) {
        int j = s.length;
        while (--j >= 0) {
            if (s[j] != i) continue;
            return j;
        }
        throw new IllegalArgumentException("Permutation.applyTo called with a non valid index.");
    }

    public static int applyToFun(int[] s, int i) {
        return s[i];
    }

    public static int[] times(int[] p1, int[] p2) {
        int[] result = new int[p1.length];
        Permutation.times(p1, p2, result);
        return result;
    }

    public static void times(int[] p1, int[] p2, int[] result) {
        if (p1.length != p2.length) {
            throw new IllegalArgumentException("Permutation.times called with permutations of different sizes.");
        }
        int i = p1.length;
        while (--i >= 0) {
            try {
                result[i] = p2[p1[i]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.times called with invalid permutations.");
            }
        }
    }

    public static int[] timesInverse(int[] p1, int[] p2) {
        int[] result = new int[p1.length];
        Permutation.timesInverse(p1, p2, result);
        return result;
    }

    public static void timesInverse(int[] p1, int[] p2, int[] result) {
        if (p1.length != p2.length) {
            throw new IllegalArgumentException("Permutation.times called with permutations of different sizes.");
        }
        int i = p1.length;
        while (--i >= 0) {
            try {
                result[p1[p2[i]]] = i;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.timesInverse called with invalid permutations.");
            }
        }
    }

    public static int[] timesFun(int[] p1, int[] p2) {
        int[] result = new int[p1.length];
        Permutation.timesFun(p1, p2, result);
        return result;
    }

    public static void timesFun(int[] p1, int[] p2, int[] result) {
        if (p1.length != p2.length) {
            throw new IllegalArgumentException("Permutation.times called with permutations of different sizes.");
        }
        int i = p1.length;
        while (--i >= 0) {
            try {
                result[i] = p1[p2[i]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.timesInverse called with invalid permutations.");
            }
        }
    }

    public static int[] divide(int[] p1, int[] p2) {
        int[] result = new int[p1.length];
        Permutation.divide(p1, p2, result);
        return result;
    }

    public static void divide(int[] p1, int[] p2, int[] result) {
        if (p1.length != p2.length) {
            throw new IllegalArgumentException("Permutation.divide called with permutations of different sizes.");
        }
        int i = p1.length;
        block0: while (--i >= 0) {
            int j = p1.length;
            while (--j >= 0) {
                if (p2[j] != p1[i]) continue;
                result[i] = j;
                continue block0;
            }
        }
    }

    public static int[] divideFun(int[] p1, int[] p2) {
        int[] result = new int[p1.length];
        Permutation.divideFun(p1, p2, result);
        return result;
    }

    public static void divideFun(int[] p1, int[] p2, int[] result) {
        if (p1.length != p2.length) {
            throw new IllegalArgumentException("Permutation.divideFun called with permutations of different sizes.");
        }
        int i = p1.length;
        while (--i >= 0) {
            try {
                result[p2[i]] = p1[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Permutation.divideFun called with invalid permutations.");
            }
        }
    }

    public static int[] inversions(int[] s) {
        int len = s.length;
        int[] result = new int[len];
        Permutation.inversions(s, result);
        return result;
    }

    public static void inversions(int[] s, int[] result) {
        int len;
        int i = len = s.length;
        while (--i >= 0) {
            for (int j = 0; s[j] != i && j < len; ++j) {
                if (s[j] <= i) continue;
                int n = i;
                result[n] = result[n] + 1;
            }
        }
    }

    public static int[] inversionsFun(int[] s) {
        int len = s.length;
        int[] result = new int[len];
        Permutation.inversionsFun(s, result);
        return result;
    }

    public static void inversionsFun(int[] s, int[] result) {
        int len;
        int i = len = s.length;
        while (--i >= 0) {
            int j = len;
            while (--j > i) {
                if (s[j] >= i) continue;
                int n = i;
                result[n] = result[n] + 1;
            }
        }
    }

    public static int[] fromInversions(int[] inv) {
        int[] s = new int[inv.length];
        Permutation.fromInversions(inv, s);
        return s;
    }

    public static void fromInversions(int[] inv, int[] s) {
        int len = inv.length;
        ArrayList<Integer> sL = new ArrayList<Integer>(len);
        int i = len;
        while (--i >= 0) {
            sL.add(inv[i], new Integer(i));
        }
        i = len;
        while (--i >= 0) {
            s[i] = (Integer)sL.get(i);
        }
    }

    public static int[] fromInversionsFun(int[] inv) {
        int[] s = new int[inv.length];
        Permutation.fromInversionsFun(inv, s);
        return s;
    }

    public static void fromInversionsFun(int[] inv, int[] s) {
        int len = inv.length;
        ArrayList<Integer> sL = new ArrayList<Integer>(len);
        int i = len;
        while (--i >= 0) {
            sL.add(inv[i], new Integer(i));
        }
        i = len;
        while (--i >= 0) {
            s[((Integer)sL.get((int)i)).intValue()] = i;
        }
    }

    public static int[][][] youngTableaux(int[] s) {
        int len = s.length;
        ArrayList yP = new ArrayList(len);
        ArrayList yQ = new ArrayList(len);
        int i = len;
        while (--i >= 0) {
            yP.add(0, new ArrayList(i));
            yQ.add(0, new ArrayList(i));
        }
        block1: for (i = 0; i < s.length; ++i) {
            int si = s[i];
            int limj = yP.size();
            for (int j = 0; j < limj; ++j) {
                ArrayList yPj = (ArrayList)yP.get(j);
                ArrayList yQj = (ArrayList)yQ.get(j);
                boolean flag = false;
                int limk = yPj.size();
                for (int k = 0; k < limk; ++k) {
                    int yPjk = (Integer)yPj.get(k);
                    if (yPjk <= si) continue;
                    flag = true;
                    yPj.set(k, new Integer(si));
                    si = yPjk;
                    break;
                }
                if (flag) continue;
                yPj.add(new Integer(si));
                yQj.add(new Integer(i));
                continue block1;
            }
        }
        int dim = len;
        while (--dim >= 0 && ((ArrayList)yP.get(dim)).size() == 0) {
        }
        int[][][] y = new int[][][]{new int[++dim][], new int[dim][]};
        int i2 = dim;
        while (--i2 >= 0) {
            ArrayList yPI = (ArrayList)yP.get(i2);
            ArrayList yQI = (ArrayList)yQ.get(i2);
            y[0][i2] = new int[yPI.size()];
            y[1][i2] = new int[yQI.size()];
            int j = yPI.size();
            while (--j >= 0) {
                y[0][i2][j] = (Integer)yPI.get(j);
                y[1][i2][j] = (Integer)yQI.get(j);
            }
        }
        return y;
    }

    public static int[] fromYoungTableaux(int[][][] y) {
        int len = 0;
        int dim = y[0].length;
        ArrayList yP = new ArrayList(dim);
        for (int i = 0; i < dim; ++i) {
            int leni = y[0][i].length;
            len += leni;
            ArrayList<Integer> yPI = new ArrayList<Integer>(leni);
            for (int j = 0; j < leni; ++j) {
                yPI.add(new Integer(y[0][i][j]));
            }
            yP.add(yPI);
        }
        int[] result = new int[len];
        int i = len;
        while (--i >= 0) {
            int j;
            int k = 0;
            int limj = yP.size();
            block3: for (j = 0; j < limj; ++j) {
                int limk = y[1][j].length;
                for (k = 0; k < limk; ++k) {
                    if (y[1][j][k] == i) break block3;
                }
            }
            int value = 0;
            ArrayList yPj = (ArrayList)yP.get(j);
            Integer valInt = (Integer)yPj.get(k);
            value = valInt;
            yPj.remove(k);
            while (--j >= 0) {
                yPj = (ArrayList)yP.get(j);
                int limk = yPj.size();
                if (limk > 0) {
                    for (k = 0; k < limk && (Integer)yPj.get(k) <= value; ++k) {
                    }
                    --k;
                }
                Integer valjk = (Integer)yPj.get(k);
                yPj.set(k, valInt);
                valInt = valjk;
                value = valInt;
            }
            result[i] = value;
        }
        return result;
    }

    public static int[][] runs(int[] s) {
        int n = s.length;
        int[][] c = new int[n][];
        int[] grow = new int[n];
        int number = 0;
        for (int i = 0; i < n; ++i) {
            int len = 0;
            for (int j = i; j < n; ++j) {
                grow[len++] = s[j];
            }
            c[number] = new int[len];
            System.arraycopy(grow, 0, c[number], 0, len);
            ++number;
            i += len;
        }
        int[][] result = new int[number][];
        System.arraycopy(c, 0, result, 0, number);
        return result;
    }

    public static String cyclesToString(int[] s) {
        return Permutation.cyclesToString(Permutation.cycles(s));
    }

    public static String cyclesToString(int[][] c) {
        StringBuffer sb = new StringBuffer().append('(');
        for (int j = 0; j < c.length; ++j) {
            sb.append('(').append(' ');
            for (int i = 0; i < c[j].length; ++i) {
                sb.append(c[j][i] + " ");
            }
            sb.append(')');
        }
        sb.append(')');
        return sb.toString();
    }

    public static final int[][] stringToCycles(String s) {
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            st.resetSyntax();
            st.wordChars(48, 57);
            st.wordChars(0, 32);
            st.whitespaceChars(40, 41);
            int num = 0;
            int maxLen = 0;
            StreamTokenizer stC = new StreamTokenizer(new StringReader(s));
            stC.resetSyntax();
            stC.wordChars(48, 57);
            stC.wordChars(0, 32);
            stC.whitespaceChars(40, 41);
            while (true) {
                if (stC.nextToken() == -1) break;
                int len = stC.sval.trim().length();
                if (len > maxLen) {
                    maxLen = len;
                }
                if (len <= 0) continue;
                ++num;
            }
            int[] basket = new int[maxLen];
            int[][] cycles = new int[num][];
            num = 0;
            while (true) {
                if (st.nextToken() == -1) break;
                String theS = st.sval.trim();
                if (theS.length() <= 0) continue;
                cycles[num++] = Permutation.stringToIntArray(theS, basket);
            }
            return cycles;
        }
        catch (IOException ex) {
            throw new Error();
        }
    }

    public static int[] stringToIntArray(String s) {
        return Permutation.stringToIntArray(s, new int[s.length()]);
    }

    public static int[] stringToIntArray(String s, int[] basket) {
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            st.resetSyntax();
            st.whitespaceChars(0, 44);
            st.whitespaceChars(58, 59);
            st.whitespaceChars(123, 125);
            st.parseNumbers();
            int num = 0;
            while (true) {
                if (st.nextToken() == -1) break;
                basket[num++] = (int)st.nval;
            }
            int[] theIntArray = new int[num];
            System.arraycopy(basket, 0, theIntArray, 0, num);
            return theIntArray;
        }
        catch (IOException ex) {
            throw new Error();
        }
    }

    public static String toString(int[] s) {
        StringBuffer sb = new StringBuffer().append('(').append(' ');
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i] + " ");
        }
        sb.append(')');
        return sb.toString();
    }
}

