/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear;

import de.jtem.numericalMethods.algebra.linear.solve.AXB;

public class Inversion {
    public static boolean compute(double[][] A, double[][] T, double[] t0, double[] t1) {
        int i;
        int n = A[0].length;
        if (T == null) {
            T = new double[n][n];
        }
        for (int j = 0; j < n; ++j) {
            T[0][j] = 0.0;
        }
        for (i = 1; i < n; ++i) {
            System.arraycopy(T[0], 0, T[i], 0, n);
        }
        for (i = 0; i < n; ++i) {
            T[i][i] = 1.0;
        }
        if (!AXB.solve(A, T, t0, t1)) {
            return false;
        }
        for (i = 0; i < n; ++i) {
            System.arraycopy(T[i], 0, A[i], 0, n);
        }
        return true;
    }

    public static boolean compute(double[][] A, double[][] I) {
        int n = A[0].length;
        if (A != I) {
            for (int i = 0; i < n; ++i) {
                System.arraycopy(A[i], 0, I[i], 0, n);
            }
        }
        return Inversion.compute(I, (double[][])null, (double[])null, (double[])null);
    }

    public static boolean compute(double[][] A_re, double[][] A_im, double[][] T0, double[][] T1, double[] t0, double[] t1, double[] t2, double[] t3) {
        int i;
        int n = A_re[0].length;
        if (T0 == null) {
            T0 = new double[n][n];
        }
        if (T1 == null) {
            T1 = new double[n][n];
        }
        for (int j = 0; j < n; ++j) {
            T1[0][j] = 0.0;
        }
        System.arraycopy(T1[0], 0, T0[0], 0, n);
        T0[0][0] = 1.0;
        for (i = 1; i < n; ++i) {
            System.arraycopy(T1[0], 0, T0[i], 0, n);
            System.arraycopy(T1[0], 0, T1[i], 0, n);
            T0[i][i] = 1.0;
        }
        if (!AXB.solve(A_re, A_im, T0, T1, t0, t1, t2, t3)) {
            return false;
        }
        for (i = 0; i < n; ++i) {
            System.arraycopy(T0[i], 0, A_re[i], 0, n);
            System.arraycopy(T1[i], 0, A_im[i], 0, n);
        }
        return true;
    }

    public static boolean compute(double[][] A_re, double[][] A_im, double[][] I_re, double[][] I_im) {
        int n = A_re[0].length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(A_re[i], 0, I_re[i], 0, n);
            System.arraycopy(A_im[i], 0, I_im[i], 0, n);
        }
        return Inversion.compute(I_re, I_im, null, null, null, null, null, null);
    }
}

