/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Cholesky {
    private static IllegalArgumentException notPositiveDefinte = new IllegalArgumentException("matrix is not positive definite");

    private Cholesky() {
    }

    public static void decompose(double[][] A, double[][] L) {
        int n = A.length;
        for (int i = 0; i < n; ++i) {
            double[] ithRowOfL = L[i];
            double[] ithRowOfA = A[i];
            for (int j = i; j < n; ++j) {
                double[] jthRowOfL = L[j];
                double sum = ithRowOfA[j];
                for (int k = i - 1; k >= 0; --k) {
                    sum -= ithRowOfL[k] * jthRowOfL[k];
                }
                if (i == j) {
                    if (sum <= 0.0) {
                        throw notPositiveDefinte;
                    }
                    if (L != null) {
                        L[j][i] = Math.sqrt(sum);
                    }
                } else if (L != null) {
                    L[j][i] = sum / L[i][i];
                }
                if (i >= j) continue;
                L[i][j] = 0.0;
            }
        }
    }

    public static boolean decomposable(double[][] A, double eps) {
        int n = A.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(Math.abs(A[i][j] - A[j][i]) > eps)) continue;
                return false;
            }
        }
        try {
            Cholesky.decompose(A, null);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean decomposable(double[][] A) {
        return Cholesky.decomposable(A, 1.0E-14);
    }
}

