/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Householder {
    public static double decompose(double[][] A, double[] d, double[] t) {
        int r = A.length;
        int c = A[0].length;
        if (t == null) {
            t = new double[c];
        }
        double det = 1.0;
        for (int k = 0; k < c && k < r; ++k) {
            int j;
            double sgn = A[k][k];
            double s = sgn * sgn;
            double akk = Math.sqrt(s);
            sgn = akk != 0.0 ? (sgn /= akk) : 1.0;
            for (int i = k + 1; i < r; ++i) {
                double s_ = A[i][k];
                s += s_ * s_;
            }
            s = Math.sqrt(s);
            double b = Math.sqrt(1.0 / (2.0 * s * (s + akk)));
            double a = sgn * s;
            d[k] = -a;
            det *= a;
            double[] dArray = A[k];
            int n = k;
            dArray[n] = dArray[n] + a;
            for (int i = k; i < r; ++i) {
                double[] dArray2 = A[i];
                int n2 = k;
                dArray2[n2] = dArray2[n2] * b;
            }
            for (j = k + 1; j < c; ++j) {
                double s_ = 0.0;
                for (int i = k; i < r; ++i) {
                    s_ += A[i][k] * A[i][j];
                }
                t[j] = 2.0 * s_;
            }
            for (j = k + 1; j < c; ++j) {
                for (int i = k; i < r; ++i) {
                    double[] dArray3 = A[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] - A[i][k] * t[j];
                }
            }
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] Q, double[] t0, double[] t1) {
        int i;
        int j;
        int r = A.length;
        int c = A[0].length;
        int n = Q[0].length;
        double det = Householder.decompose(A, t0, t1);
        for (j = 0; j < n; ++j) {
            Q[0][j] = 0.0;
        }
        for (i = 1; i < r; ++i) {
            System.arraycopy(Q[0], 0, Q[i], 0, n);
        }
        for (i = 0; i < n; ++i) {
            Q[i][i] = 1.0;
        }
        Householder.qTimes(A, Q, false, t1);
        for (j = 0; j < c; ++j) {
            A[c - 1][j] = 0.0;
        }
        for (i = 1; i < c - 1; ++i) {
            System.arraycopy(A[c - 1], 0, A[i], 0, i);
        }
        for (i = c; i < r; ++i) {
            System.arraycopy(A[c - 1], 0, A[i], 0, c);
        }
        for (i = 0; i < c; ++i) {
            A[i][i] = t0[i];
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] Q, double[][] R) {
        int r = A.length;
        int c = A[0].length;
        for (int i = 0; i < r; ++i) {
            System.arraycopy(A[i], 0, R[i], 0, c);
        }
        double[] t0 = new double[c];
        double[] t1 = new double[r];
        double det = Householder.decompose(R, Q, t0, t1);
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[] d_re, double[] d_im, double[] t0, double[] t1) {
        int r = A_re.length;
        int c = A_re[0].length;
        if (t0 == null) {
            t0 = new double[c];
        }
        if (t1 == null) {
            t1 = new double[c];
        }
        double[] det = new double[]{1.0, 0.0};
        for (int k = 0; k < c && k < r; ++k) {
            int j;
            double sgn_re = A_re[k][k];
            double sgn_im = A_im[k][k];
            double s = sgn_re * sgn_re + sgn_im * sgn_im;
            double a = Math.sqrt(s);
            if (a != 0.0) {
                sgn_re /= a;
                sgn_im /= a;
            } else {
                sgn_re = 1.0;
                sgn_im = 0.0;
            }
            for (int i = k + 1; i < r; ++i) {
                double s_re = A_re[i][k];
                double s_im = A_im[i][k];
                s += s_re * s_re + s_im * s_im;
            }
            s = Math.sqrt(s);
            double b = Math.sqrt(1.0 / (2.0 * s * (s + a)));
            double akk_re = sgn_re * s;
            double akk_im = sgn_im * s;
            d_re[k] = -akk_re;
            d_im[k] = -akk_im;
            a = det[0] * akk_re - det[1] * akk_im;
            det[1] = det[0] * akk_im + det[1] * akk_re;
            det[0] = a;
            double[] dArray = A_re[k];
            int n = k;
            dArray[n] = dArray[n] + akk_re;
            double[] dArray2 = A_im[k];
            int n2 = k;
            dArray2[n2] = dArray2[n2] + akk_im;
            for (int i = k; i < r; ++i) {
                double[] dArray3 = A_re[i];
                int n3 = k;
                dArray3[n3] = dArray3[n3] * b;
                double[] dArray4 = A_im[i];
                int n4 = k;
                dArray4[n4] = dArray4[n4] * b;
            }
            for (j = k + 1; j < c; ++j) {
                double s_re = 0.0;
                double s_im = 0.0;
                for (int i = k; i < r; ++i) {
                    double a_re = A_re[i][k];
                    double a_im = -A_im[i][k];
                    double b_re = A_re[i][j];
                    double b_im = A_im[i][j];
                    s_re += a_re * b_re - a_im * b_im;
                    s_im += a_im * b_re + a_re * b_im;
                }
                t0[j] = 2.0 * s_re;
                t1[j] = 2.0 * s_im;
            }
            for (j = k + 1; j < c; ++j) {
                for (int i = k; i < r; ++i) {
                    double a_re = A_re[i][k];
                    double a_im = A_im[i][k];
                    double b_re = t0[j];
                    double b_im = t1[j];
                    double[] dArray5 = A_re[i];
                    int n5 = j;
                    dArray5[n5] = dArray5[n5] - (a_re * b_re - a_im * b_im);
                    double[] dArray6 = A_im[i];
                    int n6 = j;
                    dArray6[n6] = dArray6[n6] - (a_im * b_re + a_re * b_im);
                }
            }
        }
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] Q_re, double[][] Q_im, double[] t0, double[] t1, double[] t2, double[] t3) {
        int i;
        int j;
        int r = A_re.length;
        int c = A_re[0].length;
        int n = Q_re[0].length;
        double[] det = Householder.decompose(A_re, A_im, t0, t1, t2, t3);
        for (j = 0; j < n; ++j) {
            Q_re[0][j] = 0.0;
        }
        System.arraycopy(Q_re[0], 0, Q_im[0], 0, n);
        for (i = 1; i < r; ++i) {
            System.arraycopy(Q_re[0], 0, Q_re[i], 0, n);
            System.arraycopy(Q_im[0], 0, Q_im[i], 0, n);
        }
        for (i = 0; i < n; ++i) {
            Q_re[i][i] = 1.0;
        }
        Householder.qTimes(A_re, A_im, Q_re, Q_im, false, t2, t3);
        for (j = 0; j < c; ++j) {
            A_re[c - 1][j] = 0.0;
        }
        System.arraycopy(A_re[c - 1], 0, A_im[c - 1], 0, c);
        for (i = 1; i < c - 1; ++i) {
            System.arraycopy(A_re[c - 1], 0, A_re[i], 0, i);
            System.arraycopy(A_im[c - 1], 0, A_im[i], 0, i);
        }
        for (i = c; i < r; ++i) {
            System.arraycopy(A_re[c - 1], 0, A_re[i], 0, c);
            System.arraycopy(A_im[c - 1], 0, A_im[i], 0, c);
        }
        for (i = 0; i < c; ++i) {
            A_re[i][i] = t0[i];
            A_im[i][i] = t1[i];
        }
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] Q_re, double[][] Q_im, double[][] R_re, double[][] R_im) {
        int r = A_re.length;
        int c = A_re[0].length;
        for (int i = 0; i < r; ++i) {
            System.arraycopy(A_re[i], 0, R_re[i], 0, c);
            System.arraycopy(A_im[i], 0, R_im[i], 0, c);
        }
        double[] t0_re = new double[c];
        double[] t0_im = new double[c];
        double[] t1_re = new double[r];
        double[] t1_im = new double[r];
        double[] det = Householder.decompose(R_re, R_im, Q_re, Q_im, t0_re, t0_im, t1_re, t1_im);
        return det;
    }

    public static void qTimes(double[][] Q, double[] a, boolean conj) {
        int r = Q.length;
        int c = Q[0].length;
        for (int l = 0; l < c; ++l) {
            int i;
            int k = conj ? l : c - 1 - l;
            double t = 0.0;
            for (i = k; i < r; ++i) {
                t += Q[i][k] * a[i];
            }
            t *= 2.0;
            for (i = k; i < r; ++i) {
                int n = i;
                a[n] = a[n] - Q[i][k] * t;
            }
        }
    }

    public static void qTimes(double[][] Q_re, double[][] Q_im, double[] a_re, double[] a_im, boolean conj) {
        int r = Q_re.length;
        int c = Q_re[0].length;
        for (int l = 0; l < c; ++l) {
            double a__im;
            double a__re;
            int i;
            int k = conj ? l : c - 1 - l;
            double t_re = 0.0;
            double t_im = 0.0;
            for (i = k; i < r; ++i) {
                a__re = Q_re[i][k];
                a__im = -Q_im[i][k];
                double b_re = a_re[i];
                double b_im = a_im[i];
                t_re += a__re * b_re - a__im * b_im;
                t_im += a__im * b_re + a__re * b_im;
            }
            t_re *= 2.0;
            t_im *= 2.0;
            i = k;
            while (i < r) {
                a__re = Q_re[i][k];
                a__im = Q_im[i][k];
                int n = i;
                a_re[n] = a_re[n] - (a__re * t_re - a__im * t_im);
                int n2 = i++;
                a_im[n2] = a_im[n2] - (a__im * t_re + a__re * t_im);
            }
        }
    }

    public static void qTimes(double[][] Q, double[][] A, boolean conj, double[] t) {
        int r = Q.length;
        int c = Q[0].length;
        int n = A[0].length;
        if (t == null) {
            t = new double[n];
        }
        for (int l = 0; l < c; ++l) {
            int k = conj ? l : c - 1 - l;
            for (int j = 0; j < n; ++j) {
                double s = 0.0;
                for (int i = k; i < r; ++i) {
                    s += Q[i][k] * A[i][j];
                }
                t[j] = 2.0 * s;
            }
            for (int i = k; i < r; ++i) {
                for (int j = 0; j < n; ++j) {
                    double[] dArray = A[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - Q[i][k] * t[j];
                }
            }
        }
    }

    public static void qTimes(double[][] Q_re, double[][] Q_im, double[][] A_re, double[][] A_im, boolean conj, double[] t0, double[] t1) {
        int r = Q_re.length;
        int c = Q_re[0].length;
        int n = A_re[0].length;
        if (t0 == null) {
            t0 = new double[n];
        }
        if (t1 == null) {
            t1 = new double[n];
        }
        for (int l = 0; l < c; ++l) {
            int k = conj ? l : c - 1 - l;
            for (int j = 0; j < n; ++j) {
                double s_re = 0.0;
                double s_im = 0.0;
                for (int i = k; i < r; ++i) {
                    double a_re = Q_re[i][k];
                    double a_im = -Q_im[i][k];
                    double b_re = A_re[i][j];
                    double b_im = A_im[i][j];
                    s_re += a_re * b_re - a_im * b_im;
                    s_im += a_im * b_re + a_re * b_im;
                }
                t0[j] = 2.0 * s_re;
                t1[j] = 2.0 * s_im;
            }
            for (int i = k; i < r; ++i) {
                int j = 0;
                while (j < n) {
                    double a_re = Q_re[i][k];
                    double a_im = Q_im[i][k];
                    double b_re = t0[j];
                    double b_im = t1[j];
                    double[] dArray = A_re[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (a_re * b_re - a_im * b_im);
                    double[] dArray2 = A_im[i];
                    int n3 = j++;
                    dArray2[n3] = dArray2[n3] - (a_im * b_re + a_re * b_im);
                }
            }
        }
    }
}

