/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

import de.jtem.numericalMethods.algebra.linear.decompose.Unmerge;

public class PLR {
    public static double decompose(int[] p, double[][] A) {
        int n = A.length;
        for (int i = 0; i < n; ++i) {
            p[i] = i;
        }
        double det = 1.0;
        for (int k = 0; k < n; ++k) {
            int i;
            double abs = Math.abs(A[k][k]);
            int piv = k;
            for (i = k + 1; i < n; ++i) {
                double t = Math.abs(A[i][k]);
                if (!(t > abs)) continue;
                piv = i;
                abs = t;
            }
            if (k != piv) {
                det *= -1.0;
                int pk = p[k];
                p[k] = p[piv];
                p[piv] = pk;
                double[] Ak = A[k];
                A[k] = A[piv];
                A[piv] = Ak;
            }
            det *= A[k][k];
            for (i = k + 1; i < n; ++i) {
                if (abs != 0.0) {
                    double[] dArray = A[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] / A[k][k];
                } else {
                    A[i][k] = 0.0;
                }
                for (int j = k + 1; j < n; ++j) {
                    double[] dArray = A[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - A[i][k] * A[k][j];
                }
            }
        }
        return det;
    }

    public static double decompose(int[][] P, double[][] A, double[][] L, double[][] R) {
        int n = A.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                L[i][j] = A[i][j];
            }
        }
        int[] p = new int[n];
        double det = PLR.decompose(p, L);
        Unmerge.triangular(L, R);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                P[i][j] = 0;
            }
            P[i][p[i]] = 1;
        }
        return det;
    }

    public static double[] decompose(int[] p, double[][] A_re, double[][] A_im) {
        int n = A_re.length;
        for (int i = 0; i < n; ++i) {
            p[i] = i;
        }
        double[] det = new double[]{1.0, 0.0};
        for (int k = 0; k < n; ++k) {
            int piv = k;
            double x_re = A_re[piv][k];
            double x_im = A_im[piv][k];
            double abs = x_re * x_re + x_im * x_im;
            for (int i = k + 1; i < n; ++i) {
                double a_re = A_re[i][k];
                double a_im = A_im[i][k];
                double t = a_re * a_re + a_im * a_im;
                if (!(t > abs)) continue;
                piv = i;
                abs = t;
            }
            if (k != piv) {
                det[0] = det[0] * -1.0;
                det[1] = det[1] * -1.0;
                int pk = p[k];
                p[k] = p[piv];
                p[piv] = pk;
                double[] Ak = A_re[k];
                A_re[k] = A_re[piv];
                A_re[piv] = Ak;
                Ak = A_im[k];
                A_im[k] = A_im[piv];
                A_im[piv] = Ak;
            }
            double d0 = det[0] * A_re[k][k] - det[1] * A_im[k][k];
            det[1] = det[0] * A_im[k][k] + det[1] * A_re[k][k];
            det[0] = d0;
            for (int i = k + 1; i < n; ++i) {
                if (abs != 0.0) {
                    double a_re = A_re[i][k];
                    double a_im = A_im[i][k];
                    double b_re = A_re[k][k];
                    double b_im = -A_im[k][k];
                    double t = b_re * b_re + b_im * b_im;
                    A_re[i][k] = (a_re * b_re - a_im * b_im) / t;
                    A_im[i][k] = (a_im * b_re + a_re * b_im) / t;
                } else {
                    A_re[i][k] = 0.0;
                    A_im[i][k] = 0.0;
                }
                int j = k + 1;
                while (j < n) {
                    double a_re = A_re[i][k];
                    double a_im = A_im[i][k];
                    double b_re = A_re[k][j];
                    double b_im = A_im[k][j];
                    double[] dArray = A_re[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (a_re * b_re - a_im * b_im);
                    double[] dArray2 = A_im[i];
                    int n3 = j++;
                    dArray2[n3] = dArray2[n3] - (a_im * b_re + a_re * b_im);
                }
            }
        }
        return det;
    }

    public static double[] decompose(int[][] P, double[][] A_re, double[][] A_im, double[][] L_re, double[][] L_im, double[][] R_re, double[][] R_im) {
        int n = A_re.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                L_re[i][j] = A_re[i][j];
                L_im[i][j] = A_im[i][j];
            }
        }
        int[] p = new int[n];
        double[] det = PLR.decompose(p, L_re, L_im);
        Unmerge.triangular(L_re, L_im, R_re, R_im);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                P[i][j] = 0;
            }
            P[i][p[i]] = 1;
        }
        return det;
    }
}

