/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class QR {
    public static double decompose(double[][] Q, double[][] R) {
        int n = Q.length;
        double det = 1.0;
        for (int j = 0; j < n; ++j) {
            int i;
            for (int k = 0; k < j; ++k) {
                int i2;
                R[j][k] = 0.0;
                double t = 0.0;
                for (i2 = 0; i2 < n; ++i2) {
                    t += Q[i2][k] * Q[i2][j];
                }
                R[k][j] = t;
                for (i2 = 0; i2 < n; ++i2) {
                    double[] dArray = Q[i2];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - t * Q[i2][k];
                }
            }
            double t = 0.0;
            for (i = 0; i < n; ++i) {
                t += Q[i][j] * Q[i][j];
            }
            t = Math.sqrt(t);
            det *= t;
            R[j][j] = t;
            if (t != 0.0) {
                for (i = 0; i < n; ++i) {
                    double[] dArray = Q[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] / t;
                }
                continue;
            }
            for (i = 0; i < n; ++i) {
                Q[i][j] = 0.0;
            }
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] Q, double[][] R) {
        int n = A.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Q[i][j] = A[i][j];
            }
        }
        return QR.decompose(Q, R);
    }

    public static double[] decompose(double[][] Q_re, double[][] Q_im, double[][] R_re, double[][] R_im) {
        int n = Q_re.length;
        double det = 1.0;
        for (int j = 0; j < n; ++j) {
            int i;
            for (int i2 = 0; i2 < j; ++i2) {
                int k;
                R_re[j][i2] = 0.0;
                R_im[j][i2] = 0.0;
                double t_re = 0.0;
                double t_im = 0.0;
                for (k = 0; k < n; ++k) {
                    double a_re = Q_re[k][i2];
                    double a_im = -Q_im[k][i2];
                    double b_re = Q_re[k][j];
                    double b_im = Q_im[k][j];
                    t_re += a_re * b_re - a_im * b_im;
                    t_im += a_im * b_re + a_re * b_im;
                }
                R_re[i2][j] = t_re;
                R_im[i2][j] = t_im;
                for (k = 0; k < n; ++k) {
                    double b_re = Q_re[k][i2];
                    double b_im = Q_im[k][i2];
                    double[] dArray = Q_re[k];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (t_re * b_re - t_im * b_im);
                    double[] dArray2 = Q_im[k];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] - (t_im * b_re + t_re * b_im);
                }
            }
            double t = 0.0;
            for (i = 0; i < n; ++i) {
                t += Q_re[i][j] * Q_re[i][j] + Q_im[i][j] * Q_im[i][j];
            }
            t = Math.sqrt(t);
            det *= t;
            R_re[j][j] = t;
            R_im[j][j] = 0.0;
            if (t != 0.0) {
                for (i = 0; i < n; ++i) {
                    double[] dArray = Q_re[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] / t;
                    double[] dArray3 = Q_im[i];
                    int n5 = j;
                    dArray3[n5] = dArray3[n5] / t;
                }
                continue;
            }
            for (i = 0; i < n; ++i) {
                Q_re[i][j] = 0.0;
                Q_im[i][j] = 0.0;
            }
        }
        return new double[]{det, 0.0};
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] Q_re, double[][] Q_im, double[][] R_re, double[][] R_im) {
        int n = A_re.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Q_re[i][j] = A_re[i][j];
                Q_im[i][j] = A_im[i][j];
            }
        }
        return QR.decompose(Q_re, Q_im, R_re, R_im);
    }
}

