/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Singularvalue {
    private Singularvalue() {
    }

    public static void decompose(double[][] A, double[][] U, double[][] V, double[] S) {
        double[] cond = new double[1];
        double[] norm2 = new double[1];
        double[] rank = new double[1];
        Singularvalue.decompose(A, U, V, S, cond, norm2, rank);
    }

    public static void decompose(double[][] A, double[][] U, double[][] V, double[] S, double[] cond, double[] norm2, double[] rank) {
        int i;
        double t;
        int k;
        int j;
        int m = A.length;
        int n = A[0].length;
        int nu = Math.min(m, n);
        double[] e = new double[n];
        double[] work = new double[m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(m - 1, n);
        int nrt = Math.max(0, Math.min(n - 2, m));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            if (k2 < nct) {
                S[k2] = 0.0;
                for (i3 = k2; i3 < m; ++i3) {
                    S[k2] = Singularvalue.hypot(S[k2], A[i3][k2]);
                }
                if (S[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        S[k2] = -S[k2];
                    }
                    for (i3 = k2; i3 < m; ++i3) {
                        double[] dArray = A[i3];
                        int n2 = k2;
                        dArray[n2] = dArray[n2] / S[k2];
                    }
                    double[] dArray = A[k2];
                    int n3 = k2;
                    dArray[n3] = dArray[n3] + 1.0;
                }
                S[k2] = -S[k2];
            }
            for (j = k2 + 1; j < n; ++j) {
                if (k2 < nct & S[k2] != 0.0) {
                    double t2 = 0.0;
                    for (i2 = k2; i2 < m; ++i2) {
                        t2 += A[i2][k2] * A[i2][j];
                    }
                    t2 = -t2 / A[k2][k2];
                    for (i2 = k2; i2 < m; ++i2) {
                        double[] dArray = A[i2];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + t2 * A[i2][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (wantu & k2 < nct) {
                for (i3 = k2; i3 < m; ++i3) {
                    U[i3][k2] = A[i3][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0;
            for (i3 = k2 + 1; i3 < n; ++i3) {
                e[k2] = Singularvalue.hypot(e[k2], e[i3]);
            }
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i3 = k2 + 1;
                while (i3 < n) {
                    int n5 = i3++;
                    e[n5] = e[n5] / e[k2];
                }
                int n6 = k2 + 1;
                e[n6] = e[n6] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < m & e[k2] != 0.0) {
                for (i3 = k2 + 1; i3 < m; ++i3) {
                    work[i3] = 0.0;
                }
                for (j = k2 + 1; j < n; ++j) {
                    for (int i4 = k2 + 1; i4 < m; ++i4) {
                        int n7 = i4;
                        work[n7] = work[n7] + e[j] * A[i4][j];
                    }
                }
                for (j = k2 + 1; j < n; ++j) {
                    double t3 = -e[j] / e[k2 + 1];
                    for (i2 = k2 + 1; i2 < m; ++i2) {
                        double[] dArray = A[i2];
                        int n8 = j;
                        dArray[n8] = dArray[n8] + t3 * work[i2];
                    }
                }
            }
            if (!wantv) continue;
            for (i3 = k2 + 1; i3 < n; ++i3) {
                V[i3][k2] = e[i3];
            }
        }
        int p = Math.min(n, m + 1);
        if (nct < n) {
            S[nct] = A[nct][nct];
        }
        if (m < p) {
            S[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            for (j = nct; j < nu; ++j) {
                for (int i5 = 0; i5 < m; ++i5) {
                    U[i5][j] = 0.0;
                }
                U[j][j] = 1.0;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i6;
                if (S[k] != 0.0) {
                    for (int j2 = k + 1; j2 < nu; ++j2) {
                        t = 0.0;
                        for (i = k; i < m; ++i) {
                            t += U[i][k] * U[i][j2];
                        }
                        t = -t / U[k][k];
                        for (i = k; i < m; ++i) {
                            double[] dArray = U[i];
                            int n9 = j2;
                            dArray[n9] = dArray[n9] + t * U[i][k];
                        }
                    }
                    for (i6 = k; i6 < m; ++i6) {
                        U[i6][k] = -U[i6][k];
                    }
                    U[k][k] = 1.0 + U[k][k];
                    for (i6 = 0; i6 < k - 1; ++i6) {
                        U[i6][k] = 0.0;
                    }
                    continue;
                }
                for (i6 = 0; i6 < m; ++i6) {
                    U[i6][k] = 0.0;
                }
                U[k][k] = 1.0;
            }
        }
        if (wantv) {
            for (k = n - 1; k >= 0; --k) {
                if (k < nrt & e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        t = 0.0;
                        for (i = k + 1; i < n; ++i) {
                            t += V[i][k] * V[i][j3];
                        }
                        t = -t / V[k + 1][k];
                        for (i = k + 1; i < n; ++i) {
                            double[] dArray = V[i];
                            int n10 = j3;
                            dArray[n10] = dArray[n10] + t * V[i][k];
                        }
                    }
                }
                for (int i7 = 0; i7 < n; ++i7) {
                    V[i7][k] = 0.0;
                }
                V[k][k] = 1.0;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= tiny + eps * (Math.abs(S[k3]) + Math.abs(S[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(S[ks]) <= tiny + eps * t4)) continue;
                    S[ks] = 0.0;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = Singularvalue.hypot(S[j4], f);
                        cs = S[j4] / t5;
                        sn = f / t5;
                        S[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        for (i8 = 0; i8 < n; ++i8) {
                            t5 = cs * V[i8][j4] + sn * V[i8][p - 1];
                            V[i8][p - 1] = -sn * V[i8][j4] + cs * V[i8][p - 1];
                            V[i8][j4] = t5;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = Singularvalue.hypot(S[j5], f);
                        cs = S[j5] / t5;
                        sn = f / t5;
                        S[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        for (i8 = 0; i8 < m; ++i8) {
                            t5 = cs * U[i8][j5] + sn * U[i8][k3 - 1];
                            U[i8][k3 - 1] = -sn * U[i8][j5] + cs * U[i8][k3 - 1];
                            U[i8][j5] = t5;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(S[p - 1]), Math.abs(S[p - 2])), Math.abs(e[p - 2])), Math.abs(S[k3])), Math.abs(e[k3]));
                    double sp = S[p - 1] / scale;
                    double spm1 = S[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = S[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i9;
                        double t6 = Singularvalue.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * S[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * S[j6];
                        g = sn * S[j6 + 1];
                        S[j6 + 1] = cs * S[j6 + 1];
                        if (wantv) {
                            for (i9 = 0; i9 < n; ++i9) {
                                t6 = cs * V[i9][j6] + sn * V[i9][j6 + 1];
                                V[i9][j6 + 1] = -sn * V[i9][j6] + cs * V[i9][j6 + 1];
                                V[i9][j6] = t6;
                            }
                        }
                        t6 = Singularvalue.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        S[j6] = t6;
                        f = cs * e[j6] + sn * S[j6 + 1];
                        S[j6 + 1] = -sn * e[j6] + cs * S[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= m - 1) continue;
                        for (i9 = 0; i9 < m; ++i9) {
                            t6 = cs * U[i9][j6] + sn * U[i9][j6 + 1];
                            U[i9][j6 + 1] = -sn * U[i9][j6] + cs * U[i9][j6 + 1];
                            U[i9][j6] = t6;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (S[k3] <= 0.0) {
                        double d = S[k3] = S[k3] < 0.0 ? -S[k3] : 0.0;
                        if (wantv) {
                            for (int i10 = 0; i10 <= pp; ++i10) {
                                V[i10][k3] = -V[i10][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(S[k3] >= S[k3 + 1])) {
                        int i11;
                        double t7 = S[k3];
                        S[k3] = S[k3 + 1];
                        S[k3 + 1] = t7;
                        if (wantv && k3 < n - 1) {
                            for (i11 = 0; i11 < n; ++i11) {
                                t7 = V[i11][k3 + 1];
                                V[i11][k3 + 1] = V[i11][k3];
                                V[i11][k3] = t7;
                            }
                        }
                        if (wantu && k3 < m - 1) {
                            for (i11 = 0; i11 < m; ++i11) {
                                t7 = U[i11][k3 + 1];
                                U[i11][k3 + 1] = U[i11][k3];
                                U[i11][k3] = t7;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        norm2[0] = S[0];
        cond[0] = S[0] / S[Math.min(m, n) - 1];
        double tol = (double)Math.max(m, n) * S[0] * eps;
        int r = 0;
        for (int i12 = 0; i12 < S.length; ++i12) {
            if (!(S[i12] > tol)) continue;
            ++r;
        }
        rank[0] = r;
    }

    private static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }
}

