/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Tridiagonal {
    private Tridiagonal() {
    }

    public static void transform(double[][] A, double[][] Q, double[] d, double[] e) {
        int l;
        int i;
        int n = A.length;
        if (A != Q) {
            for (i = 0; i < n; ++i) {
                System.arraycopy(A[i], 0, Q[i], 0, n);
            }
        }
        for (i = n - 1; i >= 1; --i) {
            l = i - 1;
            double h = 0.0;
            if (l > 1) {
                int k;
                double scale = 0.0;
                for (k = 0; k <= l; ++k) {
                    scale += Math.abs(Q[i][k]);
                }
                if (scale == 0.0) {
                    e[i] = Q[i][l];
                } else {
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = Q[i];
                        int n2 = k;
                        dArray[n2] = dArray[n2] / scale;
                        h += Q[i][k] * Q[i][k];
                    }
                    double f = Q[i][l];
                    double g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    e[i] = scale * g;
                    Q[i][l] = f - g;
                    h -= f * g;
                    double a = 0.0;
                    for (int j = 0; j <= l; ++j) {
                        int k2;
                        Q[j][i] = Q[i][j] / h;
                        double b = 0.0;
                        for (k2 = 0; k2 <= j; ++k2) {
                            b += Q[j][k2] * Q[i][k2];
                        }
                        for (k2 = j + 1; k2 <= l; ++k2) {
                            b += Q[k2][j] * Q[i][k2];
                        }
                        e[j] = b / h;
                        a += e[j] * Q[i][j];
                    }
                    double aBy2h = a / (h + h);
                    for (int j = 0; j <= l; ++j) {
                        double b = Q[i][j];
                        int n3 = j;
                        double d2 = e[n3] - aBy2h * b;
                        e[n3] = d2;
                        double c = d2;
                        for (int k3 = 0; k3 <= j; ++k3) {
                            double[] dArray = Q[j];
                            int n4 = k3;
                            dArray[n4] = dArray[n4] - (b * e[k3] + c * Q[i][k3]);
                        }
                    }
                }
            } else {
                e[i] = Q[i][l];
            }
            d[i] = h;
        }
        d[1] = 0.0;
        e[1] = 0.0;
        for (i = 0; i < n; ++i) {
            int j;
            l = i - 1;
            if (d[i] != 0.0) {
                for (j = 0; j <= l; ++j) {
                    int k;
                    double g = 0.0;
                    for (k = 0; k <= l; ++k) {
                        g += Q[i][k] * Q[k][j];
                    }
                    for (k = 0; k <= l; ++k) {
                        double[] dArray = Q[k];
                        int n5 = j;
                        dArray[n5] = dArray[n5] - g * Q[k][i];
                    }
                }
            }
            d[i] = Q[i][i];
            Q[i][i] = 1.0;
            for (j = 0; j <= l; ++j) {
                Q[i][j] = 0.0;
                Q[j][i] = 0.0;
            }
        }
    }

    public static void transform(double[][] A, double[][] Q, double[][] T) {
        int i;
        double[] d = T[0];
        double[] e = T[1];
        Tridiagonal.transform(A, Q, d, e);
        int n = A.length;
        T[1][0] = e[1];
        T[1][1] = d[1];
        T[0][1] = T[1][0];
        for (i = 2; i < n; ++i) {
            T[i][i] = d[i];
            double d2 = e[i];
            T[i - 1][i] = d2;
            T[i][i - 1] = d2;
        }
        for (i = 0; i < n; ++i) {
            int k;
            for (k = 0; k < i - 1; ++k) {
                T[i][k] = 0.0;
            }
            for (k = i + 2; k < n; ++k) {
                T[i][k] = 0.0;
            }
        }
    }
}

