/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.solve;

public class LXB {
    public static boolean solve(double[][] L, double[] b) {
        int i = 0;
        while (i < L[0].length) {
            for (int k = 0; k < i; ++k) {
                int n = i;
                b[n] = b[n] - b[k] * L[i][k];
            }
            double t = L[i][i];
            if (t == 0.0) {
                return false;
            }
            int n = i++;
            b[n] = b[n] / t;
        }
        return true;
    }

    public static boolean solve(double[][] L, double[] x, double[] b) {
        System.arraycopy(b, 0, x, 0, x.length);
        return LXB.solve(L, x);
    }

    public static boolean solve(double[][] L_re, double[][] L_im, double[] b_re, double[] b_im) {
        for (int i = 0; i < L_re[0].length; ++i) {
            for (int k = 0; k < i; ++k) {
                double x_re = b_re[k];
                double x_im = b_im[k];
                double y_re = L_re[i][k];
                double y_im = L_im[i][k];
                int n = i;
                b_re[n] = b_re[n] - (x_re * y_re - x_im * y_im);
                int n2 = i;
                b_im[n2] = b_im[n2] - (x_im * y_re + x_re * y_im);
            }
            double y_re = L_re[i][i];
            double y_im = -L_im[i][i];
            double t = y_re * y_re + y_im * y_im;
            if (t == 0.0) {
                return false;
            }
            double x_re = b_re[i];
            double x_im = b_im[i];
            b_re[i] = (x_re * y_re - x_im * y_im) / t;
            b_im[i] = (x_im * y_re + x_re * y_im) / t;
        }
        return true;
    }

    public static boolean solve(double[][] L_re, double[][] L_im, double[] x_re, double[] x_im, double[] b_re, double[] b_im) {
        int n = x_re.length;
        System.arraycopy(b_re, 0, x_re, 0, n);
        System.arraycopy(b_im, 0, x_im, 0, n);
        return LXB.solve(L_re, L_im, x_re, x_im);
    }

    public static boolean solve(double[][] L, double[][] B) {
        int n = B[0].length;
        for (int i = 0; i < L[0].length; ++i) {
            for (int k = 0; k < i; ++k) {
                for (int j = 0; j < n; ++j) {
                    double[] dArray = B[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - B[k][j] * L[i][k];
                }
            }
            double t = L[i][i];
            if (t == 0.0) {
                return false;
            }
            int j = 0;
            while (j < n) {
                double[] dArray = B[i];
                int n3 = j++;
                dArray[n3] = dArray[n3] / t;
            }
        }
        return true;
    }

    public static boolean solve(double[][] L, double[][] X, double[][] B) {
        int n = X[0].length;
        for (int i = 0; i < X.length; ++i) {
            System.arraycopy(B[i], 0, X[i], 0, n);
        }
        return LXB.solve(L, X);
    }

    public static boolean solve(double[][] L_re, double[][] L_im, double[][] B_re, double[][] B_im) {
        int n = B_re[0].length;
        for (int i = 0; i < L_re[0].length; ++i) {
            for (int k = 0; k < i; ++k) {
                int j = 0;
                while (j < n) {
                    double a_re = B_re[k][j];
                    double a_im = B_im[k][j];
                    double b_re = L_re[i][k];
                    double b_im = L_im[i][k];
                    double[] dArray = B_re[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (a_re * b_re - a_im * b_im);
                    double[] dArray2 = B_im[i];
                    int n3 = j++;
                    dArray2[n3] = dArray2[n3] - (a_im * b_re + a_re * b_im);
                }
            }
            double b_re = L_re[i][i];
            double b_im = -L_im[i][i];
            double t = b_re * b_re + b_im * b_im;
            if (t == 0.0) {
                return false;
            }
            for (int j = 0; j < n; ++j) {
                double a_re = B_re[i][j];
                double a_im = B_im[i][j];
                B_re[i][j] = (a_re * b_re - a_im * b_im) / t;
                B_im[i][j] = (a_im * b_re + a_re * b_im) / t;
            }
        }
        return true;
    }

    public static boolean solve(double[][] L_re, double[][] L_im, double[][] X_re, double[][] X_im, double[][] B_re, double[][] B_im) {
        int n = X_re[0].length;
        for (int i = 0; i < X_re.length; ++i) {
            System.arraycopy(B_re[i], 0, X_re[i], 0, n);
            System.arraycopy(B_im[i], 0, X_im[i], 0, n);
        }
        return LXB.solve(L_re, L_im, X_re, X_im);
    }
}

