/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.loopGroup;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;

public class IwasawaFactorization {
    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, int blockSize) {
        int n = xRe.length;
        int N = xRe[0][0].length / 2;
        int R = blockSize;
        int rows = 2 * N + 1 + R;
        int m = rows * n;
        int r = R * n;
        double[][] uRe = new double[m][r];
        double[][] uIm = new double[m][r];
        double[] dRe = new double[r];
        double[] dIm = new double[r];
        double[] pRe = new double[m];
        double[] pIm = new double[m];
        double[][] zRe = new double[n][m];
        double[][] zIm = new double[n][m];
        double[][] gRe = new double[m][n];
        double[][] gIm = new double[m][n];
        IwasawaFactorization.factor(xRe, xIm, fRe, fIm, uRe, uIm, dRe, dIm, pRe, pIm, zRe, zIm, gRe, gIm, blockSize);
    }

    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, double[][] uRe, double[][] uIm, double[] dRe, double[] dIm, double[] pRe, double[] pIm, double[][] zRe, double[][] zIm, double[][] gRe, double[][] gIm, int blockSize) {
        int i;
        if (blockSize <= 0) {
            throw new IllegalArgumentException("blockSize must be positive");
        }
        int n = xRe.length;
        int N = (xRe[0][0].length - 1) / 2;
        int R = blockSize;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < n; ++j) {
                IwasawaFactorization.setBlock(xRe[i2][j], uRe, i2, j, N, R);
                IwasawaFactorization.setBlock(xIm[i2][j], uIm, i2, j, N, R);
            }
        }
        double[] t = Householder.decompose(uRe, uIm, dRe, dIm, pRe, pIm);
        if (t[0] == 0.0 && t[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j < n; ++j) {
                IwasawaFactorization.setBlock(xRe[j][i3], zRe[i3], j, N, R);
                IwasawaFactorization.setBlock(xIm[j][i3], zIm[i3], j, N, R);
            }
            VectorOperations.assign(zRe[i3], pRe);
            VectorOperations.assign(zIm[i3], pIm);
            Householder.qTimes(uRe, uIm, pRe, pIm, true);
            for (int k = R * n; k < pRe.length; ++k) {
                pIm[k] = 0.0;
                pRe[k] = 0.0;
            }
            Householder.qTimes(uRe, uIm, pRe, pIm, false);
            VectorOperations.minus(zRe[i3], pRe, zRe[i3]);
            VectorOperations.minus(zIm[i3], pIm, zIm[i3]);
        }
        MatrixOperations.transpose(zRe, gRe);
        MatrixOperations.transpose(zIm, gIm);
        double[] T = Householder.decompose(gRe, gIm, dRe, dIm, pRe, pIm);
        if (T[0] == 0.0 && T[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        for (i = 0; i < n; ++i) {
            IwasawaFactorization.assignZero(zRe[i]);
            IwasawaFactorization.assignZero(zIm[i]);
            zRe[i][i] = 1.0;
            Householder.qTimes(gRe, gIm, zRe[i], zIm[i], false);
        }
        for (i = 0; i < n; ++i) {
            double absOfD = Math.sqrt(dRe[i] * dRe[i] + dIm[i] * dIm[i]);
            double nRe = dRe[i] / absOfD;
            double nIm = dIm[i] / absOfD;
            VectorOperations.times(zRe[i], zIm[i], nRe, nIm, zRe[i], zIm[i]);
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                IwasawaFactorization.getBlock(fRe[j][i], zRe[i], j, N, R);
                IwasawaFactorization.getBlock(fIm[j][i], zIm[i], j, N, R);
            }
        }
    }

    public static void positivePart(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, double[][][] bRe, double[][][] bIm) {
        int N = xRe[0][0].length;
        double[] tmpRe = new double[N + 1];
        double[] tmpIm = new double[N + 1];
        IwasawaFactorization.positivePart(xRe, xIm, fRe, fIm, bRe, bIm, tmpRe, tmpIm);
    }

    public static void positivePart(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, double[][][] bRe, double[][][] bIm, double[] tmpRe, double[] tmpIm) {
        IwasawaFactorization.times(fRe, fIm, xRe, xIm, bRe, bIm, tmpRe, tmpIm);
    }

    private static void times(double[][][] fRe, double[][][] fIm, double[][][] xRe, double[][][] xIm, double[][][] bRe, double[][][] bIm, double[] tmpRe, double[] tmpIm) {
        int n = fRe.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                IwasawaFactorization.polynomialTimes(fRe[0][i], fIm[0][i], xRe[0][j], xIm[0][j], bRe[i][j], bIm[i][j]);
                for (int k = 1; k < n; ++k) {
                    IwasawaFactorization.polynomialTimes(fRe[k][i], fIm[k][i], xRe[k][j], xIm[k][j], tmpRe, tmpIm);
                    VectorOperations.plus(bRe[i][j], tmpRe, bRe[i][j]);
                    VectorOperations.plus(bIm[i][j], tmpIm, bIm[i][j]);
                }
            }
        }
    }

    private static void polynomialTimes(double[] fRe, double[] fIm, double[] xRe, double[] xIm, double[] bRe, double[] bIm) {
        if (fRe == bRe || xRe == bRe) {
            throw new IllegalArgumentException();
        }
        int N = (fRe.length - 1) / 2;
        for (int i = 0; i <= N; ++i) {
            double br = 0.0;
            double bi = 0.0;
            for (int j = 0; j <= 2 * N - i; ++j) {
                br += fRe[j] * xRe[i + j] + fIm[j] * xIm[i + j];
                bi += fRe[j] * xIm[i + j] - fIm[j] * xRe[i + j];
            }
            bRe[i] = br;
            bIm[i] = bi;
        }
    }

    private static void setBlock(double[] coeff, double[][] m, int row, int col, int N, int R) {
        int rows = 2 * N + 1 + R;
        int rowOffset = row * (2 * N + 1 + R);
        int colOffset = col * R;
        for (int j = 0; j < R; ++j) {
            int i;
            int p0 = j + 1;
            int p1 = Math.min(rows, 2 * N + 2 + j);
            for (i = 0; i < p0; ++i) {
                m[i + rowOffset][j + colOffset] = 0.0;
            }
            for (i = p0; i < p1; ++i) {
                m[i + rowOffset][j + colOffset] = coeff[i - j - 1];
            }
            for (i = p1; i < rows; ++i) {
                m[i + rowOffset][j + colOffset] = 0.0;
            }
        }
    }

    private static void setBlock(double[] coeff, double[] x, int row, int N, int R) {
        int i;
        System.arraycopy(coeff, 0, x, row * (2 * N + 1 + R), 2 * N + 1);
        int last = i + R;
        for (i = row * (2 * N + 1 + R) + 2 * N + 1; i < last; ++i) {
            x[i] = 0.0;
        }
    }

    private static void getBlock(double[] coeff, double[] x, int row, int N, int R) {
        System.arraycopy(x, row * (2 * N + 1 + R), coeff, 0, 2 * N + 1);
    }

    private static void assignZero(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = 0.0;
        }
    }
}

