/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.polynomial;

public final class ComplexPolynomial {
    private static final double EPS = 1.0E-14;

    public static void eval(double[] aRe, double[] aIm, int degOfA, double x, double y, double[] aAtZ) {
        ComplexPolynomial.eval(aRe, aIm, 0, degOfA, x, y, aAtZ);
    }

    public static void eval(double[] aRe, double[] aIm, int offsetOfA, int degOfA, double x, double y, double[] aAtZ) {
        if (degOfA < -offsetOfA) {
            aAtZ[0] = 0.0;
            aAtZ[1] = 0.0;
            return;
        }
        double resultRe = aRe[offsetOfA + degOfA];
        double resultIm = aIm[offsetOfA + degOfA];
        if (degOfA > 0) {
            int i = degOfA - 1;
            for (int index = i + offsetOfA; index >= 0 && i >= 0; --i, --index) {
                double bRe = resultRe;
                double bIm = resultIm;
                resultRe = bRe * x - bIm * y + aRe[index];
                resultIm = bRe * y + bIm * x + aIm[index];
            }
            while (i >= 0) {
                double bRe = resultRe;
                double bIm = resultIm;
                resultRe = bRe * x - bIm * y;
                resultIm = bRe * y + bIm * x;
                --i;
            }
        }
        aAtZ[0] = resultRe;
        aAtZ[1] = resultIm;
    }

    public static void evalDerivative(double[] aRe, double[] aIm, int degOfA, int n, double x, double y, double[] dAAtZ) {
        ComplexPolynomial.evalDerivative(aRe, aIm, 0, degOfA, n, x, y, dAAtZ);
    }

    public static void evalDerivative(double[] aRe, double[] aIm, int offsetOfA, int degOfA, int n, double x, double y, double[] dAAtZ) {
        if (degOfA < -offsetOfA || degOfA < n) {
            dAAtZ[0] = 0.0;
            dAAtZ[1] = 0.0;
            return;
        }
        double factor = 1.0;
        for (int i = degOfA; i > degOfA - n; --i) {
            factor *= (double)i;
        }
        double resultRe = factor * aRe[offsetOfA + degOfA];
        double resultIm = factor * aIm[offsetOfA + degOfA];
        if (degOfA > 0) {
            int e = degOfA - 1;
            for (int index = e + offsetOfA; index >= 0 && e >= n; --e, --index) {
                factor *= (double)(e + 1 - n);
                double bRe = resultRe;
                double bIm = resultIm;
                resultRe = bRe * x - bIm * y + (factor /= (double)(e + 1)) * aRe[index];
                resultIm = bRe * y + bIm * x + factor * aIm[index];
            }
            while (e >= n) {
                double bRe = resultRe;
                double bIm = resultIm;
                resultRe = bRe * x - bIm * y;
                resultIm = bRe * y + bIm * x;
                --e;
            }
        }
        dAAtZ[0] = resultRe;
        dAAtZ[1] = resultIm;
    }

    public static int calcDeg(double[] aRe, double[] aIm, int degOfA) {
        for (int i = degOfA; i >= 0; --i) {
            if (!(aRe[i] * aRe[i] + aIm[i] * aIm[i] >= 1.0E-28)) continue;
            return i;
        }
        return -1;
    }

    public static void multiplyToConst(double lr, double li, double[] aRe, double[] aIm, int degOfA, double[] cRe, double[] cIm) {
        for (int i = 0; i <= degOfA; ++i) {
            double ar = aRe[i];
            double ai = aIm[i];
            cRe[i] = lr * ar - li * ai;
            cIm[i] = lr * ai + li * ar;
        }
    }

    public static void plus(double[] aRe, double[] aIm, int degOfA, double[] bRe, double[] bIm, int degOfB, double[] cRe, double[] cIm) {
        if (degOfA == degOfB) {
            for (int i = 0; i <= degOfA; ++i) {
                cRe[i] = aRe[i] + bRe[i];
                cIm[i] = aIm[i] + bIm[i];
            }
        } else if (degOfA < degOfB) {
            for (int i = 0; i <= degOfA; ++i) {
                cRe[i] = aRe[i] + bRe[i];
                cIm[i] = aIm[i] + bIm[i];
            }
            System.arraycopy(bRe, degOfA + 1, cRe, degOfA + 1, degOfB - degOfA);
            System.arraycopy(bIm, degOfA + 1, cIm, degOfA + 1, degOfB - degOfA);
        } else {
            for (int i = 0; i <= degOfB; ++i) {
                cRe[i] = aRe[i] + bRe[i];
                cIm[i] = aIm[i] + bIm[i];
            }
            System.arraycopy(aRe, degOfB + 1, cRe, degOfB + 1, degOfA - degOfB);
            System.arraycopy(aIm, degOfB + 1, cIm, degOfB + 1, degOfA - degOfB);
        }
    }

    public static void linComb(double lr, double li, double[] aRe, double[] aIm, int degOfA, double mr, double mi, double[] bRe, double[] bIm, int degOfB, double[] cRe, double[] cIm) {
        if (degOfA == degOfB) {
            for (int i = 0; i <= degOfA; ++i) {
                double ar = aRe[i];
                double ai = aIm[i];
                double br = bRe[i];
                double bi = bIm[i];
                cRe[i] = lr * ar - li * ai + mr * br - mi * bi;
                cIm[i] = lr * ai + li * ar + mr * bi + mi * br;
            }
        } else if (degOfA < degOfB) {
            double bi;
            double br;
            int i;
            for (i = 0; i <= degOfA; ++i) {
                double ar = aRe[i];
                double ai = aIm[i];
                br = bRe[i];
                bi = bIm[i];
                cRe[i] = lr * ar - li * ai + mr * br - mi * bi;
                cIm[i] = lr * ai + li * ar + mr * bi + mi * br;
            }
            for (i = degOfA + 1; i <= degOfB; ++i) {
                br = bRe[i];
                bi = bIm[i];
                cRe[i] = mr * br - mi * bi;
                cIm[i] = mr * bi + mi * br;
            }
        } else {
            double ai;
            double ar;
            int i;
            for (i = 0; i <= degOfB; ++i) {
                ar = aRe[i];
                ai = aIm[i];
                double br = bRe[i];
                double bi = bIm[i];
                cRe[i] = lr * ar - li * ai + mr * br - mi * bi;
                cIm[i] = lr * ai + li * ar + mr * bi + mi * br;
            }
            for (i = degOfB + 1; i <= degOfA; ++i) {
                ar = aRe[i];
                ai = aIm[i];
                cRe[i] = lr * ar - li * ai;
                cIm[i] = lr * ai + li * ar;
            }
        }
    }

    public static void derivative(double[] aRe, double[] aIm, int degOfA, int n, double[] bRe, double[] bIm) {
        int i;
        int factor = 1;
        for (i = 2; i <= n; ++i) {
            factor *= i;
        }
        i = 0;
        for (int j = n; j <= degOfA; ++j) {
            bRe[i] = aRe[j] * (double)factor;
            bIm[i] = aIm[j] * (double)factor;
            factor *= j + 1;
            factor /= i + 1;
            ++i;
        }
    }

    public static void times(double[] aRe, double[] aIm, int degOfA, double[] bRe, double[] bIm, int degOfB, double[] cRe, double[] cIm) {
        ComplexPolynomial.times(aRe, aIm, degOfA, bRe, bIm, degOfB, cRe, cIm, degOfA + degOfB);
    }

    public static void times(double[] aRe, double[] aIm, int degOfA, double[] bRe, double[] bIm, int degOfB, double[] cRe, double[] cIm, int degOfC) {
        int k;
        for (k = degOfC; k > degOfA + degOfB; --k) {
            cRe[k] = 0.0;
            cIm[k] = 0.0;
        }
        while (k >= 0) {
            double cr = 0.0;
            double ci = 0.0;
            int maxI = Math.min(k, degOfA);
            for (int i = Math.max(0, k - degOfB); i <= maxI; ++i) {
                cr = cr + aRe[i] * bRe[k - i] - aIm[i] * bIm[k - i];
                ci = ci + aIm[i] * bRe[k - i] + aRe[i] * bIm[k - i];
            }
            cRe[k] = cr;
            cIm[k] = ci;
            --k;
        }
    }

    public static void divide(double[] aRe, double[] aIm, int degOfA, double[] bRe, double[] bIm, int degOfB, double[] cRe, double[] cIm, double[] dRe, double[] dIm) {
        System.arraycopy(aRe, 0, dRe, 0, degOfA + 1);
        System.arraycopy(aIm, 0, dIm, 0, degOfA + 1);
        if (degOfA >= degOfB) {
            double br = bRe[degOfB];
            double bi = bIm[degOfB];
            double b1r = br / (br * br + bi * bi);
            double b1i = -bi / (br * br + bi * bi);
            for (int k = degOfA - degOfB; k >= 0; --k) {
                double b2r = b1r * dRe[k + degOfB] - b1i * dIm[k + degOfB];
                double b2i = b1i * dRe[k + degOfB] + b1r * dIm[k + degOfB];
                cRe[k] = b2r;
                cIm[k] = b2i;
                for (int i = degOfB; i >= 0; --i) {
                    int n = k + i;
                    dRe[n] = dRe[n] - (b2r * bRe[i] - b2i * bIm[i]);
                    int n2 = k + i;
                    dIm[n2] = dIm[n2] - (b2i * bRe[i] + b2r * bIm[i]);
                }
            }
        } else {
            cRe[0] = 0.0;
            cIm[0] = 0.0;
        }
    }

    public static void laguerOneRoot(double[] Ar, double[] Ai, int degOfA, double calcError, double[] root) {
        int MR = 8;
        int MT = 1000;
        int MAXIT = 8000;
        double[] frac = new double[]{0.0, 0.5, 0.25, 0.75, 0.13, 0.38, 0.62, 0.88, 1.0};
        double xr = root[0];
        double xi = root[1];
        for (int iter = 1; iter <= 8000; ++iter) {
            double dxi;
            double dxr;
            double sqi;
            double sqr;
            double bufi;
            double bufr;
            double br = Ar[degOfA];
            double bi = Ai[degOfA];
            double err = Math.sqrt(br * br + bi * bi);
            double dr = 0.0;
            double di = 0.0;
            double fr = 0.0;
            double fi = 0.0;
            double abx = Math.sqrt(xr * xr + xi * xi);
            for (int j = degOfA - 1; j >= 0; --j) {
                bufr = fr;
                bufi = fi;
                fr = xr * bufr - xi * bufi + dr;
                fi = xr * bufi + xi * bufr + di;
                bufr = dr;
                bufi = di;
                dr = xr * bufr - xi * bufi + br;
                di = xr * bufi + xi * bufr + bi;
                bufr = br;
                bufi = bi;
                br = xr * bufr - xi * bufi + Ar[j];
                bi = xr * bufi + xi * bufr + Ai[j];
                err = Math.sqrt(br * br + bi * bi) + abx * err;
            }
            double bs = br * br + bi * bi;
            if (bs <= (err *= calcError) * err) {
                root[0] = xr;
                root[1] = xi;
                return;
            }
            double gr = (dr * br + di * bi) / bs;
            double gi = (di * br - dr * bi) / bs;
            double g2r = gr * gr - gi * gi;
            double g2i = 2.0 * gi * gr;
            bufr = (fr * br + fi * bi) / bs;
            bufi = (fi * br - fr * bi) / bs;
            double hr = g2r - 2.0 * bufr;
            double hi = g2i - 2.0 * bufi;
            bufr = ((double)degOfA - 1.0) * ((double)degOfA * hr - g2r);
            bufi = ((double)degOfA - 1.0) * ((double)degOfA * hi - g2i);
            if (bufr == 0.0 && bufi == 0.0) {
                sqr = 0.0;
                sqi = 0.0;
            } else if (bufr >= 0.0) {
                sqr = Math.sqrt((Math.sqrt(bufr * bufr + bufi * bufi) + bufr) / 2.0);
                sqi = bufi / (2.0 * sqr);
            } else {
                sqi = Math.sqrt((Math.sqrt(bufr * bufr + bufi * bufi) - bufr) / 2.0);
                sqr = bufi / (2.0 * sqi);
            }
            double gpr = gr + sqr;
            double gpi = gi + sqi;
            double gmr = gr - sqr;
            double gmi = gi - sqi;
            double abp = gpr * gpr + gpi * gpi;
            double abm = gmr * gmr + gmi * gmi;
            if (abp < abm) {
                gpr = gmr;
                gpi = gmi;
                abp = abm;
            }
            if (abp > 0.0) {
                dxr = gpr * (double)degOfA / abp;
                dxi = -gpi * (double)degOfA / abp;
            } else {
                dxr = (1.0 + abx) * Math.cos(iter);
                dxi = (1.0 + abx) * Math.sin(iter);
            }
            double x1r = xr - dxr;
            double x1i = xi - dxi;
            if (x1r == xr && x1i == xi) {
                root[0] = xr;
                root[1] = xi;
                return;
            }
            if (iter % 1000 != 0) {
                xr = x1r;
                xi = x1i;
                continue;
            }
            xr -= dxr * frac[iter / 1000];
            xi -= dxi * frac[iter / 1000];
        }
        throw new IllegalArgumentException(" The root was not found -- too many iterations ");
    }

    public static void laguerAllRoots(double[] Ar, double[] Ai, int degOfA, double calcError, double[] rootsRe, double[] rootsIm) {
        double[] root = new double[2];
        double[] adr = new double[degOfA + 1];
        double[] adi = new double[degOfA + 1];
        System.arraycopy(Ar, 0, adr, 0, degOfA + 1);
        System.arraycopy(Ai, 0, adi, 0, degOfA + 1);
        for (int j = degOfA; j >= 1; --j) {
            root[1] = 0.0;
            root[0] = 0.0;
            ComplexPolynomial.laguerOneRoot(adr, adi, j, calcError, root);
            double d = root[0];
            rootsRe[j - 1] = d;
            double xr = d;
            double d2 = root[1];
            rootsIm[j - 1] = d2;
            double xi = d2;
            double br = adr[j];
            double bi = adi[j];
            for (int jj = j - 1; jj >= 0; --jj) {
                double cr = adr[jj];
                double ci = adi[jj];
                adr[jj] = br;
                adi[jj] = bi;
                double bufr = cr + xr * br - xi * bi;
                double bufi = ci + xi * br + xr * bi;
                br = bufr;
                bi = bufi;
            }
        }
    }

    public static void setZero(int deg, double[] a) {
        for (int i = 0; i <= deg; ++i) {
            a[i] = 0.0;
        }
    }

    public static String toString(double[] re, double[] im, int degree) {
        return ComplexPolynomial.toString(re, im, 0, degree, 1.0E-14);
    }

    public static String toString(double[] re, double[] im, int degree, double eps) {
        return ComplexPolynomial.toString(re, im, 0, degree, eps);
    }

    public static String toString(double[] re, double[] im, int lowerDegree, int degree, double eps) {
        StringBuffer sb = new StringBuffer(300);
        boolean first = true;
        for (int i = lowerDegree; i <= degree; ++i) {
            double x = re[i - lowerDegree];
            double y = im[i - lowerDegree];
            if (!(x * x + y * y > 1.0E-28)) continue;
            if (!first) {
                sb.append(" + ");
            } else {
                first = false;
            }
            sb.append("( ");
            sb.append(x);
            if (y < 0.0) {
                sb.append(" - i");
                sb.append(-y);
            } else {
                sb.append(" + i");
                sb.append(y);
            }
            sb.append(" ) z^");
            sb.append(i);
        }
        if (first) {
            sb.append("0");
        }
        return sb.toString();
    }
}

