/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpace;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Monomial;

public class LinearFunctionSpaceFactory {
    LinearFunctionSpaceFactory() {
    }

    public static LinearFunctionSpace createSum(LinearFunctionSpace f, LinearFunctionSpace g) {
        int i;
        if (f.n != g.n) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        if (f.m != g.m) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        int m = f.m;
        BasisFunction[][] basis = new BasisFunction[f.dim + g.dim][m];
        for (i = 0; i < f.dim; ++i) {
            System.arraycopy(f.f[i], 0, basis[i], 0, m);
        }
        i = 0;
        int k = f.dim;
        while (i < g.dim) {
            System.arraycopy(g.f[i], 0, basis[k], 0, m);
            ++i;
            ++k;
        }
        return new LinearFunctionSpace(basis);
    }

    public static LinearFunctionSpace createPower(LinearFunctionSpace f, int power) {
        int m = f.m;
        BasisFunction[][] basis = new BasisFunction[f.dim][power * m];
        for (int i = 0; i < f.dim; ++i) {
            int j = 0;
            int k = 0;
            while (j < power) {
                System.arraycopy(f.f[i], 0, basis[i], k, m);
                ++j;
                k += m;
            }
        }
        return new LinearFunctionSpace(basis);
    }

    public static LinearFunctionSpace createProduct(LinearFunctionSpace f, LinearFunctionSpace g) {
        if (f.n != g.n) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        if (f.dim != g.dim) {
            throw new IllegalArgumentException("function space do not match for this operation");
        }
        int n = f.n;
        int p = f.dim;
        BasisFunction[][] basis = new BasisFunction[f.dim][f.m + g.m];
        for (int i = 0; i < f.dim; ++i) {
            System.arraycopy(f.f[i], 0, basis[i], 0, f.m);
            System.arraycopy(f.f[i], 0, basis[i], f.m, g.m);
        }
        return new LinearFunctionSpace(basis);
    }

    public static LinearFunctionSpace createPartialDerivative(LinearFunctionSpace f, int k) {
        if (k >= f.n) {
            throw new IllegalArgumentException("wrong dimension");
        }
        BasisFunction[][] dBasis = new BasisFunction[f.dim][f.m];
        for (int i = 0; i < f.f.length; ++i) {
            for (int j = 0; j < f.f[i].length; ++j) {
                dBasis[i][j] = f.f[i][j].getPartialDerivative(k);
            }
        }
        return new LinearFunctionSpace(dBasis);
    }

    public static LinearFunctionSpace createConstant(int n, int m) {
        BasisFunction[][] basis = new Monomial[1][1];
        basis[0][0] = new Monomial.Constant(n);
        return LinearFunctionSpaceFactory.createPower(new LinearFunctionSpace(basis), m);
    }

    public static LinearFunctionSpace createLinear(int n, int m) {
        BasisFunction[][] basis = new Monomial[n][1];
        for (int i = 0; i < n; ++i) {
            basis[i][0] = new Monomial.Linear(i, n);
        }
        return LinearFunctionSpaceFactory.createPower(new LinearFunctionSpace(basis), m);
    }

    public static LinearFunctionSpace createAffine(int n, int m) {
        return LinearFunctionSpaceFactory.createPower(LinearFunctionSpaceFactory.createSum(LinearFunctionSpaceFactory.createConstant(n, 1), LinearFunctionSpaceFactory.createLinear(n, 1)), m);
    }

    public static LinearFunctionSpace createExactOrder2(int n) {
        BasisFunction[][] basis = new Monomial[n * (n + 1) / 2][1];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            int j = 0;
            while (j <= i) {
                basis[k][0] = new Monomial.Quadratic(j, i, n);
                ++j;
                ++k;
            }
        }
        return new LinearFunctionSpace(basis);
    }

    public static LinearFunctionSpace createQuadratic(int n, int m) {
        return LinearFunctionSpaceFactory.createPower(LinearFunctionSpaceFactory.createSum(LinearFunctionSpaceFactory.createAffine(n, 1), LinearFunctionSpaceFactory.createExactOrder2(n)), m);
    }

    public static LinearFunctionSpace createExactOrder3(int n) {
        BasisFunction[][] basis = new Monomial[n * (n + 1) * (2 * n + 4) / 12][1];
        int l = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                int k = 0;
                while (k <= j) {
                    basis[l][0] = new Monomial.Cubic(j, i, k, n);
                    ++k;
                    ++l;
                }
            }
        }
        return new LinearFunctionSpace(basis);
    }

    public static LinearFunctionSpace createCubic(int n, int m) {
        return LinearFunctionSpaceFactory.createPower(LinearFunctionSpaceFactory.createSum(LinearFunctionSpaceFactory.createQuadratic(n, 1), LinearFunctionSpaceFactory.createExactOrder3(n)), m);
    }
}

