/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import java.util.List;

public class Sample
implements Cloneable {
    final double[] x;
    final double[] y;
    final double weight;

    public Sample(double[] x, double[] y, double weight) {
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.weight = weight;
    }

    public Sample(double[] x, double[] y) {
        this(x, y, 1.0);
    }

    public boolean sameDimensions(Sample other) {
        return other.x.length == this.x.length && other.y.length == this.y.length;
    }

    public static Sample[] toArray(List sampleList) {
        int n = sampleList.size();
        Sample[] array = new Sample[n];
        for (int i = 0; i < n; ++i) {
            array[i] = (Sample)sampleList.get(i);
        }
        return array;
    }

    public static Sample[] toArray(double[][] x, double[][] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("list length do not match");
        }
        int n = x.length;
        Sample[] array = new Sample[n];
        for (int i = 0; i < n; ++i) {
            array[i] = new Sample(x[i], y[i]);
        }
        return array;
    }
}

