/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.OdeSolverBasedIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.BulirschStoer;

public final class BulirschStoerIntegrator
extends OdeSolverBasedIntegrator {
    private static final long serialVersionUID = 1L;
    double initialStepSize = 0.1;
    double eps = 1.0E-7;

    public BulirschStoerIntegrator() {
        super(new BulirschStoer());
    }

    public BulirschStoerIntegrator(RealFunctionOfOneVariable f) {
        super(new BulirschStoer(1));
        this.setFunction(f);
    }

    public BulirschStoerIntegrator(RealVectorValuedFunctionOfOneVariable f) {
        super(new BulirschStoer(f.getDimensionOfTargetSpace()));
        this.setFunction(f);
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(double initialStepSize) {
        if (this.initialStepSize == initialStepSize) {
            return;
        }
        this.initialStepSize = initialStepSize;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        ((BulirschStoer)this.odeSolver).setEps(eps);
        if (this.eps == eps) {
            return;
        }
        this.eps = eps;
    }

    public static double integrate(RealFunctionOfOneVariable f, double a, double b) {
        return BulirschStoerIntegrator.integrate(f, a, b, 1.0E-12);
    }

    public static double integrate(RealFunctionOfOneVariable f, double a, double b, double acc) {
        BulirschStoerIntegrator integrator = new BulirschStoerIntegrator(f);
        integrator.setEps(acc);
        return integrator.integrate(a, b);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable f, double[] values, double a, double b) {
        BulirschStoerIntegrator.integrate(f, a, b, values, 1.0E-12);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable f, double a, double b, double[] values, double acc) {
        BulirschStoerIntegrator integrator = new BulirschStoerIntegrator(f);
        integrator.setEps(acc);
        integrator.integrate(a, b, values);
    }
}

