/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.BulirschStoerIntegrator;
import de.jtem.numericalMethods.calculus.integration.ExtrapIntegrator;
import de.jtem.numericalMethods.calculus.integration.RungeKuttaFehlbergIntegrator;

public class ExampleIntegration {
    public static void main(String[] arg) {
        RealFunctionOfOneVariable f = new RealFunctionOfOneVariable(){

            @Override
            public double eval(double t) {
                return Math.sin(t);
            }
        };
        System.out.println("integrating f(t) = sin(t) on interval [0,PI]; result is 2");
        for (int i = 3; i < 15; ++i) {
            double acc = Math.pow(10.0, -i);
            System.out.println("setting accuracy to " + acc);
            double resultOfExtrap = ExtrapIntegrator.integrate(f, 0.0, Math.PI, acc);
            double resultOfBulrischStoer = BulirschStoerIntegrator.integrate(f, 0.0, Math.PI, acc);
            double resultOfRungeKuttaFehlberg = RungeKuttaFehlbergIntegrator.integrate(f, 0.0, Math.PI, acc);
            System.out.println("result of Extrap:             " + resultOfExtrap);
            System.out.println("result of BulirschStoer:      " + resultOfBulrischStoer);
            System.out.println("result of RungeKuttaFehlberg: " + resultOfRungeKuttaFehlberg);
            System.out.println("___");
        }
        RealVectorValuedFunctionOfOneVariable g = new RealVectorValuedFunctionOfOneVariable(){

            @Override
            public int getDimensionOfTargetSpace() {
                return 2;
            }

            @Override
            public void eval(double t, double[] values) {
                values[0] = Math.sin(t);
                values[1] = Math.cos(t);
            }
        };
        System.out.println("integrating g(t) = (sin(t),cos(t) on interval [0,PI]; result is (2,0)");
        double[][] result = new double[3][2];
        for (int i = 3; i < 15; ++i) {
            double acc = Math.pow(10.0, -i);
            System.out.println("setting accuracy to " + acc);
            ExtrapIntegrator.integrate(result[0], g, 0.0, Math.PI, acc);
            BulirschStoerIntegrator.integrate(g, 0.0, Math.PI, result[1], acc);
            RungeKuttaFehlbergIntegrator.integrate(g, 0.0, Math.PI, result[2], acc);
            System.out.println("result of Extrap:             ( " + result[0][0] + " , " + result[0][1] + " ) ");
            System.out.println("result of BulirschStoer:      ( " + result[1][0] + " , " + result[1][1] + " ) ");
            System.out.println("result of RungeKuttaFehlberg: ( " + result[2][0] + " , " + result[2][1] + " ) ");
            System.out.println("___");
        }
    }
}

