/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.integration;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.integration.OdeSolverBasedIntegrator;
import de.jtem.numericalMethods.calculus.odeSolving.Extrap;

public final class ExtrapIntegrator
extends OdeSolverBasedIntegrator {
    private static final long serialVersionUID = 1L;
    double initialStepSize = 0.1;
    double absTol = 1.0E-7;
    double relTol = 1.0E-7;
    private boolean justStarted = false;

    public ExtrapIntegrator() {
        super(new Extrap());
    }

    public ExtrapIntegrator(RealFunctionOfOneVariable f) {
        super(new Extrap(1));
        this.setFunction(f);
    }

    public ExtrapIntegrator(RealVectorValuedFunctionOfOneVariable f) {
        super(new Extrap(f.getDimensionOfTargetSpace()));
        this.setFunction(f);
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public void setInitialStepSize(double initialStepSize) {
        if (this.initialStepSize == initialStepSize) {
            return;
        }
        this.initialStepSize = initialStepSize;
    }

    public void setEps(double tol) {
        ((Extrap)this.odeSolver).setAbsTol(tol);
        ((Extrap)this.odeSolver).setRelTol(tol);
        this.absTol = tol;
        this.relTol = tol;
    }

    public double getAbsTol() {
        return this.absTol;
    }

    public void setAbsTol(double absTol) {
        ((Extrap)this.odeSolver).setAbsTol(absTol);
        if (this.absTol == absTol) {
            return;
        }
        this.absTol = absTol;
    }

    public double getRelTol() {
        return this.relTol;
    }

    public void setRelTol(double relTol) {
        ((Extrap)this.odeSolver).setRelTol(relTol);
        if (this.relTol == relTol) {
            return;
        }
        this.relTol = relTol;
    }

    @Override
    public void startAt(double a) {
        super.startAt(a);
        this.justStarted = true;
    }

    @Override
    public void integrateTo(double b) {
        if (this.justStarted) {
            ((Extrap)this.odeSolver).setCurrentStepSize(this.initialStepSize);
        }
        super.integrateTo(b);
        this.justStarted = false;
    }

    public static double integrate(RealFunctionOfOneVariable f, double a, double b) {
        return ExtrapIntegrator.integrate(f, a, b, 1.0E-14);
    }

    public static double integrate(RealFunctionOfOneVariable f, double a, double b, double acc) {
        ExtrapIntegrator integrator = new ExtrapIntegrator(f);
        integrator.setAbsTol(acc);
        integrator.setRelTol(acc);
        return integrator.integrate(a, b);
    }

    public static void integrate(RealVectorValuedFunctionOfOneVariable f, double[] values, double a, double b) {
        ExtrapIntegrator.integrate(values, f, a, b, 1.0E-14);
    }

    public static void integrate(double[] values, RealVectorValuedFunctionOfOneVariable f, double a, double b, double acc) {
        ExtrapIntegrator integrator = new ExtrapIntegrator(f);
        integrator.setAbsTol(acc);
        integrator.setRelTol(acc);
        integrator.integrate(a, b, values);
    }
}

