/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import java.io.Serializable;

public final class DBrent
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double CGOLD = 0.381966;
    static final double ZEPS = 1.0E-17;
    static int ITMAX = 100;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    private static final double sign(double a, double b) {
        return b > 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static final void search(double[] abc, double[] X, RealFunctionOfOneVariable f, RealFunctionOfOneVariable df, double tol) {
        DBrent.search(abc[0], abc[1], abc[2], X, f, df, tol, null);
    }

    public static final void search(double ax, double bx, double cx, double[] X, RealFunctionOfOneVariable f, RealFunctionOfOneVariable df, double tol) {
        DBrent.search(ax, bx, cx, X, f, df, tol, null);
    }

    public static final void search(double ax, double bx, double cx, double[] X, RealFunctionOfOneVariable f, RealFunctionOfOneVariable df, double tol, Info info) {
        double dx;
        double fx;
        double v;
        double d = 0.0;
        double e = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double w = v = bx;
        double x = v;
        double fv = fx = f.eval(x);
        double fw = fx;
        double dv = dx = df.eval(x);
        double dw = dx;
        if (info != null) {
            info.setMaxIter(ITMAX);
        }
        for (int iter = 1; iter <= ITMAX; ++iter) {
            double fu;
            double u;
            double xm = 0.5 * (a + b);
            double tol1 = tol * Math.abs(x) + 1.0E-17;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                X[0] = x;
                X[1] = fx;
                if (info != null) {
                    info.setCurrentIter(iter);
                }
                return;
            }
            if (Math.abs(e) > tol1) {
                double d1;
                double d2 = d1 = 2.0 * (b - a);
                if (dw != dx) {
                    d1 = (w - x) * dx / (dx - dw);
                }
                if (dv != dx) {
                    d2 = (v - x) * dx / (dx - dv);
                }
                double u1 = x + d1;
                double u2 = x + d2;
                boolean ok1 = (a - u1) * (u1 - b) > 0.0 && dx * d1 <= 0.0;
                boolean ok2 = (a - u2) * (u2 - b) > 0.0 && dx * d2 <= 0.0;
                double olde = e;
                e = d;
                if (ok1 || ok2) {
                    d = ok1 && ok2 ? (Math.abs(d1) < Math.abs(d2) ? d1 : d2) : (ok1 ? d1 : d2);
                    if (Math.abs(d) <= Math.abs(0.5 * olde)) {
                        u = x + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = DBrent.sign(tol1, xm - x);
                        }
                    } else {
                        e = dx >= 0.0 ? a - x : b - x;
                        d = 0.5 * e;
                    }
                } else {
                    e = dx >= 0.0 ? a - x : b - x;
                    d = 0.5 * e;
                }
            } else {
                e = dx >= 0.0 ? a - x : b - x;
                d = 0.5 * e;
            }
            if (Math.abs(d) >= tol1) {
                u = x + d;
                fu = f.eval(u);
            } else {
                u = x + DBrent.sign(tol1, d);
                fu = f.eval(u);
                if (fu > fx) {
                    X[0] = x;
                    X[1] = fx;
                    if (info != null) {
                        info.setCurrentIter(iter);
                    }
                    return;
                }
            }
            double du = df.eval(u);
            if (fu <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                dv = dw;
                w = x;
                fw = fx;
                dw = dx;
                x = u;
                fx = fu;
                dx = du;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || w == x) {
                v = w;
                fv = fw;
                dv = dw;
                w = u;
                fw = fu;
                dw = du;
                continue;
            }
            if (!(fu < fv) && v != x && v != w) continue;
            v = u;
            fv = fu;
            dv = du;
        }
        if (info != null) {
            info.setCurrentIter(ITMAX);
            info.setMessage(info.getMessage() + "\n" + "Too many iterations in routine DBRENT\n");
            info.printDebug();
        }
        X[0] = x;
        X[1] = fx;
    }
}

