/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariablesWithJacobien;

public class Newton {
    static final double DEFAULT_MAX_STEPSIZE = 1.0;
    static final double ALF = 1.0E-4;

    Newton() {
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien func, double[] x) {
        Newton.search(func, x, 200, 1.0E-8, 1.0E-10, 1.0E-15, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien func, double[] x, int maxNumberOfIterations, double acc, double precision) {
        Newton.search(func, x, maxNumberOfIterations, acc, acc / 100.0, precision, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien func, double[] x, int maxNumberOfIterations, double acc, double accOfMIn, double precision, double maxStepSize) {
        int n = func.getDimensionOfTargetSpace();
        double[][] fjac = new double[n][n];
        double[][] q = new double[n][n];
        double[] g = new double[n];
        double[] p = new double[n];
        double[] xold = new double[n];
        double[] fvec = new double[n];
        double[] tmp1 = new double[n];
        double[] tmp2 = new double[n];
        boolean[] check = new boolean[1];
        RealFunctionOfSeveralVariables fmin = Newton.normSqr(func, fvec);
        double f = fmin.eval(x);
        double test = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(fvec[i]) > test)) continue;
            test = Math.abs(fvec[i]);
        }
        if (test < 0.01 * acc) {
            return;
        }
        double stpmax = maxStepSize * Math.max(Math.sqrt(VectorOperations.normSqr(x)), (double)n);
        for (int its = 1; its <= maxNumberOfIterations; ++its) {
            int i;
            func.eval(x, fvec, 0, fjac);
            MatrixOperations.times(fvec, fjac, g);
            VectorOperations.assign(x, xold);
            double det = Householder.decompose(fjac, q, tmp1, tmp2);
            if (det == 0.0) {
                new RuntimeException("singular Jacobian");
            }
            MatrixOperations.times(fvec, q, p);
            VectorOperations.neg(p, p);
            RXB.solve(fjac, p);
            f = Newton.lnsrch(xold, f, g, p, x, precision, stpmax, check, fmin);
            test = 0.0;
            for (i = 0; i < n; ++i) {
                if (!(Math.abs(fvec[i]) > test)) continue;
                test = Math.abs(fvec[i]);
            }
            if (test < acc) {
                return;
            }
            if (check[0]) {
                test = 0.0;
                double den = Math.max(f, 0.5 * (double)n);
                for (int i2 = 0; i2 < n; ++i2) {
                    double temp = Math.abs(g[i2]) * Math.max(Math.abs(x[i2]), 1.0) / den;
                    if (!(temp > test)) continue;
                    test = temp;
                }
                if (test < accOfMIn) {
                    throw new HitLocalMinimumException();
                }
                return;
            }
            test = 0.0;
            for (i = 0; i < n; ++i) {
                double temp = Math.abs(x[i] - xold[i]) / Math.max(Math.abs(x[i]), 1.0);
                if (!(temp > test)) continue;
                test = temp;
            }
            if (!(test < precision)) continue;
            return;
        }
        throw new RuntimeException("exeed maximal number of iterations");
    }

    static RealFunctionOfSeveralVariables normSqr(final RealVectorValuedFunctionOfSeveralVariables F, final double[] v) {
        return new RealFunctionOfSeveralVariables(){
            final double[] values;
            {
                this.values = v;
            }

            @Override
            public double eval(double[] x) {
                F.eval(x, this.values, 0);
                return VectorOperations.normSqr(this.values) / 2.0;
            }

            @Override
            public int getNumberOfVariables() {
                return F.getNumberOfVariables();
            }
        };
    }

    public static double lnsrch(double[] xold, double fold, double[] g, double[] p, double[] x, double precision, double stpmax, boolean[] check, RealFunctionOfSeveralVariables func) {
        int i;
        int n = func.getNumberOfVariables();
        check[0] = false;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += p[i] * p[i];
        }
        if ((sum = Math.sqrt(sum)) > stpmax) {
            i = 0;
            while (i < n) {
                int n2 = i++;
                p[n2] = p[n2] * (stpmax / sum);
            }
        }
        double slope = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            slope += g[i2] * p[i2];
        }
        double test = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            double temp = Math.abs(p[i3]) / Math.max(Math.abs(xold[i3]), 1.0);
            if (!(temp > test)) continue;
            test = temp;
        }
        double alamin = precision / test;
        double alam = 1.0;
        double alam2 = 0.0;
        double f2 = 0.0;
        double fold2 = 0.0;
        int iter = 0;
        while (true) {
            double tmplam;
            for (int i4 = 0; i4 < n; ++i4) {
                x[i4] = xold[i4] + alam * p[i4];
            }
            double f = func.eval(x);
            if (alam < alamin) {
                for (int i5 = 0; i5 < n; ++i5) {
                    x[i5] = xold[i5];
                }
                check[0] = true;
                return f;
            }
            if (f <= fold + 1.0E-4 * alam * slope) {
                return f;
            }
            if (alam == 1.0) {
                tmplam = -slope / (2.0 * (f - fold - slope));
            } else {
                double rhs1 = f - fold - alam * slope;
                double rhs2 = f2 - fold2 - alam2 * slope;
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                if (a == 0.0) {
                    tmplam = -slope / (2.0 * b);
                } else {
                    double disc = b * b - 3.0 * a * slope;
                    if (disc < 0.0) {
                        throw new RuntimeException("Roundoff problem in lnsrch.");
                    }
                    tmplam = (-b + Math.sqrt(disc)) / (3.0 * a);
                }
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            fold2 = fold;
            alam = Math.max(tmplam, 0.1 * alam);
            ++iter;
        }
    }

    public static class HitLocalMinimumException
    extends RuntimeException {
        public HitLocalMinimumException() {
        }

        public HitLocalMinimumException(String msg) {
        }
    }
}

