/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.specialFunctions;

public class Gamma {
    private static final double a = Math.sqrt(Math.PI * 2) * 1.000000000190015;
    private static final double b = Math.sqrt(Math.PI * 2) * 76.18009172947146;
    private static final double c = Math.sqrt(Math.PI * 2) * -86.50532032941678;
    private static final double d = Math.sqrt(Math.PI * 2) * 24.01409824083091;
    private static final double e = Math.sqrt(Math.PI * 2) * -1.231739572450155;
    private static final double f = Math.sqrt(Math.PI * 2) * 0.001208650973866179;
    private static final double g = Math.sqrt(Math.PI * 2) * -5.395239384953E-6;
    static int MAX_NUMBER_OF_ITERATIONS = 200;
    static double EPS = 1.0E-16;
    static double MIN_DP = 1.0E-30;

    private Gamma() {
    }

    static double gamma_(double z) {
        if (z <= 0.0) {
            throw new IllegalArgumentException("argument must be positive");
        }
        double s = Math.exp(Math.log(z + 5.5) * (z + 0.5) - (z + 5.5));
        return s * (a + b / (z + 1.0) + c / (z + 2.0) + d / (z + 3.0) + e / (z + 4.0) + f / (z + 5.0) + g / (z + 6.0)) / z;
    }

    public static double gamma(double x) {
        return x <= 0.5 ? Math.PI / Gamma.gamma_(1.0 - x) / Math.sin(Math.PI * x) : Gamma.gamma_(x);
    }

    static double logOfGamma_(double z) {
        if (z <= 0.0) {
            throw new IllegalArgumentException("argument must be positive");
        }
        double s = Math.log(z + 5.5) * (z + 0.5) - (z + 5.5);
        return s + Math.log((a + b / (z + 1.0) + c / (z + 2.0) + d / (z + 3.0) + e / (z + 4.0) + f / (z + 5.0) + g / (z + 6.0)) / z);
    }

    public static double logOfGamma(double x) {
        return x <= 0.5 ? Math.log(Math.PI / Math.sin(Math.PI * x)) - Gamma.logOfGamma_(1.0 - x) : Gamma.logOfGamma_(x);
    }

    private static double gamma(double a, double x, double gammaOfA, boolean computeGammaOfA) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("a is not positive");
        }
        if (x < 0.0) {
            throw new IllegalArgumentException("x is negative");
        }
        if (x < a + 1.0) {
            if (computeGammaOfA) {
                gammaOfA = Gamma.gamma(a);
            }
            return Gamma.computeViaSeries(a, x, gammaOfA);
        }
        return Gamma.computeViaContinuedFraction(a, x);
    }

    public static double gamma(double a, double x, double gammaOfA) {
        return Gamma.gamma(a, x, gammaOfA, false);
    }

    public static double gamma(double a, double x) {
        return Gamma.gamma(a, x, 123.0, true);
    }

    static double computeViaSeries(double a, double x, double gammaOfA) {
        double delta;
        double factor = a;
        double sum = delta = 1.0 / a;
        int counter = 0;
        while (Math.abs(delta) > Math.abs(sum) * EPS) {
            sum += (delta *= x / (factor += 1.0));
            if (counter <= MAX_NUMBER_OF_ITERATIONS) continue;
            throw new RuntimeException("exeeded max number of iterations=" + MAX_NUMBER_OF_ITERATIONS);
        }
        return gammaOfA - sum * Math.exp(a * Math.log(x) - x);
    }

    static double computeViaContinuedFraction(double a, double x) {
        double d;
        double b = x + 1.0 - a;
        double c = 1.0 / MIN_DP;
        double h = d = 1.0 / b;
        for (int i = 1; i < MAX_NUMBER_OF_ITERATIONS; ++i) {
            double an = (double)(-i) * ((double)i - a);
            d = an * d + (b += 2.0);
            if (Math.abs(c = an / c + b) < MIN_DP) {
                c = MIN_DP;
            }
            if (Math.abs(d) < MIN_DP) {
                d = MIN_DP;
            }
            d = 1.0 / d;
            double delta = c * d;
            h *= delta;
            if (!(Math.abs(delta - 1.0) < EPS)) continue;
            return h * Math.exp(a * Math.log(x) - x);
        }
        throw new RuntimeException("exeeded max number of iterations=" + MAX_NUMBER_OF_ITERATIONS);
    }
}

