/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

import de.jtem.numericalMethods.geometry.geodesic.DoubleTriple;
import de.jtem.numericalMethods.geometry.geodesic.IntTriple;

public class BaryCoords3d {
    static double eps = 1.0E-6;
    static int FALSE = 0;
    static int TRUE = 0;

    BaryCoords3d() {
    }

    static void correct(double[] bary) {
        double sum = 0.0;
        int i = 0;
        for (i = 0; i < 3; ++i) {
            if (Math.abs(bary[i]) < eps) {
                bary[i] = 0.0;
            }
            sum += bary[i];
        }
        for (i = 0; bary[i] == 0.0 && i < 3; ++i) {
        }
        int j = (i + 1) % 3;
        bary[j] = bary[j] / sum;
        int k = (i + 2) % 3;
        bary[k] = bary[k] / sum;
        bary[i] = 1.0 - bary[j] - bary[k];
    }

    public static double sqr(double a, double b, double c, double[] v) {
        return -(a * a * v[1] * v[2] + b * b * v[0] * v[2] + c * c * v[1] * v[0]);
    }

    public static double abs(double a, double b, double c, double[] v) {
        return Math.sqrt(-(a * a * v[1] * v[2] + b * b * v[0] * v[2] + c * c * v[1] * v[0]));
    }

    public static double dot(double a, double b, double c, double[] bV, double[] bW) {
        return -0.5 * (a * a * (bV[1] * bW[2] + bV[2] * bW[1]) + b * b * (bV[0] * bW[2] + bV[2] * bW[0]) + c * c * (bV[1] * bW[0] + bV[0] * bW[1]));
    }

    public static double dist(double a, double b, double c, double[] A, double[] B) {
        double dist0 = A[0] - B[0];
        double dist1 = A[1] - B[1];
        double dist2 = A[2] - B[2];
        return Math.sqrt(-(a * a * dist1 * dist2 + b * b * dist0 * dist2 + c * c * dist1 * dist0));
    }

    static void norm(double a, double b, double c, double[] baryNorm, double[] bary) {
        BaryCoords3d.vecScl(baryNorm, bary, 1.0 / Math.sqrt(-(a * a * bary[1] * bary[2] + b * b * bary[0] * bary[2] + c * c * bary[1] * bary[0])));
    }

    static void rotate90(double a, double b, double c, double[] normal, double[] bary) {
        double sp = BaryCoords3d.sqr(a, b, c, bary);
        normal[0] = bary[2];
        normal[1] = bary[0];
        normal[2] = bary[1];
        BaryCoords3d.vecLinComb(normal, normal, 1.0, bary, -BaryCoords3d.dot(a, b, c, bary, normal) / sp);
        BaryCoords3d.vecScl(normal, normal, Math.sqrt(sp) / BaryCoords3d.abs(a, b, c, normal));
    }

    static void normal(double a, double b, double c, double[] normal, double[] bary) {
        normal[0] = bary[2];
        normal[1] = bary[0];
        normal[2] = bary[1];
        BaryCoords3d.vecLinComb(normal, normal, 1.0, bary, -BaryCoords3d.dot(a, b, c, bary, normal) / BaryCoords3d.sqr(a, b, c, bary));
        BaryCoords3d.vecScl(normal, normal, 1.0 / BaryCoords3d.abs(a, b, c, normal));
    }

    static void orthonormalize(double a, double b, double c, double[] bary, double[] normal) {
        BaryCoords3d.norm(a, b, c, bary, bary);
        BaryCoords3d.vecLinComb(normal, normal, 1.0, bary, -BaryCoords3d.dot(a, b, c, bary, normal));
        BaryCoords3d.norm(a, b, c, normal, normal);
    }

    public static double angle(double a, double b, double c, double[] bV, double[] bW) {
        double lV = Math.sqrt(-(a * a * bV[1] * bV[2] + b * b * bV[0] * bV[2] + c * c * bV[1] * bV[0]));
        double lW = Math.sqrt(-(a * a * bW[1] * bW[2] + b * b * bW[0] * bW[2] + c * c * bW[1] * bW[0]));
        double sp = BaryCoords3d.dot(a, b, c, bV, bW) / lV / lW;
        sp = Math.min(1.0, Math.max(-1.0, sp));
        return Math.acos(sp);
    }

    public static double orientedAngle(double a, double b, double c, double[] bV, double[] bW) {
        double[] nV = new double[3];
        double lV = Math.sqrt(-(a * a * bV[1] * bV[2] + b * b * bV[0] * bV[2] + c * c * bV[1] * bV[0]));
        double lW = Math.sqrt(-(a * a * bW[1] * bW[2] + b * b * bW[0] * bW[2] + c * c * bW[1] * bW[0]));
        double sp = BaryCoords3d.dot(a, b, c, bV, bW) / lV / lW;
        sp = Math.min(1.0, Math.max(-1.0, sp));
        BaryCoords3d.normal(a, b, c, nV, bV);
        if (BaryCoords3d.dot(a, b, c, nV, bW) < 0.0) {
            return -Math.acos(sp);
        }
        return Math.acos(sp);
    }

    static void rotate(double a, double b, double c, double[] bary, double[] rotated, double alpha) {
        double[] normal = new double[3];
        BaryCoords3d.normal(a, b, c, normal, bary);
        BaryCoords3d.vecScl(normal, normal, BaryCoords3d.abs(a, b, c, bary));
        BaryCoords3d.vecLinComb(rotated, bary, Math.cos(alpha), normal, Math.sin(alpha));
    }

    static void convertToVec3(double[] x, double[] bary, double[] A, double[] B, double[] C) {
        x[0] = bary[0] * A[0] + bary[1] * B[0] + bary[2] * C[0];
        x[1] = bary[0] * A[1] + bary[1] * B[1] + bary[2] * C[1];
        x[2] = bary[0] * A[2] + bary[1] * B[2] + bary[2] * C[2];
    }

    int gmBaryInTriangleConvertFromVec3(double[] bary, double[] x0, double[] x1, double[] x2, double[] x) {
        double det;
        int i0 = 0;
        int i1 = 1;
        int i2 = 2;
        while (!(Math.abs(det = x1[i0] * x2[i1] - x1[i1] * x2[i0] - (x0[i0] * x2[i1] - x0[i1] * x2[i0]) + x0[i0] * x1[i1] - x0[i1] * x1[i0]) > eps)) {
            if (i1 == 1) {
                i1 = 2;
                i2 = 1;
                continue;
            }
            if (i0 == 0) {
                i0 = 1;
                i2 = 0;
                continue;
            }
            System.out.println("mBaryInElementConvertFromVec3: triangle degenerated?");
            return FALSE;
        }
        bary[0] = (x1[i0] * x2[i1] - x1[i1] * x2[i0] - (x[i0] * x2[i1] - x[i1] * x2[i0]) + x[i0] * x1[i1] - x[i1] * x1[i0]) / det;
        bary[1] = (x[i0] * x2[i1] - x[i1] * x2[i0] - (x0[i0] * x2[i1] - x0[i1] * x2[i0]) + x0[i0] * x[i1] - x0[i1] * x[i0]) / det;
        bary[2] = 1.0 - bary[0] - bary[1];
        if (Math.abs(x0[i2] * bary[0] + x1[i2] * bary[1] + x2[i2] * bary[2] - x[i2]) > 0.001) {
            System.out.println("gmBaryInElementConvertFromVec3: test for third row failed.");
            return FALSE;
        }
        BaryCoords3d.correct(bary);
        return TRUE;
    }

    int clip(double[] bary, double[] nbary) {
        double[] v = new double[3];
        int clipped = FALSE;
        double fac_min = 1.0E98;
        for (int i = 0; i < 3; ++i) {
            double fac;
            if (0.0 <= nbary[i] && nbary[i] <= 1.0 || !(nbary[i] < 0.0) || !((fac = bary[i] / (bary[i] - nbary[i])) < fac_min)) continue;
            fac_min = fac;
        }
        if (fac_min != 1.0E98) {
            clipped = TRUE;
            DoubleTriple.sub(v, nbary, bary);
            DoubleTriple.scale(v, v, fac_min);
            DoubleTriple.add(nbary, bary, v);
            BaryCoords3d.correct(nbary);
        }
        return clipped;
    }

    static void interpolate(double[] bary, double[] position, double[][] triple) {
        bary[0] = position[0] * triple[0][0] + position[1] * triple[1][0] + position[2] * triple[2][0];
        bary[1] = position[0] * triple[0][1] + position[1] * triple[1][1] + position[2] * triple[2][1];
        bary[2] = position[0] * triple[0][2] + position[1] * triple[1][2] + position[2] * triple[2][2];
    }

    static void interpolateVec3(double[] out, double[] bary, double[] A, double[] B, double[] C) {
        out[0] = bary[0] * A[0] + bary[1] * B[0] + bary[2] * C[0];
        out[1] = bary[0] * A[1] + bary[1] * B[1] + bary[2] * C[1];
        out[2] = bary[0] * A[2] + bary[1] * B[2] + bary[2] * C[2];
    }

    static void interpolateVec2f(float[] out, double[] bary, float[] A, float[] B, float[] C) {
        throw new RuntimeException("check behavior of this function. ");
    }

    static double add(double[] new_pos, double[] old_pos, double[] dir) {
        int k;
        int j;
        double t;
        int i;
        double[] h = new double[3];
        double abs_sum = 0.0;
        double sum = 0.0;
        for (i = 0; i < 3; ++i) {
            sum += dir[i];
            abs_sum += Math.abs(dir[i]);
        }
        if (Math.abs(sum) > abs_sum * eps) {
            System.out.println("not a barycentric vector");
            return -1.0;
        }
        for (i = 0; i < 3; ++i) {
            if (!(Math.abs(dir[i]) < abs_sum * eps)) continue;
            int n = (i + 1) % 3;
            dir[n] = dir[n] + dir[i] / 2.0;
            dir[(i + 2) % 3] = -dir[(i + 1) % 3];
            dir[i] = 0.0;
        }
        BaryCoords3d.addVec(h, old_pos, dir);
        if (BaryCoords3d.isInsideElement(h)) {
            DoubleTriple.copy(new_pos, h);
            return 1.0;
        }
        for (i = 0; i < 3; ++i) {
            double d;
            double d2;
            double d3;
            if (dir[i] == 0.0) continue;
            t = -old_pos[i] / dir[i];
            if (!(d3 > 0.0)) continue;
            j = (i + 1) % 3;
            h[j] = old_pos[j] + t * dir[j];
            if (!(d2 >= 0.0) || !(h[j] <= 1.0)) continue;
            k = (i + 2) % 3;
            h[k] = old_pos[k] + t * dir[k];
            if (!(d >= 0.0) || !(h[k] <= 1.0)) continue;
            new_pos[i] = 0.0;
            new_pos[j] = h[j];
            new_pos[k] = 1.0 - h[j];
            return t;
        }
        for (i = 0; i < 3; ++i) {
            double d;
            double d4;
            double d5;
            if (dir[i] == 0.0) continue;
            t = -old_pos[i] / dir[i];
            if (!(d5 > eps)) continue;
            j = (i + 1) % 3;
            h[j] = old_pos[j] + t * dir[j];
            if (!(d4 > -eps) || !(h[j] < 1.0 + eps)) continue;
            k = (i + 2) % 3;
            h[k] = old_pos[k] + t * dir[k];
            if (!(d > -eps) || !(h[k] < 1.0 + eps)) continue;
            new_pos[i] = 0.0;
            new_pos[j] = Math.min(Math.max(h[j], 0.0), 1.0);
            new_pos[k] = 1.0 - h[j];
            return t;
        }
        DoubleTriple.copy(new_pos, old_pos);
        return 0.0;
    }

    public static int getVertex(double[] bary) {
        if (bary[0] == 1.0 && bary[1] == 0.0 && bary[2] == 0.0) {
            return 0;
        }
        if (bary[0] == 0.0 && bary[1] == 1.0 && bary[2] == 0.0) {
            return 1;
        }
        if (bary[0] == 0.0 && bary[1] == 0.0 && bary[2] == 1.0) {
            return 2;
        }
        return -1;
    }

    public static int getEdge(double[] bary) {
        if (bary[0] == 0.0 && bary[1] != 0.0 && bary[2] != 0.0) {
            return 0;
        }
        if (bary[0] != 0.0 && bary[1] == 0.0 && bary[2] != 0.0) {
            return 1;
        }
        if (bary[0] != 0.0 && bary[1] != 0.0 && bary[2] == 0.0) {
            return 2;
        }
        return -1;
    }

    public static int onEdgeSwitchElement(double[] bary, int[] anElement, int[][] elementData, int[][] neighbourData) {
        double[] temp = new double[3];
        int edge = BaryCoords3d.getEdge(bary);
        int T = neighbourData[anElement[0]][edge];
        if (T == -1) {
            // empty if block
        }
        temp[IntTriple.getLocInd((int[])elementData[T], (int)elementData[anElement[0]][(edge + 1) % 3])] = bary[(edge + 1) % 3];
        temp[IntTriple.getLocInd((int[])elementData[T], (int)elementData[anElement[0]][(edge + 2) % 3])] = bary[(edge + 2) % 3];
        DoubleTriple.copy(bary, temp);
        anElement[0] = T;
        return 1;
    }

    public static void outsidePointingEdgeNormal(double[] l, int element, int edge, double[] normal) {
        double[] n = normal;
        double[] v = new double[3];
        n[edge] = -1.0;
        n[(edge + 1) % 3] = 0.5;
        n[(edge + 1) % 3] = 0.5;
        v[(edge + 1) % 3] = -1.0 / l[edge];
        v[(edge + 2) % 3] = 1.0 / l[edge];
        BaryCoords3d.vecLinComb(n, n, 1.0, v, -BaryCoords3d.dot(l[0], l[1], l[2], n, v));
        BaryCoords3d.vecScl(n, n, 1.0 / BaryCoords3d.abs(l[0], l[1], l[2], n));
    }

    public static void changeToOtherElementAtEdge(int element1, int element2, int edge1, double[] vec1, double[] vec2, int[][] elementData, double[] l1, double[] l2) {
        double[] n = new double[3];
        double[] v = new double[3];
        int localIndexOfV1InElement1 = (edge1 + 1) % 3;
        int localIndexOfV2InElement1 = (edge1 + 2) % 3;
        int V1 = elementData[element1][localIndexOfV1InElement1];
        int V2 = elementData[element1][localIndexOfV2InElement1];
        v[localIndexOfV1InElement1] = -1.0 / l1[edge1];
        v[localIndexOfV2InElement1] = 1.0 / l1[edge1];
        BaryCoords3d.outsidePointingEdgeNormal(l1, element1, edge1, n);
        double rCosAlpha = BaryCoords3d.dot(l1[0], l1[1], l1[2], n, vec1);
        double rSinAlpha = BaryCoords3d.dot(l1[0], l1[1], l1[2], v, vec1);
        int localIndexOfV1InElement2 = IntTriple.getLocInd(elementData[element2], V1);
        int localIndexOfV2InElement2 = IntTriple.getLocInd(elementData[element2], V2);
        int edge2 = 2 * (localIndexOfV1InElement2 + localIndexOfV2InElement2) % 3;
        v[2] = 0.0;
        v[1] = 0.0;
        v[0] = 0.0;
        v[localIndexOfV1InElement2] = -1.0 / l2[edge2];
        v[localIndexOfV2InElement2] = 1.0 / l2[edge2];
        BaryCoords3d.outsidePointingEdgeNormal(l2, element2, edge2, n);
        BaryCoords3d.vecLinComb(vec2, n, -rCosAlpha, v, rSinAlpha);
    }

    public static int getOtherElementAtEdge(double[] bary, int anElement, int[][] elementData, int[][] neighbourData) {
        int i;
        for (i = 0; i < 3 && bary[i] != 0.0; ++i) {
        }
        if (i == 3) {
            throw new IllegalArgumentException("bary0d is not on an edge.");
        }
        return neighbourData[anElement][i];
    }

    public static int setNewElement(double[] bary, int[] anElement, int[][] elementData, int[][] neighbourData, int newElement) {
        if (anElement[0] == newElement) {
            return 1;
        }
        if (BaryCoords3d.isInnerPoint(bary)) {
            return newElement == anElement[0] ? TRUE : FALSE;
        }
        if (BaryCoords3d.isOnEdge(bary)) {
            if (BaryCoords3d.onEdgeSwitchElement(bary, anElement, elementData, neighbourData) == TRUE) {
                if (anElement[0] == newElement) {
                    return 1;
                }
                BaryCoords3d.onEdgeSwitchElement(bary, anElement, elementData, neighbourData);
                return 0;
            }
            return 0;
        }
        int local = IntTriple.getLocInd(elementData[newElement], elementData[anElement[0]][BaryCoords3d.getVertex(bary)]);
        if (local == -1) {
            return 0;
        }
        anElement[0] = newElement;
        bary[local] = 1.0;
        bary[(local + 2) % 3] = 0.0;
        bary[(local + 1) % 3] = 0.0;
        return 1;
    }

    public static int getVerticesOfEdge(double[] bary, int anElement, int[][] elementData, int[] left, int[] right) {
        int edge = BaryCoords3d.getEdge(bary);
        if (edge == -1) {
            return 0;
        }
        left[0] = elementData[anElement][(edge + 2) % 3];
        right[0] = elementData[anElement][(edge + 1) % 3];
        return 1;
    }

    public static boolean vertexIsOnEdge(double[] bary, int anElement, int[][] elementData, int aVertex) {
        int edge = BaryCoords3d.getVertex(bary);
        if (edge == -1) {
            return false;
        }
        return elementData[anElement][(edge + 2) % 3] == aVertex || elementData[anElement][(edge + 1) % 3] == aVertex;
    }

    public static int leftVertexOfEdge(double[] bary, int anElement, int[][] elementData) {
        int i;
        for (i = 0; i < 3 && bary[i] != 0.0; ++i) {
        }
        if (i == 3) {
            throw new RuntimeException("bary0d is not on an edge");
        }
        return elementData[anElement][(i + 2) % 3];
    }

    public static int rightVertexOfEdge(double[] bary, int anElement, int[][] elementData) {
        int i;
        for (i = 0; i < 3 && bary[i] != 0.0; ++i) {
        }
        if (i == 3) {
            throw new RuntimeException("bary0d is not on an edge.");
        }
        return elementData[anElement][(i + 1) % 3];
    }

    public static int changeBase(double[] bary, int[] oldBase, int[] newBase) {
        double[] tmp = new double[3];
        DoubleTriple.copy(tmp, bary);
        DoubleTriple.zero(bary);
        for (int i = 0; i < 3; ++i) {
            int j;
            if (tmp[i] == 0.0) continue;
            for (j = 0; j < 3; ++j) {
                if (oldBase[i] != newBase[j]) continue;
                bary[j] = tmp[i];
                break;
            }
            if (j != 3) continue;
            DoubleTriple.copy(bary, tmp);
            return 0;
        }
        return 1;
    }

    public static int canChangeBase(double[] bary, int[] oldBase, int[] newBase) {
        for (int i = 0; i < 3; ++i) {
            int j;
            if (bary[i] == 0.0) continue;
            for (j = 0; j < 3 && oldBase[i] != newBase[j]; ++j) {
            }
            if (j != 3) continue;
            return 0;
        }
        return 1;
    }

    public static void vecScl(double[] baryVec1, double[] baryVec2, double f) {
        double factor1 = f;
        baryVec1[0] = baryVec2[0] * factor1;
        baryVec1[1] = baryVec2[1] * factor1;
        baryVec1[2] = -baryVec1[0] - baryVec1[1];
    }

    public static void vecLinComb(double[] baryVec0, double[] baryVec1, double f1, double[] baryVec2, double f2) {
        double factor1 = f1;
        double factor2 = f2;
        baryVec0[0] = baryVec1[0] * factor1 + baryVec2[0] * factor2;
        baryVec0[1] = baryVec1[1] * factor1 + baryVec2[1] * factor2;
        baryVec0[2] = -baryVec0[0] - baryVec0[1];
    }

    public static void linComb(double[] bary0, double[] bary1, double f1, double[] bary2, double f2) {
        double factor1 = f1;
        double factor2 = f2;
        bary0[0] = bary1[0] * factor1 + bary2[0] * factor2;
        bary0[1] = bary1[1] * factor1 + bary2[1] * factor2;
        bary0[2] = 1.0 - bary0[0] - bary0[1];
    }

    public static void addVec(double[] bary1, double[] bary2, double[] baryVec) {
        bary1[0] = bary2[0] + baryVec[0];
        bary1[1] = bary2[1] + baryVec[1];
        bary1[2] = 1.0 - bary1[0] - bary1[1];
    }

    public static void subVec(double[] bary1, double[] bary2, double[] baryVec) {
        bary1[0] = bary2[0] - baryVec[0];
        bary1[1] = bary2[1] - baryVec[1];
        bary1[2] = 1.0 - bary1[0] - bary1[1];
    }

    public static void sub(double[] baryVec, double[] bary1, double[] bary2) {
        baryVec[0] = bary1[0] - bary2[0];
        baryVec[1] = bary1[1] - bary2[1];
        baryVec[2] = -baryVec[0] - baryVec[1];
    }

    public static void vecAdd(double[] baryVec0, double[] baryVec1, double[] baryVec2) {
        baryVec0[0] = baryVec1[0] + baryVec2[0];
        baryVec0[1] = baryVec1[1] + baryVec2[1];
        baryVec0[2] = -baryVec0[0] - baryVec0[1];
    }

    public static void vecSub(double[] baryVec0, double[] baryVec1, double[] baryVec2) {
        baryVec0[0] = baryVec2[0] - baryVec1[0];
        baryVec0[1] = baryVec2[1] - baryVec1[1];
        baryVec0[2] = -baryVec0[0] - baryVec0[1];
    }

    public static boolean isPoint(double[] bary) {
        return BaryCoords3d.isPoint(bary, eps);
    }

    public static boolean isPoint(double[] bary, double eps) {
        return Math.abs(bary[0] + bary[1] + bary[2] - 1.0) < eps;
    }

    public static boolean isVector(double[] bary) {
        return BaryCoords3d.isVector(bary, eps);
    }

    public static boolean isVector(double[] bary, double eps) {
        return Math.abs(bary[0] + bary[1] + bary[2]) < eps;
    }

    public static boolean isInsideElement(double[] bary) {
        return BaryCoords3d.isInsideElement(bary, eps);
    }

    public static boolean isInsideElement(double[] bary, double eps) {
        return bary[0] > -eps && bary[0] < 1.0 + eps && bary[1] > -eps && bary[1] < 1.0 + eps && bary[2] > -eps && bary[2] < 1.0 + eps;
    }

    public static boolean isInnerPoint(double[] bary) {
        return bary[0] > 0.0 && bary[0] < 1.0 && bary[1] > 0.0 && bary[1] < 1.0 && bary[2] > 0.0 && bary[2] < 1.0;
    }

    public static boolean isOnEdge(double[] bary) {
        return bary[0] == 0.0 && bary[1] != 0.0 && bary[2] != 0.0 || bary[0] != 0.0 && bary[1] == 0.0 && bary[2] != 0.0 || bary[0] != 0.0 && bary[1] != 0.0 && bary[2] == 0.0;
    }

    public static boolean isOnVertex(double[] bary) {
        return bary[0] == 1.0 && bary[1] == 0.0 && bary[2] == 0.0 || bary[0] == 0.0 && bary[1] == 1.0 && bary[2] == 0.0 || bary[0] == 0.0 && bary[1] == 0.0 && bary[2] == 1.0;
    }
}

