/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

import de.jtem.numericalMethods.geometry.geodesic.BaryCoords3d;
import de.jtem.numericalMethods.geometry.geodesic.DoubleVectorList;
import de.jtem.numericalMethods.geometry.geodesic.IntList;

public class PolygonOnTriangulation {
    static final double eps = 1.0E-12;
    IntList strip = new IntList();
    DoubleVectorList baryCoords = new DoubleVectorList(3);

    PolygonOnTriangulation() {
    }

    public void removeAll() {
        this.strip.removeAll();
        this.baryCoords.removeAll();
    }

    public void add(int element, double[] bary) {
        this.strip.add(element);
        this.baryCoords.add(bary);
    }

    public void assignGeodesic(int element, double[] bary, double[] direction, int[][] elementData, int[][] neighbourData, double[][] length) {
        double factor = 1.0;
        if (element < 0 || element >= elementData[0].length) {
            throw new IllegalArgumentException("element not in element list of triangulation");
        }
        if (!BaryCoords3d.isPoint(bary, 1.0E-12) || !BaryCoords3d.isInsideElement(bary, 1.0E-12)) {
            throw new IllegalArgumentException("no valid barycentric coords");
        }
        if (!BaryCoords3d.isVector(bary, 1.0E-12)) {
            throw new IllegalArgumentException("no valid barycentric vector");
        }
        this.removeAll();
        double[] newDirection = (double[])direction.clone();
        direction = (double[])direction.clone();
        this.add(element, (double[])bary.clone());
        while (true) {
            int newElement;
            double[] newBary = this.baryCoords.getNewLast();
            this.strip.add(element);
            double t = BaryCoords3d.add(bary, newBary, newDirection);
            if (0.999999999999 < t) break;
            int edge = BaryCoords3d.getEdge(newBary);
            if (edge != -1) {
                newElement = neighbourData[element][edge];
                if (newElement == -1) {
                    throw new RuntimeException("hit boundary edge");
                }
            } else {
                int localVertex = BaryCoords3d.getVertex(bary);
                if (localVertex != -1) {
                    throw new RuntimeException("geodesic hit vertex; this case is not implemented yet");
                }
                throw new RuntimeException("fatal, error in code");
            }
            BaryCoords3d.changeToOtherElementAtEdge(element, newElement, edge, direction, newDirection, elementData, length[element], length[newElement]);
            element = newElement;
            bary = newBary;
            double[] tmp = newDirection;
            newDirection = direction;
            direction = tmp;
            BaryCoords3d.vecScl(newDirection, newDirection, factor *= 1.0 - t);
        }
    }

    public double[][] getSpaceCurve(int[][] elementData, double[][] pointData) {
        int dim = pointData[0].length;
        int nop = this.strip.size();
        double[][] curveData = new double[nop][dim];
        for (int i = 0; i < nop; ++i) {
            double[] bary = this.baryCoords.get(i);
            double a = bary[0];
            double b = bary[1];
            double c = bary[2];
            int[] element = elementData[this.strip.get(i)];
            double[] A = pointData[element[0]];
            double[] B = pointData[element[1]];
            double[] C = pointData[element[2]];
            double[] curve = curveData[i];
            for (int j = 0; j < dim; ++j) {
                curve[j] = a * A[j] + b * B[j] + c * C[j];
            }
        }
        return curveData;
    }

    public double[] getSpaceCurve(int[][] elementData, double[] pointData, int dim) {
        int nop = this.strip.size();
        double[] curveData = new double[nop * dim];
        int J = 0;
        for (int i = 0; i < nop; ++i) {
            double[] bary = this.baryCoords.get(i);
            double a = bary[0];
            double b = bary[1];
            double c = bary[2];
            int[] element = elementData[this.strip.get(i)];
            int offsetA = element[0] * dim;
            int offsetB = element[1] * dim;
            int offsetC = element[2] * dim;
            int j = 0;
            while (j < dim) {
                curveData[J] = a * pointData[offsetA + j] + b * pointData[offsetB + j] + c * pointData[offsetC + j];
                ++j;
                ++J;
            }
        }
        return curveData;
    }
}

