/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

import java.util.ArrayList;

public class LevelLineUtility {
    public static int[][] generateLineSets(int[] edgeIndices) {
        return LevelLineUtility.generateLineSets(edgeIndices, edgeIndices.length / 2);
    }

    public static int[][] generateLineSets(int[] edgeIndices, int numEdges) {
        ArrayList<int[]> lineList = new ArrayList<int[]>();
        IndexList edges = new IndexList(edgeIndices);
        IndexList line = new IndexList(edgeIndices.length);
        while (edges.size() > 0) {
            line.removeAll();
            line.append(edges.getLast());
            edges.removeLast();
            line.append(edges.getLast());
            edges.removeLast();
            LevelLineUtility.stripLine(line, edges);
            if (line.get(0) != line.getLast()) {
                line.reverse();
                LevelLineUtility.stripLine(line, edges);
            }
            lineList.add(line.toArray());
        }
        return LevelLineUtility.toIntArray(lineList);
    }

    private static void stripLine(IndexList line, IndexList edges) {
        int I;
        while (edges.size() > 0 && (I = edges.searchForIndexValue(line.getLast())) != -1) {
            int edge = I / 2;
            int other = edges.get(2 * edge + (I % 2 + 1) % 2);
            line.append(other);
            edges.set(2 * edge + 1, edges.getLast());
            edges.removeLast();
            edges.set(2 * edge + 0, edges.getLast());
            edges.removeLast();
        }
    }

    static int[][] toIntArray(ArrayList list) {
        int[][] lineArray = new int[list.size()][];
        for (int i = 0; i < lineArray.length; ++i) {
            lineArray[i] = (int[])list.get(i);
        }
        return lineArray;
    }

    public static double lengthOfCurve(double[] points, int dimension) {
        if (points.length % dimension != 0) {
            throw new IllegalArgumentException("dimension and size does not match!");
        }
        double length = 0.0;
        for (int i = dimension; i < points.length; i += dimension) {
            length += LevelLineUtility.dist(points, i - dimension, points, i, dimension);
        }
        return length;
    }

    public static double[] resampleCurve(double[] points, int dimension, int N) {
        if (points.length % dimension != 0) {
            throw new IllegalArgumentException("dimension and size does not match!");
        }
        double[] sample = new double[N * dimension];
        double totalLength = LevelLineUtility.lengthOfCurve(points, dimension);
        double stepSize = totalLength / (double)(N - 1);
        double length = 0.0;
        System.arraycopy(points, 0, sample, 0, dimension);
        int j = 1;
        for (int i = dimension; i < points.length; i += dimension) {
            double edgeLength = LevelLineUtility.dist(points, i - dimension, points, i, dimension);
            while ((double)j * stepSize >= length && (double)j * stepSize < length + edgeLength) {
                double weight = ((double)j * stepSize - length) / edgeLength;
                int k = 0;
                int J = dimension * j;
                while (k < dimension) {
                    sample[J] = weight * points[i] + (1.0 - weight) * points[i - dimension];
                    ++k;
                    ++J;
                }
                ++j;
            }
            length += edgeLength;
        }
        System.arraycopy(points, points.length - dimension, sample, sample.length - dimension, dimension);
        return sample;
    }

    static double dist(double[] s1, int os1, double[] s2, int os2, int dimension) {
        double sum = 0.0;
        int k = 0;
        while (k < dimension) {
            double d = s1[os1] - s2[os2];
            sum += d * d;
            ++k;
            ++os1;
            ++os2;
        }
        return Math.sqrt(sum);
    }

    static double dot(double[] s1, int os1, double[] s2, int os2, int dimension) {
        double sum = 0.0;
        int k = 0;
        while (k < dimension) {
            double d = s1[os1] * s2[os2];
            sum += d;
            ++k;
            ++os1;
            ++os2;
        }
        return sum;
    }

    static class IndexList {
        private final int[] index;
        private int numIndices;

        IndexList(int maxNumber) {
            this.index = new int[maxNumber];
            this.numIndices = 0;
        }

        IndexList(int[] indices) {
            this.index = (int[])indices.clone();
            this.numIndices = indices.length;
        }

        int size() {
            return this.numIndices;
        }

        int getLast() {
            return this.index[this.numIndices - 1];
        }

        int get(int pos) {
            return this.index[pos];
        }

        void set(int pos, int value) {
            this.index[pos] = value;
        }

        void append(int value) {
            this.index[this.numIndices] = value;
            ++this.numIndices;
        }

        void removeLast() {
            --this.numIndices;
        }

        void removeAll() {
            this.numIndices = 0;
        }

        int searchForIndexValue(int value) {
            for (int i = 0; i < this.numIndices; ++i) {
                if (this.index[i] != value) continue;
                return i;
            }
            return -1;
        }

        int[] toArray() {
            int[] dst = new int[this.numIndices];
            System.arraycopy(this.index, 0, dst, 0, this.numIndices);
            return dst;
        }

        void reverse() {
            int n = this.numIndices / 2;
            int i = 0;
            int j = this.numIndices - 1;
            while (i < n) {
                int tmp = this.index[i];
                this.index[i] = this.index[j];
                this.index[j] = tmp;
                ++i;
                --j;
            }
        }
    }
}

