/*
 * Decompiled with CFR 0.152.
 */
package org.apache.neethi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.neethi.util.PolicyComparator;

public abstract class AbstractPolicyOperator
implements PolicyOperator {
    protected ArrayList policyComponents = new ArrayList();

    public void addPolicyComponent(PolicyComponent component) {
        this.policyComponents.add(component);
    }

    public void addPolicyComponents(List components) {
        this.policyComponents.addAll(components);
    }

    public List getPolicyComponents() {
        return this.policyComponents;
    }

    public PolicyComponent getFirstPolicyComponent() {
        return (PolicyComponent)this.policyComponents.get(0);
    }

    public boolean isEmpty() {
        return this.policyComponents.isEmpty();
    }

    public boolean equal(PolicyComponent policyComponent) {
        return PolicyComparator.compare(this, policyComponent);
    }

    protected static Policy normalize(Policy policy, PolicyRegistry reg, boolean deep) {
        String id;
        Policy result = new Policy();
        String policyName = policy.getName();
        if (policyName != null) {
            result.setName(policyName);
        }
        if ((id = policy.getId()) != null) {
            result.setId(id);
        }
        result.addPolicyComponent(AbstractPolicyOperator.normalizeOperator(policy, reg, deep));
        return result;
    }

    private static PolicyComponent normalizeOperator(PolicyOperator operator, PolicyRegistry reg, boolean deep) {
        short type = operator.getType();
        if (operator.isEmpty()) {
            ExactlyOne exactlyOne = new ExactlyOne();
            if (2 != type) {
                exactlyOne.addPolicyComponent(new All());
            }
            return exactlyOne;
        }
        ArrayList<PolicyComponent> childComponentsList = new ArrayList<PolicyComponent>();
        Iterator iterator = operator.getPolicyComponents().iterator();
        while (iterator.hasNext()) {
            PolicyComponent policyComponent = (PolicyComponent)iterator.next();
            if (policyComponent.getType() == 5) {
                if (deep) {
                    policyComponent = ((Assertion)policyComponent).normalize();
                }
                if (policyComponent.getType() == 1) {
                    childComponentsList.add(((Policy)policyComponent).getFirstPolicyComponent());
                    continue;
                }
                ExactlyOne exactlyOne = new ExactlyOne();
                All all = new All();
                all.addPolicyComponent(policyComponent);
                exactlyOne.addPolicyComponent(all);
                childComponentsList.add(exactlyOne);
                continue;
            }
            if (policyComponent.getType() == 4) {
                String uri = ((PolicyReference)policyComponent).getURI();
                if ((policyComponent = reg.lookup(uri)) != null) continue;
                throw new RuntimeException(uri + " can't be resolved");
            }
            if (policyComponent.getType() == 1) {
                All all = new All();
                all.addPolicyComponents(((Policy)policyComponent).getPolicyComponents());
                childComponentsList.add(AbstractPolicyOperator.normalizeOperator(all, reg, deep));
                continue;
            }
            childComponentsList.add(AbstractPolicyOperator.normalizeOperator((PolicyOperator)policyComponent, reg, deep));
        }
        return AbstractPolicyOperator.computeResultantComponent(childComponentsList, type);
    }

    private static PolicyComponent computeResultantComponent(List normalizedInnerComponets, short componentType) {
        ExactlyOne exactlyOne = new ExactlyOne();
        if (componentType == 2) {
            Iterator iter = normalizedInnerComponets.iterator();
            while (iter.hasNext()) {
                ExactlyOne innerExactlyOne = (ExactlyOne)iter.next();
                exactlyOne.addPolicyComponents(innerExactlyOne.getPolicyComponents());
            }
        } else if (componentType == 1 || componentType == 3) {
            if (normalizedInnerComponets.size() > 1) {
                Iterator iter = normalizedInnerComponets.iterator();
                exactlyOne = (ExactlyOne)iter.next();
                if (!exactlyOne.isEmpty()) {
                    while (iter.hasNext()) {
                        ExactlyOne currentExactlyOne = (ExactlyOne)iter.next();
                        if (currentExactlyOne.isEmpty()) {
                            exactlyOne = currentExactlyOne;
                            break;
                        }
                        exactlyOne = AbstractPolicyOperator.getCrossProduct(exactlyOne, currentExactlyOne);
                    }
                }
            } else {
                exactlyOne = (ExactlyOne)normalizedInnerComponets.iterator().next();
            }
        }
        return exactlyOne;
    }

    private static ExactlyOne getCrossProduct(ExactlyOne exactlyOne1, ExactlyOne exactlyOne2) {
        ExactlyOne crossProduct = new ExactlyOne();
        Iterator iter1 = exactlyOne1.getPolicyComponents().iterator();
        while (iter1.hasNext()) {
            All currentAll1 = (All)iter1.next();
            Iterator iter2 = exactlyOne2.getPolicyComponents().iterator();
            while (iter2.hasNext()) {
                All currentAll2 = (All)iter2.next();
                All crossProductAll = new All();
                crossProductAll.addPolicyComponents(currentAll1.getPolicyComponents());
                crossProductAll.addPolicyComponents(currentAll2.getPolicyComponents());
                crossProduct.addPolicyComponent(crossProductAll);
            }
        }
        return crossProduct;
    }
}

