/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import jj2000.j2k.io.RandomAccessIO;

public final class ImageHeaderBox
extends JP2Box {
    long height;
    long width;
    int nc;
    short bpc;
    short c;
    boolean unk;
    boolean ipr;

    static {
        type = 69686472;
    }

    public ImageHeaderBox(RandomAccessIO in, int boxStart) throws IOException, ColorSpaceException {
        super(in, boxStart);
        this.readBox();
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[ImageHeaderBox ").append(eol).append("  ");
        rep.append("height= ").append(String.valueOf(this.height)).append(", ");
        rep.append("width= ").append(String.valueOf(this.width)).append(eol).append("  ");
        rep.append("nc= ").append(String.valueOf(this.nc)).append(", ");
        rep.append("bpc= ").append(String.valueOf(this.bpc)).append(", ");
        rep.append("c= ").append(String.valueOf(this.c)).append(eol).append("  ");
        rep.append("image colorspace is ").append(new String(this.unk ? "known" : "unknown"));
        rep.append(", the image ").append(new String(this.ipr ? "contains " : "does not contain ")).append("intellectual property").append("]");
        return rep.toString();
    }

    void readBox() throws IOException {
        byte[] bfr = new byte[14];
        this.in.seek(this.dataStart);
        this.in.readFully(bfr, 0, 14);
        this.height = ICCProfile.getInt(bfr, 0);
        this.width = ICCProfile.getInt(bfr, 4);
        this.nc = ICCProfile.getShort(bfr, 8);
        this.bpc = (short)(bfr[10] & 0xFF);
        this.c = (short)(bfr[11] & 0xFF);
        this.unk = bfr[12] == 0;
        this.ipr = bfr[13] == 1;
    }
}

