/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import icc.ICCProfile;
import java.io.IOException;
import java.util.Hashtable;
import jj2000.j2k.io.RandomAccessIO;

public abstract class JP2Box {
    public static final String eol = System.getProperty("line.separator");
    public static int type;
    public int length;
    protected RandomAccessIO in;
    protected int boxStart;
    protected int boxEnd;
    protected int dataStart;

    public static String getTypeString(int t) {
        return BoxType.get(t);
    }

    public JP2Box() throws ColorSpaceException {
        try {
            throw new ColorSpaceException("JP2Box empty ctor called!!");
        }
        catch (ColorSpaceException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public JP2Box(RandomAccessIO in, int boxStart) throws IOException, ColorSpaceException {
        byte[] boxHeader = new byte[16];
        this.in = in;
        this.boxStart = boxStart;
        this.in.seek(this.boxStart);
        this.in.readFully(boxHeader, 0, 8);
        this.dataStart = boxStart + 8;
        this.length = ICCProfile.getInt(boxHeader, 0);
        this.boxEnd = boxStart + this.length;
        if (this.length == 1) {
            throw new ColorSpaceException("extended length boxes not supported");
        }
    }

    public String getTypeString() {
        return BoxType.get(type);
    }

    protected static class BoxType
    extends Hashtable {
        private static Hashtable map = new Hashtable();

        static {
            BoxType.put(1651532643, "BITS_PER_COMPONENT_BOX");
            BoxType.put(1919251299, "CAPTURE_RESOLUTION_BOX");
            BoxType.put(1667523942, "CHANNEL_DEFINITION_BOX");
            BoxType.put(1668246642, "COLOUR_SPECIFICATION_BOX");
            BoxType.put(1668112752, "COMPONENT_MAPPING_BOX");
            BoxType.put(1785737827, "CONTIGUOUS_CODESTREAM_BOX");
            BoxType.put(1919251300, "DEFAULT_DISPLAY_RESOLUTION_BOX");
            BoxType.put(1718909296, "FILE_TYPE_BOX");
            BoxType.put(1768449138, "IMAGE_HEADER_BOX");
            BoxType.put(1685074537, "INTELLECTUAL_PROPERTY_BOX");
            BoxType.put(1785737832, "JP2_HEADER_BOX");
            BoxType.put(1783636000, "JP2_SIGNATURE_BOX");
            BoxType.put(1885564018, "PALETTE_BOX");
            BoxType.put(1919251232, "RESOLUTION_BOX");
            BoxType.put(1970433056, "URL_BOX");
            BoxType.put(1970628964, "UUID_BOX");
            BoxType.put(1969843814, "UUID_INFO_BOX");
            BoxType.put(1969451892, "UUID_LIST_BOX");
            BoxType.put(2020437024, "XML_BOX");
        }

        protected BoxType() {
        }

        private static void put(int type, String desc) {
            map.put(new Integer(type), desc);
        }

        public static String get(int type) {
            return (String)map.get(new Integer(type));
        }
    }
}

