/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import icc.lut.LookUpTable;
import icc.lut.LookUpTable16Gamma;
import icc.lut.LookUpTable16Interp;
import icc.tags.ICCCurveType;

public abstract class LookUpTable16
extends LookUpTable {
    protected final int dwMaxOutput;
    protected final short[] lut;

    public String toString() {
        StringBuffer rep = new StringBuffer("[LookUpTable16 ");
        rep.append("max= " + this.dwMaxOutput);
        rep.append(", nentries= " + this.dwMaxOutput);
        return rep.append("]").toString();
    }

    public String toStringWholeLut() {
        int col;
        StringBuffer rep = new StringBuffer("[LookUpTable16" + eol);
        rep.append("max output = " + this.dwMaxOutput + eol);
        int row = 0;
        while (row < this.dwNumInput / 10) {
            rep.append("lut[" + 10 * row + "] : ");
            col = 0;
            while (col < 10) {
                rep.append(this.lut[10 * row + col]).append(" ");
                ++col;
            }
            rep.append(eol);
            ++row;
        }
        rep.append("lut[" + 10 * row + "] : ");
        col = 0;
        while (col < this.dwNumInput % 10) {
            rep.append(String.valueOf(this.lut[10 * row + col]) + " ");
            ++col;
        }
        rep.append(String.valueOf(eol) + eol);
        return rep.toString();
    }

    public static LookUpTable16 createInstance(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        if (curve.count == 1) {
            return new LookUpTable16Gamma(curve, dwNumInput, dwMaxOutput);
        }
        return new LookUpTable16Interp(curve, dwNumInput, dwMaxOutput);
    }

    protected LookUpTable16(int dwNumInput, int dwMaxOutput) {
        super(null, dwNumInput);
        this.lut = new short[dwNumInput];
        this.dwMaxOutput = dwMaxOutput;
    }

    protected LookUpTable16(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        super(curve, dwNumInput);
        this.dwMaxOutput = dwMaxOutput;
        this.lut = new short[dwNumInput];
    }

    public final short elementAt(int index) {
        return this.lut[index];
    }
}

