/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import icc.lut.LookUpTable;
import icc.lut.LookUpTable32Gamma;
import icc.lut.LookUpTable32Interp;
import icc.tags.ICCCurveType;

abstract class LookUpTable32
extends LookUpTable {
    protected final int dwMaxOutput;
    public final int[] lut;

    public String toString() {
        StringBuffer rep = new StringBuffer("[LookUpTable32 ");
        rep.append("max= " + this.dwMaxOutput);
        rep.append(", nentries= " + this.dwNumInput);
        return rep.append("]").toString();
    }

    public String toStringWholeLut() {
        int col;
        StringBuffer rep = new StringBuffer("[LookUpTable32" + eol);
        rep.append("max output = " + this.dwMaxOutput + eol);
        int row = 0;
        while (row < this.dwNumInput / 10) {
            rep.append("lut[" + 10 * row + "] : ");
            col = 0;
            while (col < 10) {
                rep.append(String.valueOf(this.lut[10 * row + col]) + " ");
                ++col;
            }
            rep.append(eol);
            ++row;
        }
        rep.append("lut[" + 10 * row + "] : ");
        col = 0;
        while (col < this.dwNumInput % 10) {
            rep.append(String.valueOf(this.lut[10 * row + col]) + " ");
            ++col;
        }
        rep.append(String.valueOf(eol) + eol);
        return rep.toString();
    }

    public static LookUpTable32 createInstance(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        if (curve.count == 1) {
            return new LookUpTable32Gamma(curve, dwNumInput, dwMaxOutput);
        }
        return new LookUpTable32Interp(curve, dwNumInput, dwMaxOutput);
    }

    protected LookUpTable32(int dwNumInput, int dwMaxOutput) {
        super(null, dwNumInput);
        this.lut = new int[dwNumInput];
        this.dwMaxOutput = dwMaxOutput;
    }

    protected LookUpTable32(ICCCurveType curve, int dwNumInput, int dwMaxOutput) {
        super(curve, dwNumInput);
        this.dwMaxOutput = dwMaxOutput;
        this.lut = new int[dwNumInput];
    }

    public final int elementAt(int index) {
        return this.lut[index];
    }
}

