/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import colorspace.ChannelDefinitionMapper;
import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import colorspace.PalettizedColorSpaceMapper;
import colorspace.Resampler;
import icc.ICCProfileException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.entropy.decoder.StdEntropyDecoder;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SynWTFilter;
import jj2000.j2k.wavelet.synthesis.SynWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.synthesis.SynWTFilterIntLift5x3;

public class HeaderDecoder
implements ProgressionType,
Markers,
StdEntropyCoderOptions {
    public static final char OPT_PREFIX = 'H';
    private static final String[][] pinfo = null;
    private HeaderInfo hi;
    private boolean verbose;
    private String hdStr = "";
    private int nTiles;
    public int[] nTileParts;
    private int nfMarkSeg = 0;
    private int nCOCMarkSeg = 0;
    private int nQCCMarkSeg = 0;
    private int nCOMMarkSeg = 0;
    private int nRGNMarkSeg = 0;
    private int nPPMMarkSeg = 0;
    private int[][] nPPTMarkSeg = null;
    private static final int SIZ_FOUND = 1;
    private static final int COD_FOUND = 2;
    private static final int COC_FOUND = 4;
    private static final int QCD_FOUND = 8;
    private static final int TLM_FOUND = 16;
    private static final int PLM_FOUND = 32;
    private static final int SOT_FOUND = 64;
    private static final int PLT_FOUND = 128;
    private static final int QCC_FOUND = 256;
    private static final int RGN_FOUND = 512;
    private static final int POC_FOUND = 1024;
    private static final int COM_FOUND = 2048;
    public static final int SOD_FOUND = 8192;
    public static final int PPM_FOUND = 16384;
    public static final int PPT_FOUND = 32768;
    public static final int CRG_FOUND = 65536;
    private static final int TILE_RESET = -546;
    private Hashtable ht = null;
    private int nComp;
    private int cb0x = -1;
    private int cb0y = -1;
    private DecoderSpecs decSpec;
    boolean precinctPartitionIsUsed;
    public int mainHeadOff;
    public Vector tileOfTileParts;
    private byte[][] pPMMarkerData;
    private byte[][][][] tilePartPkdPktHeaders;
    private ByteArrayOutputStream[] pkdPktHeaders;

    public int getMaxCompImgHeight() {
        return this.hi.siz.getMaxCompHeight();
    }

    public int getMaxCompImgWidth() {
        return this.hi.siz.getMaxCompWidth();
    }

    public final int getImgWidth() {
        return this.hi.siz.xsiz - this.hi.siz.x0siz;
    }

    public final int getImgHeight() {
        return this.hi.siz.ysiz - this.hi.siz.y0siz;
    }

    public final int getImgULX() {
        return this.hi.siz.x0siz;
    }

    public final int getImgULY() {
        return this.hi.siz.y0siz;
    }

    public final int getNomTileWidth() {
        return this.hi.siz.xtsiz;
    }

    public final int getNomTileHeight() {
        return this.hi.siz.ytsiz;
    }

    public final Coord getTilingOrigin(Coord co) {
        if (co != null) {
            co.x = this.hi.siz.xt0siz;
            co.y = this.hi.siz.yt0siz;
            return co;
        }
        return new Coord(this.hi.siz.xt0siz, this.hi.siz.yt0siz);
    }

    public final boolean isOriginalSigned(int c) {
        return this.hi.siz.isOrigSigned(c);
    }

    public final int getOriginalBitDepth(int c) {
        return this.hi.siz.getOrigBitDepth(c);
    }

    public final int getNumComps() {
        return this.nComp;
    }

    public final int getCompSubsX(int c) {
        return this.hi.siz.xrsiz[c];
    }

    public final int getCompSubsY(int c) {
        return this.hi.siz.yrsiz[c];
    }

    public final Dequantizer createDequantizer(CBlkQuantDataSrcDec src, int[] rb, DecoderSpecs decSpec2) {
        return new StdDequantizer(src, rb, decSpec2);
    }

    public final int getCbULX() {
        return this.cb0x;
    }

    public final int getCbULY() {
        return this.cb0y;
    }

    public final int getPPX(int t, int c, int rl) {
        return this.decSpec.pss.getPPX(t, c, rl);
    }

    public final int getPPY(int t, int c, int rl) {
        return this.decSpec.pss.getPPY(t, c, rl);
    }

    public final boolean precinctPartitionUsed() {
        return this.precinctPartitionIsUsed;
    }

    private SynWTFilter readFilter(DataInputStream ehs, int[] filtIdx) throws IOException {
        filtIdx[0] = ehs.readUnsignedByte();
        int kid = filtIdx[0];
        if (kid >= 128) {
            throw new NotImplementedError("Custom filters not supported");
        }
        switch (kid) {
            case 0: {
                return new SynWTFilterFloatLift9x7();
            }
            case 1: {
                return new SynWTFilterIntLift5x3();
            }
        }
        throw new CorruptedCodestreamException("Specified wavelet filter not JPEG 2000 part I compliant");
    }

    public void checkMarkerLength(DataInputStream ehs, String str) throws IOException {
        if (ehs.available() != 0) {
            FacilityManager.getMsgLogger().printmsg(2, String.valueOf(str) + " length was short, attempting to resync.");
        }
    }

    private void readSIZ(DataInputStream ehs) throws IOException {
        HeaderInfo.SIZ ms;
        this.hi.siz = ms = this.hi.getNewSIZ();
        ms.lsiz = ehs.readUnsignedShort();
        ms.rsiz = ehs.readUnsignedShort();
        if (ms.rsiz > 2) {
            throw new Error("Codestream capabiities not JPEG 2000 - Part I compliant");
        }
        ms.xsiz = ehs.readInt();
        ms.ysiz = ehs.readInt();
        if (ms.xsiz <= 0 || ms.ysiz <= 0) {
            throw new IOException("JJ2000 does not support images whose width and/or height not in the range: 1 -- (2^31)-1");
        }
        ms.x0siz = ehs.readInt();
        ms.y0siz = ehs.readInt();
        if (ms.x0siz < 0 || ms.y0siz < 0) {
            throw new IOException("JJ2000 does not support images offset not in the range: 0 -- (2^31)-1");
        }
        ms.xtsiz = ehs.readInt();
        ms.ytsiz = ehs.readInt();
        if (ms.xtsiz <= 0 || ms.ytsiz <= 0) {
            throw new IOException("JJ2000 does not support tiles whose width and/or height are not in  the range: 1 -- (2^31)-1");
        }
        ms.xt0siz = ehs.readInt();
        ms.yt0siz = ehs.readInt();
        if (ms.xt0siz < 0 || ms.yt0siz < 0) {
            throw new IOException("JJ2000 does not support tiles whose offset is not in  the range: 0 -- (2^31)-1");
        }
        this.nComp = ms.csiz = ehs.readUnsignedShort();
        if (this.nComp < 1 || this.nComp > 16384) {
            throw new IllegalArgumentException("Number of component out of range 1--16384: " + this.nComp);
        }
        ms.ssiz = new int[this.nComp];
        ms.xrsiz = new int[this.nComp];
        ms.yrsiz = new int[this.nComp];
        int i = 0;
        while (i < this.nComp) {
            ms.ssiz[i] = ehs.readUnsignedByte();
            ms.xrsiz[i] = ehs.readUnsignedByte();
            ms.yrsiz[i] = ehs.readUnsignedByte();
            ++i;
        }
        this.checkMarkerLength(ehs, "SIZ marker");
        this.nTiles = ms.getNumTiles();
        this.decSpec = new DecoderSpecs(this.nTiles, this.nComp);
    }

    private void readCRG(DataInputStream ehs) throws IOException {
        HeaderInfo.CRG ms;
        this.hi.crg = ms = this.hi.getNewCRG();
        ms.lcrg = ehs.readUnsignedShort();
        ms.xcrg = new int[this.nComp];
        ms.ycrg = new int[this.nComp];
        FacilityManager.getMsgLogger().printmsg(2, "Information in CRG marker segment not taken into account. This may affect the display of the decoded image.");
        int c = 0;
        while (c < this.nComp) {
            ms.xcrg[c] = ehs.readUnsignedShort();
            ms.ycrg[c] = ehs.readUnsignedShort();
            ++c;
        }
        this.checkMarkerLength(ehs, "CRG marker");
    }

    private void readCOM(DataInputStream ehs, boolean mainh, int tileIdx, int comIdx) throws IOException {
        HeaderInfo.COM ms = this.hi.getNewCOM();
        ms.lcom = ehs.readUnsignedShort();
        ms.rcom = ehs.readUnsignedShort();
        switch (ms.rcom) {
            case 1: {
                ms.ccom = new byte[ms.lcom - 4];
                int i = 0;
                while (i < ms.lcom - 4) {
                    ms.ccom[i] = ehs.readByte();
                    ++i;
                }
                break;
            }
            default: {
                FacilityManager.getMsgLogger().printmsg(2, "COM marker registered as 0x" + Integer.toHexString(ms.rcom) + " unknown, ignoring (this might crash the " + "decoder or decode a quality degraded or even " + "useless image)");
                ehs.skipBytes(ms.lcom - 4);
            }
        }
        if (mainh) {
            this.hi.com.put("main_" + comIdx, ms);
        } else {
            this.hi.com.put("t" + tileIdx + "_" + comIdx, ms);
        }
        this.checkMarkerLength(ehs, "COM marker");
    }

    private void readQCD(DataInputStream ehs, boolean mainh, int tileIdx, int tpIdx) throws IOException {
        int qType;
        int guardBits;
        float[][] nStep;
        block23: {
            HeaderInfo.QCD ms;
            block22: {
                nStep = null;
                ms = this.hi.getNewQCD();
                ms.lqcd = ehs.readUnsignedShort();
                ms.sqcd = ehs.readUnsignedByte();
                guardBits = ms.getNumGuardBits();
                qType = ms.getQuantType();
                if (!mainh) break block22;
                this.hi.qcd.put("main", ms);
                switch (qType) {
                    case 0: {
                        this.decSpec.qts.setDefault("reversible");
                        break block23;
                    }
                    case 1: {
                        this.decSpec.qts.setDefault("derived");
                        break block23;
                    }
                    case 2: {
                        this.decSpec.qts.setDefault("expounded");
                        break block23;
                    }
                    default: {
                        throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker main header");
                    }
                }
            }
            this.hi.qcd.put("t" + tileIdx, ms);
            switch (qType) {
                case 0: {
                    this.decSpec.qts.setTileDef(tileIdx, "reversible");
                    break;
                }
                case 1: {
                    this.decSpec.qts.setTileDef(tileIdx, "derived");
                    break;
                }
                case 2: {
                    this.decSpec.qts.setTileDef(tileIdx, "expounded");
                    break;
                }
                default: {
                    throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, tile header");
                }
            }
        }
        StdDequantizerParams qParms = new StdDequantizerParams();
        if (qType == 0) {
            int maxrl = mainh ? ((Integer)this.decSpec.dls.getDefault()).intValue() : ((Integer)this.decSpec.dls.getTileDef(tileIdx)).intValue();
            qParms.exp = new int[maxrl + 1][];
            int[][] exp = qParms.exp;
            ms.spqcd = new int[maxrl + 1][4];
            int rl = 0;
            while (rl <= maxrl) {
                int maxb;
                int minb;
                if (rl == 0) {
                    minb = 0;
                    maxb = 1;
                } else {
                    int hpd = 1;
                    hpd = hpd > maxrl - rl ? (hpd -= maxrl - rl) : 1;
                    minb = 1 << (hpd - 1 << 1);
                    maxb = 1 << (hpd << 1);
                }
                exp[rl] = new int[maxb];
                int j = minb;
                while (j < maxb) {
                    int n = ehs.readUnsignedByte();
                    ms.spqcd[rl][j] = n;
                    int tmp = n;
                    exp[rl][j] = tmp >> 3 & 0x1F;
                    ++j;
                }
                ++rl;
            }
        } else {
            int maxrl = qType == 1 ? 0 : (mainh ? ((Integer)this.decSpec.dls.getDefault()).intValue() : ((Integer)this.decSpec.dls.getTileDef(tileIdx)).intValue());
            qParms.exp = new int[maxrl + 1][];
            int[][] exp = qParms.exp;
            qParms.nStep = new float[maxrl + 1][];
            nStep = qParms.nStep;
            ms.spqcd = new int[maxrl + 1][4];
            int rl = 0;
            while (rl <= maxrl) {
                int maxb;
                int minb;
                if (rl == 0) {
                    minb = 0;
                    maxb = 1;
                } else {
                    int hpd = 1;
                    hpd = hpd > maxrl - rl ? (hpd -= maxrl - rl) : 1;
                    minb = 1 << (hpd - 1 << 1);
                    maxb = 1 << (hpd << 1);
                }
                exp[rl] = new int[maxb];
                nStep[rl] = new float[maxb];
                int j = minb;
                while (j < maxb) {
                    int n = ehs.readUnsignedShort();
                    ms.spqcd[rl][j] = n;
                    int tmp = n;
                    exp[rl][j] = tmp >> 11 & 0x1F;
                    nStep[rl][j] = (-1.0f - (float)(tmp & 0x7FF) / 2048.0f) / (float)(-1 << exp[rl][j]);
                    ++j;
                }
                ++rl;
            }
        }
        if (mainh) {
            this.decSpec.qsss.setDefault(qParms);
            this.decSpec.gbs.setDefault(new Integer(guardBits));
        } else {
            this.decSpec.qsss.setTileDef(tileIdx, qParms);
            this.decSpec.gbs.setTileDef(tileIdx, new Integer(guardBits));
        }
        this.checkMarkerLength(ehs, "QCD marker");
    }

    private void readQCC(DataInputStream ehs, boolean mainh, int tileIdx, int tpIdx) throws IOException {
        int qType;
        int guardBits;
        int cComp;
        float[][] nStepC;
        block24: {
            HeaderInfo.QCC ms;
            block23: {
                nStepC = null;
                ms = this.hi.getNewQCC();
                ms.lqcc = ehs.readUnsignedShort();
                cComp = this.nComp < 257 ? (ms.cqcc = ehs.readUnsignedByte()) : (ms.cqcc = ehs.readUnsignedShort());
                if (cComp >= this.nComp) {
                    throw new CorruptedCodestreamException("Invalid component index in QCC marker");
                }
                ms.sqcc = ehs.readUnsignedByte();
                guardBits = ms.getNumGuardBits();
                qType = ms.getQuantType();
                if (!mainh) break block23;
                this.hi.qcc.put("main_c" + cComp, ms);
                switch (qType) {
                    case 0: {
                        this.decSpec.qts.setCompDef(cComp, "reversible");
                        break block24;
                    }
                    case 1: {
                        this.decSpec.qts.setCompDef(cComp, "derived");
                        break block24;
                    }
                    case 2: {
                        this.decSpec.qts.setCompDef(cComp, "expounded");
                        break block24;
                    }
                    default: {
                        throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, main header");
                    }
                }
            }
            this.hi.qcc.put("t" + tileIdx + "_c" + cComp, ms);
            switch (qType) {
                case 0: {
                    this.decSpec.qts.setTileCompVal(tileIdx, cComp, "reversible");
                    break;
                }
                case 1: {
                    this.decSpec.qts.setTileCompVal(tileIdx, cComp, "derived");
                    break;
                }
                case 2: {
                    this.decSpec.qts.setTileCompVal(tileIdx, cComp, "expounded");
                    break;
                }
                default: {
                    throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, main header");
                }
            }
        }
        StdDequantizerParams qParms = new StdDequantizerParams();
        if (qType == 0) {
            int maxrl = mainh ? ((Integer)this.decSpec.dls.getCompDef(cComp)).intValue() : ((Integer)this.decSpec.dls.getTileCompVal(tileIdx, cComp)).intValue();
            qParms.exp = new int[maxrl + 1][];
            int[][] expC = qParms.exp;
            ms.spqcc = new int[maxrl + 1][4];
            int rl = 0;
            while (rl <= maxrl) {
                int maxb;
                int minb;
                if (rl == 0) {
                    minb = 0;
                    maxb = 1;
                } else {
                    int hpd = 1;
                    hpd = hpd > maxrl - rl ? (hpd -= maxrl - rl) : 1;
                    minb = 1 << (hpd - 1 << 1);
                    maxb = 1 << (hpd << 1);
                }
                expC[rl] = new int[maxb];
                int j = minb;
                while (j < maxb) {
                    int n = ehs.readUnsignedByte();
                    ms.spqcc[rl][j] = n;
                    int tmp = n;
                    expC[rl][j] = tmp >> 3 & 0x1F;
                    ++j;
                }
                ++rl;
            }
        } else {
            int maxrl = qType == 1 ? 0 : (mainh ? ((Integer)this.decSpec.dls.getCompDef(cComp)).intValue() : ((Integer)this.decSpec.dls.getTileCompVal(tileIdx, cComp)).intValue());
            qParms.nStep = new float[maxrl + 1][];
            nStepC = qParms.nStep;
            qParms.exp = new int[maxrl + 1][];
            int[][] expC = qParms.exp;
            ms.spqcc = new int[maxrl + 1][4];
            int rl = 0;
            while (rl <= maxrl) {
                int maxb;
                int minb;
                if (rl == 0) {
                    minb = 0;
                    maxb = 1;
                } else {
                    int hpd = 1;
                    hpd = hpd > maxrl - rl ? (hpd -= maxrl - rl) : 1;
                    minb = 1 << (hpd - 1 << 1);
                    maxb = 1 << (hpd << 1);
                }
                expC[rl] = new int[maxb];
                nStepC[rl] = new float[maxb];
                int j = minb;
                while (j < maxb) {
                    int n = ehs.readUnsignedShort();
                    ms.spqcc[rl][j] = n;
                    int tmp = n;
                    expC[rl][j] = tmp >> 11 & 0x1F;
                    nStepC[rl][j] = (-1.0f - (float)(tmp & 0x7FF) / 2048.0f) / (float)(-1 << expC[rl][j]);
                    ++j;
                }
                ++rl;
            }
        }
        if (mainh) {
            this.decSpec.qsss.setCompDef(cComp, qParms);
            this.decSpec.gbs.setCompDef(cComp, new Integer(guardBits));
        } else {
            this.decSpec.qsss.setTileCompVal(tileIdx, cComp, qParms);
            this.decSpec.gbs.setTileCompVal(tileIdx, cComp, new Integer(guardBits));
        }
        this.checkMarkerLength(ehs, "QCC marker");
    }

    private void readCOD(DataInputStream ehs, boolean mainh, int tileIdx, int tpIdx) throws IOException {
        boolean sopUsed = false;
        boolean ephUsed = false;
        HeaderInfo.COD ms = this.hi.getNewCOD();
        ms.lcod = ehs.readUnsignedShort();
        ms.scod = ehs.readUnsignedByte();
        int cstyle = ms.scod;
        if ((cstyle & 1) != 0) {
            this.precinctPartitionIsUsed = true;
            cstyle &= 0xFFFFFFFE;
        } else {
            this.precinctPartitionIsUsed = false;
        }
        if (mainh) {
            this.hi.cod.put("main", ms);
            if ((cstyle & 2) != 0) {
                this.decSpec.sops.setDefault(new Boolean("true"));
                sopUsed = true;
                cstyle &= 0xFFFFFFFD;
            } else {
                this.decSpec.sops.setDefault(new Boolean("false"));
            }
        } else {
            this.hi.cod.put("t" + tileIdx, ms);
            if ((cstyle & 2) != 0) {
                this.decSpec.sops.setTileDef(tileIdx, new Boolean("true"));
                sopUsed = true;
                cstyle &= 0xFFFFFFFD;
            } else {
                this.decSpec.sops.setTileDef(tileIdx, new Boolean("false"));
            }
        }
        if (mainh) {
            if ((cstyle & 4) != 0) {
                this.decSpec.ephs.setDefault(new Boolean("true"));
                ephUsed = true;
                cstyle &= 0xFFFFFFFB;
            } else {
                this.decSpec.ephs.setDefault(new Boolean("false"));
            }
        } else if ((cstyle & 4) != 0) {
            this.decSpec.ephs.setTileDef(tileIdx, new Boolean("true"));
            ephUsed = true;
            cstyle &= 0xFFFFFFFB;
        } else {
            this.decSpec.ephs.setTileDef(tileIdx, new Boolean("false"));
        }
        if ((cstyle & 0x18) != 0) {
            FacilityManager.getMsgLogger().printmsg(2, "Code-block partition origin different from (0,0). This is defined in JPEG 2000 part 2 and may not be supported by all JPEG 2000 decoders.");
        }
        if ((cstyle & 8) != 0) {
            if (this.cb0x != -1 && this.cb0x == 0) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0x = 1;
            cstyle &= 0xFFFFFFF7;
        } else {
            if (this.cb0x != -1 && this.cb0x == 1) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0x = 0;
        }
        if ((cstyle & 0x10) != 0) {
            if (this.cb0y != -1 && this.cb0y == 0) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0y = 1;
            cstyle &= 0xFFFFFFEF;
        } else {
            if (this.cb0y != -1 && this.cb0y == 1) {
                throw new IllegalArgumentException("Code-block partition origin redefined in new COD marker segment. Not supported by JJ2000");
            }
            this.cb0y = 0;
        }
        ms.sgcod_po = ehs.readUnsignedByte();
        ms.sgcod_nl = ehs.readUnsignedShort();
        if (ms.sgcod_nl <= 0 || ms.sgcod_nl > 65535) {
            throw new CorruptedCodestreamException("Number of layers out of range: 1--65535");
        }
        ms.sgcod_mct = ehs.readUnsignedByte();
        ms.spcod_ndl = ehs.readUnsignedByte();
        int mrl = ms.spcod_ndl;
        if (mrl > 32) {
            throw new CorruptedCodestreamException("Number of decomposition levels out of range: 0--32");
        }
        Integer[] cblk = new Integer[2];
        ms.spcod_cw = ehs.readUnsignedByte();
        cblk[0] = new Integer(1 << ms.spcod_cw + 2);
        if (cblk[0] < 4 || cblk[0] > 1024) {
            String errMsg = "Non-valid code-block width in SPcod field, COD marker";
            throw new CorruptedCodestreamException(errMsg);
        }
        ms.spcod_ch = ehs.readUnsignedByte();
        cblk[1] = new Integer(1 << ms.spcod_ch + 2);
        if (cblk[1] < 4 || cblk[1] > 1024) {
            String errMsg = "Non-valid code-block height in SPcod field, COD marker";
            throw new CorruptedCodestreamException(errMsg);
        }
        if (cblk[0] * cblk[1] > 4096) {
            String errMsg = "Non-valid code-block area in SPcod field, COD marker";
            throw new CorruptedCodestreamException(errMsg);
        }
        if (mainh) {
            this.decSpec.cblks.setDefault(cblk);
        } else {
            this.decSpec.cblks.setTileDef(tileIdx, cblk);
        }
        int ecOptions = ms.spcod_cs = ehs.readUnsignedByte();
        if ((ecOptions & 0xFFFFFFC0) != 0) {
            throw new CorruptedCodestreamException("Unknown \"code-block style\" in SPcod field, COD marker: 0x" + Integer.toHexString(ecOptions));
        }
        SynWTFilter[] hfilters = new SynWTFilter[1];
        SynWTFilter[] vfilters = new SynWTFilter[1];
        hfilters[0] = this.readFilter(ehs, ms.spcod_t);
        vfilters[0] = hfilters[0];
        SynWTFilter[][] hvfilters = new SynWTFilter[][]{hfilters, vfilters};
        Vector[] v = new Vector[]{new Vector(), new Vector()};
        int val = 65535;
        if (!this.precinctPartitionIsUsed) {
            Integer w = new Integer(1 << (val & 0xF));
            v[0].addElement(w);
            Integer h = new Integer(1 << ((val & 0xF0) >> 4));
            v[1].addElement(h);
        } else {
            ms.spcod_ps = new int[mrl + 1];
            int rl = mrl;
            while (rl >= 0) {
                int n = ehs.readUnsignedByte();
                ms.spcod_ps[mrl - rl] = n;
                val = n;
                Integer w = new Integer(1 << (val & 0xF));
                v[0].insertElementAt(w, 0);
                Integer h = new Integer(1 << ((val & 0xF0) >> 4));
                v[1].insertElementAt(h, 0);
                --rl;
            }
        }
        if (mainh) {
            this.decSpec.pss.setDefault(v);
        } else {
            this.decSpec.pss.setTileDef(tileIdx, v);
        }
        this.precinctPartitionIsUsed = true;
        this.checkMarkerLength(ehs, "COD marker");
        if (mainh) {
            this.decSpec.wfs.setDefault(hvfilters);
            this.decSpec.dls.setDefault(new Integer(mrl));
            this.decSpec.ecopts.setDefault(new Integer(ecOptions));
            this.decSpec.cts.setDefault(new Integer(ms.sgcod_mct));
            this.decSpec.nls.setDefault(new Integer(ms.sgcod_nl));
            this.decSpec.pos.setDefault(new Integer(ms.sgcod_po));
        } else {
            this.decSpec.wfs.setTileDef(tileIdx, hvfilters);
            this.decSpec.dls.setTileDef(tileIdx, new Integer(mrl));
            this.decSpec.ecopts.setTileDef(tileIdx, new Integer(ecOptions));
            this.decSpec.cts.setTileDef(tileIdx, new Integer(ms.sgcod_mct));
            this.decSpec.nls.setTileDef(tileIdx, new Integer(ms.sgcod_nl));
            this.decSpec.pos.setTileDef(tileIdx, new Integer(ms.sgcod_po));
        }
    }

    private void readCOC(DataInputStream ehs, boolean mainh, int tileIdx, int tpIdx) throws IOException {
        HeaderInfo.COC ms = this.hi.getNewCOC();
        ms.lcoc = ehs.readUnsignedShort();
        int cComp = this.nComp < 257 ? (ms.ccoc = ehs.readUnsignedByte()) : (ms.ccoc = ehs.readUnsignedShort());
        if (cComp >= this.nComp) {
            throw new CorruptedCodestreamException("Invalid component index in QCC marker");
        }
        ms.scoc = ehs.readUnsignedByte();
        int cstyle = ms.scoc;
        if ((cstyle & 1) != 0) {
            this.precinctPartitionIsUsed = true;
            cstyle &= 0xFFFFFFFE;
        } else {
            this.precinctPartitionIsUsed = false;
        }
        int mrl = ms.spcoc_ndl = ehs.readUnsignedByte();
        Integer[] cblk = new Integer[2];
        ms.spcoc_cw = ehs.readUnsignedByte();
        cblk[0] = new Integer(1 << ms.spcoc_cw + 2);
        if (cblk[0] < 4 || cblk[0] > 1024) {
            String errMsg = "Non-valid code-block width in SPcod field, COC marker";
            throw new CorruptedCodestreamException(errMsg);
        }
        ms.spcoc_ch = ehs.readUnsignedByte();
        cblk[1] = new Integer(1 << ms.spcoc_ch + 2);
        if (cblk[1] < 4 || cblk[1] > 1024) {
            String errMsg = "Non-valid code-block height in SPcod field, COC marker";
            throw new CorruptedCodestreamException(errMsg);
        }
        if (cblk[0] * cblk[1] > 4096) {
            String errMsg = "Non-valid code-block area in SPcod field, COC marker";
            throw new CorruptedCodestreamException(errMsg);
        }
        if (mainh) {
            this.decSpec.cblks.setCompDef(cComp, cblk);
        } else {
            this.decSpec.cblks.setTileCompVal(tileIdx, cComp, cblk);
        }
        int ecOptions = ms.spcoc_cs = ehs.readUnsignedByte();
        if ((ecOptions & 0xFFFFFFC0) != 0) {
            throw new CorruptedCodestreamException("Unknown \"code-block context\" in SPcoc field, COC marker: 0x" + Integer.toHexString(ecOptions));
        }
        SynWTFilter[] hfilters = new SynWTFilter[1];
        SynWTFilter[] vfilters = new SynWTFilter[1];
        hfilters[0] = this.readFilter(ehs, ms.spcoc_t);
        vfilters[0] = hfilters[0];
        SynWTFilter[][] hvfilters = new SynWTFilter[][]{hfilters, vfilters};
        Vector[] v = new Vector[]{new Vector(), new Vector()};
        int val = 65535;
        if (!this.precinctPartitionIsUsed) {
            Integer w = new Integer(1 << (val & 0xF));
            v[0].addElement(w);
            Integer h = new Integer(1 << ((val & 0xF0) >> 4));
            v[1].addElement(h);
        } else {
            ms.spcoc_ps = new int[mrl + 1];
            int rl = mrl;
            while (rl >= 0) {
                val = ms.spcoc_ps[rl] = ehs.readUnsignedByte();
                Integer w = new Integer(1 << (val & 0xF));
                v[0].insertElementAt(w, 0);
                Integer h = new Integer(1 << ((val & 0xF0) >> 4));
                v[1].insertElementAt(h, 0);
                --rl;
            }
        }
        if (mainh) {
            this.decSpec.pss.setCompDef(cComp, v);
        } else {
            this.decSpec.pss.setTileCompVal(tileIdx, cComp, v);
        }
        this.precinctPartitionIsUsed = true;
        this.checkMarkerLength(ehs, "COD marker");
        if (mainh) {
            this.hi.coc.put("main_c" + cComp, ms);
            this.decSpec.wfs.setCompDef(cComp, hvfilters);
            this.decSpec.dls.setCompDef(cComp, new Integer(mrl));
            this.decSpec.ecopts.setCompDef(cComp, new Integer(ecOptions));
        } else {
            this.hi.coc.put("t" + tileIdx + "_c" + cComp, ms);
            this.decSpec.wfs.setTileCompVal(tileIdx, cComp, hvfilters);
            this.decSpec.dls.setTileCompVal(tileIdx, cComp, new Integer(mrl));
            this.decSpec.ecopts.setTileCompVal(tileIdx, cComp, new Integer(ecOptions));
        }
    }

    private void readPOC(DataInputStream ehs, boolean mainh, int t, int tpIdx) throws IOException {
        int[][] change;
        HeaderInfo.POC ms;
        boolean useShort = this.nComp >= 256;
        int nOldChg = 0;
        if (mainh || this.hi.poc.get("t" + t) == null) {
            ms = this.hi.getNewPOC();
        } else {
            ms = (HeaderInfo.POC)this.hi.poc.get("t" + t);
            nOldChg = ms.rspoc.length;
        }
        ms.lpoc = ehs.readUnsignedShort();
        int newChg = (ms.lpoc - 2) / (5 + (useShort ? 4 : 2));
        int ntotChg = nOldChg + newChg;
        if (nOldChg != 0) {
            change = new int[ntotChg][6];
            int[] tmprspoc = new int[ntotChg];
            int[] tmpcspoc = new int[ntotChg];
            int[] tmplyepoc = new int[ntotChg];
            int[] tmprepoc = new int[ntotChg];
            int[] tmpcepoc = new int[ntotChg];
            int[] tmpppoc = new int[ntotChg];
            int[][] prevChg = (int[][])this.decSpec.pcs.getTileDef(t);
            int chg = 0;
            while (chg < nOldChg) {
                change[chg] = prevChg[chg];
                tmprspoc[chg] = ms.rspoc[chg];
                tmpcspoc[chg] = ms.cspoc[chg];
                tmplyepoc[chg] = ms.lyepoc[chg];
                tmprepoc[chg] = ms.repoc[chg];
                tmpcepoc[chg] = ms.cepoc[chg];
                tmpppoc[chg] = ms.ppoc[chg];
                ++chg;
            }
            ms.rspoc = tmprspoc;
            ms.cspoc = tmpcspoc;
            ms.lyepoc = tmplyepoc;
            ms.repoc = tmprepoc;
            ms.cepoc = tmpcepoc;
            ms.ppoc = tmpppoc;
        } else {
            change = new int[newChg][6];
            ms.rspoc = new int[newChg];
            ms.cspoc = new int[newChg];
            ms.lyepoc = new int[newChg];
            ms.repoc = new int[newChg];
            ms.cepoc = new int[newChg];
            ms.ppoc = new int[newChg];
        }
        int chg = nOldChg;
        while (chg < ntotChg) {
            int tmp;
            change[chg][0] = ms.rspoc[chg] = ehs.readUnsignedByte();
            change[chg][1] = useShort ? (ms.cspoc[chg] = ehs.readUnsignedShort()) : (ms.cspoc[chg] = ehs.readUnsignedByte());
            change[chg][2] = ms.lyepoc[chg] = ehs.readUnsignedShort();
            if (change[chg][2] < 1) {
                throw new CorruptedCodestreamException("LYEpoc value must be greater than 1 in POC marker segment of tile " + t + ", tile-part " + tpIdx);
            }
            change[chg][3] = ms.repoc[chg] = ehs.readUnsignedByte();
            if (change[chg][3] <= change[chg][0]) {
                throw new CorruptedCodestreamException("REpoc value must be greater than RSpoc in POC marker segment of tile " + t + ", tile-part " + tpIdx);
            }
            change[chg][4] = useShort ? (ms.cepoc[chg] = ehs.readUnsignedShort()) : ((tmp = (ms.cepoc[chg] = ehs.readUnsignedByte())) == 0 ? 0 : tmp);
            if (change[chg][4] <= change[chg][1]) {
                throw new CorruptedCodestreamException("CEpoc value must be greater than CSpoc in POC marker segment of tile " + t + ", tile-part " + tpIdx);
            }
            change[chg][5] = ms.ppoc[chg] = ehs.readUnsignedByte();
            ++chg;
        }
        this.checkMarkerLength(ehs, "POC marker");
        if (mainh) {
            this.hi.poc.put("main", ms);
            this.decSpec.pcs.setDefault(change);
        } else {
            this.hi.poc.put("t" + t, ms);
            this.decSpec.pcs.setTileDef(t, change);
        }
    }

    private void readTLM(DataInputStream ehs) throws IOException {
        int length = ehs.readUnsignedShort();
        ehs.skipBytes(length - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported TLM marker");
    }

    private void readPLM(DataInputStream ehs) throws IOException {
        int length = ehs.readUnsignedShort();
        ehs.skipBytes(length - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported PLM marker");
    }

    private void readPLTFields(DataInputStream ehs) throws IOException {
        int length = ehs.readUnsignedShort();
        ehs.skipBytes(length - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported PLT marker");
    }

    private void readRGN(DataInputStream ehs, boolean mainh, int tileIdx, int tpIdx) throws IOException {
        HeaderInfo.RGN ms = this.hi.getNewRGN();
        ms.lrgn = ehs.readUnsignedShort();
        int comp = this.nComp < 257 ? ehs.readUnsignedByte() : ehs.readUnsignedShort();
        ms.crgn = comp;
        if (comp >= this.nComp) {
            throw new CorruptedCodestreamException("Invalid component index in RGN marker" + comp);
        }
        ms.srgn = ehs.readUnsignedByte();
        if (ms.srgn != 0) {
            throw new CorruptedCodestreamException("Unknown or unsupported Srgn parameter in ROI marker");
        }
        if (this.decSpec.rois == null) {
            this.decSpec.rois = new MaxShiftSpec(this.nTiles, this.nComp, 2);
        }
        ms.sprgn = ehs.readUnsignedByte();
        if (mainh) {
            this.hi.rgn.put("main_c" + comp, ms);
            this.decSpec.rois.setCompDef(comp, new Integer(ms.sprgn));
        } else {
            this.hi.rgn.put("t" + tileIdx + "_c" + comp, ms);
            this.decSpec.rois.setTileCompVal(tileIdx, comp, new Integer(ms.sprgn));
        }
        this.checkMarkerLength(ehs, "RGN marker");
    }

    private void readPPM(DataInputStream ehs) throws IOException {
        if (this.pPMMarkerData == null) {
            this.pPMMarkerData = new byte[this.nPPMMarkSeg][];
            this.tileOfTileParts = new Vector();
            this.decSpec.pphs.setDefault(new Boolean(true));
        }
        int curMarkSegLen = ehs.readUnsignedShort();
        int remSegLen = curMarkSegLen - 3;
        int indx = ehs.readUnsignedByte();
        this.pPMMarkerData[indx] = new byte[remSegLen];
        ehs.read(this.pPMMarkerData[indx], 0, remSegLen);
        this.checkMarkerLength(ehs, "PPM marker");
    }

    private void readPPT(DataInputStream ehs, int tile, int tpIdx) throws IOException {
        boolean len = false;
        if (this.tilePartPkdPktHeaders == null) {
            this.tilePartPkdPktHeaders = new byte[this.nTiles][][][];
        }
        if (this.tilePartPkdPktHeaders[tile] == null) {
            this.tilePartPkdPktHeaders[tile] = new byte[this.nTileParts[tile]][][];
        }
        if (this.tilePartPkdPktHeaders[tile][tpIdx] == null) {
            this.tilePartPkdPktHeaders[tile][tpIdx] = new byte[this.nPPTMarkSeg[tile][tpIdx]][];
        }
        int curMarkSegLen = ehs.readUnsignedShort();
        int indx = ehs.readUnsignedByte();
        byte[] temp = new byte[curMarkSegLen - 3];
        ehs.read(temp);
        this.tilePartPkdPktHeaders[tile][tpIdx][indx] = temp;
        this.checkMarkerLength(ehs, "PPT marker");
        this.decSpec.pphs.setTileDef(tile, new Boolean(true));
    }

    private void extractMainMarkSeg(short marker, RandomAccessIO ehs) throws IOException {
        if (this.nfMarkSeg == 0 && marker != -175) {
            throw new CorruptedCodestreamException("First marker after SOC must be SIZ " + Integer.toHexString(marker));
        }
        String htKey = "";
        if (this.ht == null) {
            this.ht = new Hashtable();
        }
        switch (marker) {
            case -175: {
                if ((this.nfMarkSeg & 1) != 0) {
                    throw new CorruptedCodestreamException("More than one SIZ marker segment found in main header");
                }
                this.nfMarkSeg |= 1;
                htKey = "SIZ";
                break;
            }
            case -109: {
                throw new CorruptedCodestreamException("SOD found in main header");
            }
            case -39: {
                throw new CorruptedCodestreamException("EOC found in main header");
            }
            case -112: {
                if ((this.nfMarkSeg & 0x40) != 0) {
                    throw new CorruptedCodestreamException("More than one SOT marker found right after main or tile header");
                }
                this.nfMarkSeg |= 0x40;
                return;
            }
            case -174: {
                if ((this.nfMarkSeg & 2) != 0) {
                    throw new CorruptedCodestreamException("More than one COD marker found in main header");
                }
                this.nfMarkSeg |= 2;
                htKey = "COD";
                break;
            }
            case -173: {
                this.nfMarkSeg |= 4;
                htKey = "COC" + this.nCOCMarkSeg++;
                break;
            }
            case -164: {
                if ((this.nfMarkSeg & 8) != 0) {
                    throw new CorruptedCodestreamException("More than one QCD marker found in main header");
                }
                this.nfMarkSeg |= 8;
                htKey = "QCD";
                break;
            }
            case -163: {
                this.nfMarkSeg |= 0x100;
                htKey = "QCC" + this.nQCCMarkSeg++;
                break;
            }
            case -162: {
                this.nfMarkSeg |= 0x200;
                htKey = "RGN" + this.nRGNMarkSeg++;
                break;
            }
            case -156: {
                this.nfMarkSeg |= 0x800;
                htKey = "COM" + this.nCOMMarkSeg++;
                break;
            }
            case -157: {
                if ((this.nfMarkSeg & 0x10000) != 0) {
                    throw new CorruptedCodestreamException("More than one CRG marker found in main header");
                }
                this.nfMarkSeg |= 0x10000;
                htKey = "CRG";
                break;
            }
            case -160: {
                this.nfMarkSeg |= 0x4000;
                htKey = "PPM" + this.nPPMMarkSeg++;
                break;
            }
            case -171: {
                if ((this.nfMarkSeg & 0x10) != 0) {
                    throw new CorruptedCodestreamException("More than one TLM marker found in main header");
                }
                this.nfMarkSeg |= 0x10;
                break;
            }
            case -169: {
                if ((this.nfMarkSeg & 0x20) != 0) {
                    throw new CorruptedCodestreamException("More than one PLM marker found in main header");
                }
                FacilityManager.getMsgLogger().printmsg(2, "PLM marker segment found but not used by by JJ2000 decoder.");
                this.nfMarkSeg |= 0x20;
                htKey = "PLM";
                break;
            }
            case -161: {
                if ((this.nfMarkSeg & 0x400) != 0) {
                    throw new CorruptedCodestreamException("More than one POC marker segment found in main header");
                }
                this.nfMarkSeg |= 0x400;
                htKey = "POC";
                break;
            }
            case -168: {
                throw new CorruptedCodestreamException("PLT found in main header");
            }
            case -159: {
                throw new CorruptedCodestreamException("PPT found in main header");
            }
            default: {
                htKey = "UNKNOWN";
                FacilityManager.getMsgLogger().printmsg(2, "Non recognized marker segment (0x" + Integer.toHexString(marker) + ") in main header!");
            }
        }
        if (marker < -208 || marker > -193) {
            int markSegLen = ehs.readUnsignedShort();
            byte[] buf = new byte[markSegLen];
            buf[0] = (byte)(markSegLen >> 8 & 0xFF);
            buf[1] = (byte)(markSegLen & 0xFF);
            ehs.readFully(buf, 2, markSegLen - 2);
            if (!htKey.equals("UNKNOWN")) {
                this.ht.put(htKey, buf);
            }
        }
    }

    public void extractTilePartMarkSeg(short marker, RandomAccessIO ehs, int tileIdx, int tilePartIdx) throws IOException {
        String htKey = "";
        if (this.ht == null) {
            this.ht = new Hashtable();
        }
        switch (marker) {
            case -112: {
                throw new CorruptedCodestreamException("Second SOT marker segment found in tile-part header");
            }
            case -175: {
                throw new CorruptedCodestreamException("SIZ found in tile-part header");
            }
            case -39: {
                throw new CorruptedCodestreamException("EOC found in tile-part header");
            }
            case -171: {
                throw new CorruptedCodestreamException("TLM found in tile-part header");
            }
            case -169: {
                throw new CorruptedCodestreamException("PLM found in tile-part header");
            }
            case -160: {
                throw new CorruptedCodestreamException("PPM found in tile-part header");
            }
            case -174: {
                if ((this.nfMarkSeg & 2) != 0) {
                    throw new CorruptedCodestreamException("More than one COD marker found in tile-part header");
                }
                this.nfMarkSeg |= 2;
                htKey = "COD";
                break;
            }
            case -173: {
                this.nfMarkSeg |= 4;
                htKey = "COC" + this.nCOCMarkSeg++;
                break;
            }
            case -164: {
                if ((this.nfMarkSeg & 8) != 0) {
                    throw new CorruptedCodestreamException("More than one QCD marker found in tile-part header");
                }
                this.nfMarkSeg |= 8;
                htKey = "QCD";
                break;
            }
            case -163: {
                this.nfMarkSeg |= 0x100;
                htKey = "QCC" + this.nQCCMarkSeg++;
                break;
            }
            case -162: {
                this.nfMarkSeg |= 0x200;
                htKey = "RGN" + this.nRGNMarkSeg++;
                break;
            }
            case -156: {
                this.nfMarkSeg |= 0x800;
                htKey = "COM" + this.nCOMMarkSeg++;
                break;
            }
            case -157: {
                throw new CorruptedCodestreamException("CRG marker found in tile-part header");
            }
            case -159: {
                this.nfMarkSeg |= 0x8000;
                if (this.nPPTMarkSeg == null) {
                    this.nPPTMarkSeg = new int[this.nTiles][];
                }
                if (this.nPPTMarkSeg[tileIdx] == null) {
                    this.nPPTMarkSeg[tileIdx] = new int[this.nTileParts[tileIdx]];
                }
                int[] nArray = this.nPPTMarkSeg[tileIdx];
                int n = tilePartIdx;
                int n2 = nArray[n];
                nArray[n] = n2 + 1;
                htKey = "PPT" + n2;
                break;
            }
            case -109: {
                this.nfMarkSeg |= 0x2000;
                return;
            }
            case -161: {
                if ((this.nfMarkSeg & 0x400) != 0) {
                    throw new CorruptedCodestreamException("More than one POC marker segment found in tile-part header");
                }
                this.nfMarkSeg |= 0x400;
                htKey = "POC";
                break;
            }
            case -168: {
                if ((this.nfMarkSeg & 0x20) != 0) {
                    throw new CorruptedCodestreamException("PLT marker found eventhough PLM marker found in main header");
                }
                FacilityManager.getMsgLogger().printmsg(2, "PLT marker segment found but not used by JJ2000 decoder.");
                htKey = "UNKNOWN";
                break;
            }
            default: {
                htKey = "UNKNOWN";
                FacilityManager.getMsgLogger().printmsg(2, "Non recognized marker segment (0x" + Integer.toHexString(marker) + ") in tile-part header" + " of tile " + tileIdx + " !");
            }
        }
        int markSegLen = ehs.readUnsignedShort();
        byte[] buf = new byte[markSegLen];
        buf[0] = (byte)(markSegLen >> 8 & 0xFF);
        buf[1] = (byte)(markSegLen & 0xFF);
        ehs.readFully(buf, 2, markSegLen - 2);
        if (!htKey.equals("UNKNOWN")) {
            this.ht.put(htKey, buf);
        }
    }

    private void readFoundMainMarkSeg() throws IOException {
        int i;
        ByteArrayInputStream bais;
        if ((this.nfMarkSeg & 1) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("SIZ"));
            this.readSIZ(new DataInputStream(bais));
        }
        if ((this.nfMarkSeg & 0x800) != 0) {
            i = 0;
            while (i < this.nCOMMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("COM" + i));
                this.readCOM(new DataInputStream(bais), true, 0, i);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 0x10000) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("CRG"));
            this.readCRG(new DataInputStream(bais));
        }
        if ((this.nfMarkSeg & 2) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("COD"));
            this.readCOD(new DataInputStream(bais), true, 0, 0);
        }
        if ((this.nfMarkSeg & 4) != 0) {
            i = 0;
            while (i < this.nCOCMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("COC" + i));
                this.readCOC(new DataInputStream(bais), true, 0, 0);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 0x200) != 0) {
            i = 0;
            while (i < this.nRGNMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("RGN" + i));
                this.readRGN(new DataInputStream(bais), true, 0, 0);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 8) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("QCD"));
            this.readQCD(new DataInputStream(bais), true, 0, 0);
        }
        if ((this.nfMarkSeg & 0x100) != 0) {
            i = 0;
            while (i < this.nQCCMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("QCC" + i));
                this.readQCC(new DataInputStream(bais), true, 0, 0);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 0x400) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("POC"));
            this.readPOC(new DataInputStream(bais), true, 0, 0);
        }
        if ((this.nfMarkSeg & 0x4000) != 0) {
            i = 0;
            while (i < this.nPPMMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("PPM" + i));
                this.readPPM(new DataInputStream(bais));
                ++i;
            }
        }
        this.ht = null;
    }

    public void readFoundTilePartMarkSeg(int tileIdx, int tpIdx) throws IOException {
        int i;
        ByteArrayInputStream bais;
        if ((this.nfMarkSeg & 2) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("COD"));
            this.readCOD(new DataInputStream(bais), false, tileIdx, tpIdx);
        }
        if ((this.nfMarkSeg & 4) != 0) {
            i = 0;
            while (i < this.nCOCMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("COC" + i));
                this.readCOC(new DataInputStream(bais), false, tileIdx, tpIdx);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 0x200) != 0) {
            i = 0;
            while (i < this.nRGNMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("RGN" + i));
                this.readRGN(new DataInputStream(bais), false, tileIdx, tpIdx);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 8) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("QCD"));
            this.readQCD(new DataInputStream(bais), false, tileIdx, tpIdx);
        }
        if ((this.nfMarkSeg & 0x100) != 0) {
            i = 0;
            while (i < this.nQCCMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("QCC" + i));
                this.readQCC(new DataInputStream(bais), false, tileIdx, tpIdx);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 0x400) != 0) {
            bais = new ByteArrayInputStream((byte[])this.ht.get("POC"));
            this.readPOC(new DataInputStream(bais), false, tileIdx, tpIdx);
        }
        if ((this.nfMarkSeg & 0x800) != 0) {
            i = 0;
            while (i < this.nCOMMarkSeg) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("COM" + i));
                this.readCOM(new DataInputStream(bais), false, tileIdx, i);
                ++i;
            }
        }
        if ((this.nfMarkSeg & 0x8000) != 0) {
            i = 0;
            while (i < this.nPPTMarkSeg[tileIdx][tpIdx]) {
                bais = new ByteArrayInputStream((byte[])this.ht.get("PPT" + i));
                this.readPPT(new DataInputStream(bais), tileIdx, tpIdx);
                ++i;
            }
        }
        this.ht = null;
    }

    public DecoderSpecs getDecoderSpecs() {
        return this.decSpec;
    }

    public HeaderDecoder(RandomAccessIO ehs, ParameterList pl, HeaderInfo hi) throws IOException {
        this.hi = hi;
        this.verbose = this.verbose;
        pl.checkList('H', ParameterList.toNameArray(pinfo));
        this.mainHeadOff = ehs.getPos();
        if (ehs.readShort() != -177) {
            throw new CorruptedCodestreamException("SOC marker segment not  found at the beginning of the codestream.");
        }
        this.nfMarkSeg = 0;
        do {
            this.extractMainMarkSeg(ehs.readShort(), ehs);
        } while ((this.nfMarkSeg & 0x40) == 0);
        ehs.seek(ehs.getPos() - 2);
        this.readFoundMainMarkSeg();
    }

    public EntropyDecoder createEntropyDecoder(CodedCBlkDataSrcDec src, ParameterList pl) {
        pl.checkList('C', ParameterList.toNameArray(EntropyDecoder.getParameterInfo()));
        boolean doer = pl.getBooleanParameter("Cer");
        boolean verber = pl.getBooleanParameter("Cverber");
        int mMax = pl.getIntParameter("m_quit");
        return new StdEntropyDecoder(src, this.decSpec, doer, verber, mMax);
    }

    public BlkImgDataSrc createColorSpaceMapper(BlkImgDataSrc src, ColorSpace csMap) throws IOException, ICCProfileException, ColorSpaceException {
        return ColorSpaceMapper.createInstance(src, csMap);
    }

    public BlkImgDataSrc createChannelDefinitionMapper(BlkImgDataSrc src, ColorSpace csMap) throws IOException, ColorSpaceException {
        return ChannelDefinitionMapper.createInstance(src, csMap);
    }

    public BlkImgDataSrc createPalettizedColorSpaceMapper(BlkImgDataSrc src, ColorSpace csMap) throws IOException, ColorSpaceException {
        return PalettizedColorSpaceMapper.createInstance(src, csMap);
    }

    public BlkImgDataSrc createResampler(BlkImgDataSrc src, ColorSpace csMap) throws IOException, ColorSpaceException {
        return Resampler.createInstance(src, csMap);
    }

    public ROIDeScaler createROIDeScaler(CBlkQuantDataSrcDec src, ParameterList pl, DecoderSpecs decSpec2) {
        return ROIDeScaler.createInstance(src, pl, decSpec2);
    }

    public void resetHeaderMarkers() {
        this.nfMarkSeg &= 0x4020;
        this.nCOCMarkSeg = 0;
        this.nQCCMarkSeg = 0;
        this.nCOMMarkSeg = 0;
        this.nRGNMarkSeg = 0;
    }

    public String toString() {
        return this.hdStr;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public int getNumTiles() {
        return this.nTiles;
    }

    public ByteArrayInputStream getPackedPktHead(int tile) throws IOException {
        block8: {
            if (this.pkdPktHeaders != null) break block8;
            this.pkdPktHeaders = new ByteArrayOutputStream[this.nTiles];
            int i = this.nTiles - 1;
            while (i >= 0) {
                this.pkdPktHeaders[i] = new ByteArrayOutputStream();
                --i;
            }
            if (this.nPPMMarkSeg != 0) {
                int nTileParts = this.tileOfTileParts.size();
                ByteArrayOutputStream allNppmIppm = new ByteArrayOutputStream();
                i = 0;
                while (i < this.nPPMMarkSeg) {
                    allNppmIppm.write(this.pPMMarkerData[i]);
                    ++i;
                }
                ByteArrayInputStream pph = new ByteArrayInputStream(allNppmIppm.toByteArray());
                i = 0;
                while (i < nTileParts) {
                    int t = (Integer)this.tileOfTileParts.elementAt(i);
                    int nppm = pph.read() << 24 | pph.read() << 16 | pph.read() << 8 | pph.read();
                    byte[] temp = new byte[nppm];
                    pph.read(temp);
                    this.pkdPktHeaders[t].write(temp);
                    ++i;
                }
            } else {
                int t = this.nTiles - 1;
                while (t >= 0) {
                    int tp = 0;
                    while (tp < this.nTileParts[t]) {
                        i = 0;
                        while (i < this.nPPTMarkSeg[t][tp]) {
                            this.pkdPktHeaders[t].write(this.tilePartPkdPktHeaders[t][tp][i]);
                            ++i;
                        }
                        ++tp;
                    }
                    --t;
                }
            }
        }
        return new ByteArrayInputStream(this.pkdPktHeaders[tile].toByteArray());
    }

    public void setTileOfTileParts(int tile) {
        if (this.nPPMMarkSeg != 0) {
            this.tileOfTileParts.addElement(new Integer(tile));
        }
    }

    public int getNumFoundMarkSeg() {
        return this.nfMarkSeg;
    }
}

