/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.analysis.AnWTFilterIntLift5x3;

public class AnWTFilterSpec
extends ModuleSpec {
    private static final String REV_FILTER_STR = "w5x3";
    private static final String NON_REV_FILTER_STR = "w9x7";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnWTFilterSpec(int nt, int nc, byte type, QuantTypeSpec qts, ParameterList pl) {
        super(nt, nc, type);
        int c;
        pl.checkList('F', ParameterList.toNameArray(AnWTFilter.getParameterInfo()));
        String param = pl.getParameter("Ffilters");
        boolean isFilterSpecified = true;
        if (param == null) {
            isFilterSpecified = false;
            if (pl.getBooleanParameter("lossless")) {
                this.setDefault(this.parseFilters(REV_FILTER_STR));
                return;
            }
            int t = nt - 1;
            while (t >= 0) {
                int c2 = nc - 1;
                while (c2 >= 0) {
                    switch (qts.getSpecValType(t, c2)) {
                        case 0: {
                            if (this.getDefault() == null) {
                                if (pl.getBooleanParameter("lossless")) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                }
                                if (((String)qts.getDefault()).equals("reversible")) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t][c2] = 0;
                            break;
                        }
                        case 1: {
                            if (!this.isCompSpecified(c2)) {
                                if (((String)qts.getCompDef(c2)).equals("reversible")) {
                                    this.setCompDef(c2, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setCompDef(c2, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t][c2] = 1;
                            break;
                        }
                        case 2: {
                            if (!this.isTileSpecified(t)) {
                                if (((String)qts.getTileDef(t)).equals("reversible")) {
                                    this.setTileDef(t, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileDef(t, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t][c2] = 2;
                            break;
                        }
                        case 3: {
                            if (!this.isTileCompSpecified(t, c2)) {
                                if (((String)qts.getTileCompVal(t, c2)).equals("reversible")) {
                                    this.setTileCompVal(t, c2, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileCompVal(t, c2, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t][c2] = 3;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported specification type");
                        }
                    }
                    --c2;
                }
                --t;
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 'T': 
                case 't': {
                    tileSpec = AnWTFilterSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 2;
                    break;
                }
                case 'C': 
                case 'c': {
                    compSpec = AnWTFilterSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        break;
                    }
                    curSpecType = 1;
                    break;
                }
                case 'W': 
                case 'w': {
                    int i;
                    if (pl.getBooleanParameter("lossless") && word.equalsIgnoreCase(NON_REV_FILTER_STR)) {
                        throw new IllegalArgumentException("Cannot use non reversible wavelet transform with '-lossless' option");
                    }
                    AnWTFilter[][] filter = this.parseFilters(word);
                    if (curSpecType == 0) {
                        this.setDefault(filter);
                    } else if (curSpecType == 2) {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            if (tileSpec[i]) {
                                this.setTileDef(i, filter);
                            }
                            --i;
                        }
                    } else if (curSpecType == 1) {
                        i = compSpec.length - 1;
                        while (i >= 0) {
                            if (compSpec[i]) {
                                this.setCompDef(i, filter);
                            }
                            --i;
                        }
                    } else {
                        i = tileSpec.length - 1;
                        while (i >= 0) {
                            int j = compSpec.length - 1;
                            while (j >= 0) {
                                if (tileSpec[i] && compSpec[j]) {
                                    this.setTileCompVal(i, j, filter);
                                }
                                --j;
                            }
                            --i;
                        }
                    }
                    curSpecType = 0;
                    tileSpec = null;
                    compSpec = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad construction for parameter: " + word);
                }
            }
        }
        if (this.getDefault() == null) {
            int ndefspec = 0;
            int t = nt - 1;
            while (t >= 0) {
                int c3 = nc - 1;
                while (c3 >= 0) {
                    if (this.specValType[t][c3] == 0) {
                        ++ndefspec;
                    }
                    --c3;
                }
                --t;
            }
            if (ndefspec != 0) {
                if (((String)qts.getDefault()).equals("reversible")) {
                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                } else {
                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        c = nc - 1;
                        while (c >= 0) {
                            if (this.specValType[0][c] == 2) {
                                this.specValType[0][c] = 0;
                            }
                            --c;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        t = nt - 1;
                        while (t >= 0) {
                            if (this.specValType[t][0] == 1) {
                                this.specValType[t][0] = 0;
                            }
                            --t;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
        int t = nt - 1;
        while (t >= 0) {
            c = nc - 1;
            while (c >= 0) {
                if (((String)qts.getTileCompVal(t, c)).equals("reversible")) {
                    if (!this.isReversible(t, c)) {
                        if (isFilterSpecified) throw new IllegalArgumentException("Filter of tile-component (" + t + "," + c + ") does" + " not allow " + "reversible " + "quantization. " + "Specify '-Qtype " + "expounded' or " + "'-Qtype derived'" + "in " + "the command line.");
                        this.setTileCompVal(t, c, this.parseFilters(REV_FILTER_STR));
                    }
                } else if (this.isReversible(t, c)) {
                    if (isFilterSpecified) throw new IllegalArgumentException("Filter of tile-component (" + t + "," + c + ") does" + " not allow " + "non-reversible " + "quantization. " + "Specify '-Qtype " + "reversible' in " + "the command line");
                    this.setTileCompVal(t, c, this.parseFilters(NON_REV_FILTER_STR));
                }
                --c;
            }
            --t;
        }
    }

    private AnWTFilter[][] parseFilters(String word) {
        AnWTFilter[][] filt = new AnWTFilter[2][1];
        if (word.equalsIgnoreCase(REV_FILTER_STR)) {
            filt[0][0] = new AnWTFilterIntLift5x3();
            filt[1][0] = new AnWTFilterIntLift5x3();
            return filt;
        }
        if (word.equalsIgnoreCase(NON_REV_FILTER_STR)) {
            filt[0][0] = new AnWTFilterFloatLift9x7();
            filt[1][0] = new AnWTFilterFloatLift9x7();
            return filt;
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I filter: " + word);
    }

    public int getWTDataType(int t, int c) {
        AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t, c);
        return an[0][0].getDataType();
    }

    public AnWTFilter[] getHFilters(int t, int c) {
        AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t, c);
        return an[0];
    }

    public AnWTFilter[] getVFilters(int t, int c) {
        AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t, c);
        return an[1];
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + "nTiles=" + this.nTiles + "\nnComp=" + this.nComp + "\n\n";
        int t = 0;
        while (t < this.nTiles) {
            int c = 0;
            while (c < this.nComp) {
                AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t, c);
                str = String.valueOf(str) + "(t:" + t + ",c:" + c + ")\n";
                str = String.valueOf(str) + "\tH:";
                int i = 0;
                while (i < an[0].length) {
                    str = String.valueOf(str) + " " + an[0][i];
                    ++i;
                }
                str = String.valueOf(str) + "\n\tV:";
                i = 0;
                while (i < an[1].length) {
                    str = String.valueOf(str) + " " + an[1][i];
                    ++i;
                }
                str = String.valueOf(str) + "\n";
                ++c;
            }
            ++t;
        }
        return str;
    }

    public boolean isReversible(int t, int c) {
        AnWTFilter[] hfilter = this.getHFilters(t, c);
        AnWTFilter[] vfilter = this.getVFilters(t, c);
        int i = hfilter.length - 1;
        while (i >= 0) {
            if (!hfilter[i].isReversible() || !vfilter[i].isReversible()) {
                return false;
            }
            --i;
        }
        return true;
    }
}

