/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.polhemus;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public abstract class SerialPortDevice {
    public static final int SERIALPORT1 = 0;
    public static final int SERIALPORT2 = 1;
    public static final int SERIALPORT3 = 2;
    public static final int SERIALPORT4 = 3;
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    private SerialPort mSerialPort = null;
    private OutputStream mOutputStream = null;
    private InputStream mInputStream = null;

    protected SerialPortDevice(String string, int n, int n2, int n3, int n4) {
        this.open(string, n, n2, n3, n4);
    }

    protected SerialPortDevice(int n, int n2, int n3, int n4, int n5) {
        String string = null;
        int n6 = 0;
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() == 1) {
                ++n6;
            }
            if (n >= n6) continue;
            string = commPortIdentifier.getName();
            break;
        }
        if (string != null) {
            this.open(string, n2, n3, n4, n5);
        } else {
            System.out.println("SerialPort::SerialPort : Couldn't open the serial port !!");
        }
    }

    public void close() {
        try {
            if (this.mOutputStream != null) {
                this.mOutputStream.close();
            }
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
            if (this.mSerialPort != null) {
                // empty if block
            }
            this.mSerialPort.close();
            this.mOutputStream = null;
            this.mInputStream = null;
            this.mSerialPort = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(String string) {
        if (this.mOutputStream == null) {
            return;
        }
        this.write(string.getBytes(), string.length());
    }

    public void write(byte[] byArray, int n) {
        if (this.mOutputStream == null) {
            return;
        }
        try {
            this.mOutputStream.write(byArray, 0, n);
            this.mOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String read(int n, long l) {
        if (this.mInputStream == null) {
            return null;
        }
        if (n <= 0) {
            return null;
        }
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        int n2 = 0;
        byte[] byArray = new byte[n];
        try {
            while (n2 < n && l3 < l) {
                if (0 < this.nToRead()) {
                    n2 = this.mInputStream.read(byArray);
                }
                l3 = System.currentTimeMillis() - l2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(byArray, 0, n2);
    }

    public String read(int n) {
        return this.read(n, 3000L);
    }

    public int nToRead() {
        if (this.mInputStream == null) {
            return 0;
        }
        int n = -1;
        try {
            n = this.mInputStream.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public void waitData(int n) {
        int n2 = 0;
        while (n > (n2 = this.nToRead())) {
            this.waitTime(100L);
        }
    }

    public void waitTime(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void open(String string, int n, int n2, int n3, int n4) {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
            this.mSerialPort = (SerialPort)commPortIdentifier.open("GenericSerialReader", 5000);
            this.mSerialPort.setSerialPortParams(n, n2, n3, n4);
            this.mSerialPort.setFlowControlMode(0);
            this.mSerialPort.enableReceiveThreshold(1);
            this.mSerialPort.enableReceiveTimeout(3000);
            this.mOutputStream = this.mSerialPort.getOutputStream();
            this.mInputStream = this.mSerialPort.getInputStream();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

