/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.SerialPort;
import org.j3d.device.input.spaceball.Spaceball4000CallbackInterface;
import org.j3d.device.input.spaceball.Spaceball4000Packet;
import org.j3d.device.input.spaceball.SpaceballDriver;
import org.j3d.device.input.spaceball.SpaceballPacket;

public class Spaceball4000Driver
extends SpaceballDriver
implements Spaceball4000CallbackInterface {
    public Spaceball4000Driver(SerialPort serialPort, InputStream inputStream, OutputStream outputStream) throws IOException {
        super(serialPort, inputStream, outputStream, 13);
        this.getDeviceDescriptor(1000);
    }

    protected void dispatch(byte[] byArray, int n, int n2, int n3) {
        if (n3 == 68) {
            if (n2 == 15) {
                Spaceball4000Packet.decodeBallData(byArray, this.itsPositionData, n);
            }
        } else if (n3 == 46) {
            if (n2 == 3) {
                Spaceball4000Packet.decodeButtonEvent(this.itsButtonData, byArray, this, n);
            }
        } else if (n3 != 75) {
            Spaceball4000Packet.doCallBacks(byArray, this, n + 1, n2 - 1, n3);
        }
    }

    public void enableDevice(int n) throws IOException {
        int n2 = Spaceball4000Packet.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)77);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 77, "enable device");
    }

    public void disableDevice(int n) throws IOException {
        int n2 = Spaceball4000Packet.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)45);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 45, "disable device");
    }

    public void emitSingleBeep(int n) throws IOException {
        this.emitSingleBeep();
        this.waitForResponse(n, 83, "emit single beep");
    }

    public void emitSingleBeep() throws IOException {
        int n = Spaceball4000Packet.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)83);
        this.write(this.itsWriteBuffer, 0, n);
    }

    public void rezeroDevice(int n) throws IOException {
        int n2 = SpaceballPacket.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)90);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 90, "rezero device");
    }

    public void enableAutoRezero(int n, boolean bl) throws IOException {
        int n2 = Spaceball4000Packet.createEnableDisableAutoRezeroPacket(this.itsWriteBuffer, 0, bl);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 97, "enable/disable auto rezero");
    }

    public void enableCubicSensitivity(int n, boolean bl) throws IOException {
        int n2 = Spaceball4000Packet.createCubicSensitivityEnableDisablePacket(this.itsWriteBuffer, 0, bl);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 89, "enable/disable cubic sensitivity");
    }

    public void getDeviceDescriptor(int n) throws IOException {
        int n2 = Spaceball4000Packet.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)34);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 34, "get device descriptor");
    }

    public void getDeviceInfo(int n) throws IOException {
        int n2 = Spaceball4000Packet.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)104);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 72, "get device info");
    }

    public void processDeviceInfoResponse(int n, int n2, String string) {
        if (n == 34) {
            if (n2 == 4) {
                this.processRequestResponse(n);
            }
            System.out.println(string);
        } else {
            super.processDeviceInfoResponse(n, n2, string);
        }
    }

    public void processSensitivityResponse(byte by) {
        this.processRequestResponse(89);
    }

    public void processAutoRezeroResponse(int n, int n2, boolean bl) {
        this.processRequestResponse(97);
    }

    public void setHandedness(int n) {
    }

    public void setNumOfButtons(int n) {
        super.setNumOfButtons(n - 1);
    }
}

