/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.j3d.device.input.spaceball.Spaceball3003Driver;
import org.j3d.device.input.spaceball.Spaceball4000Driver;
import org.j3d.device.input.spaceball.SpaceballDriver;
import org.j3d.device.input.spaceball.SpaceballPacket;

public class SpaceballTypeDetector {
    private static final int TYPECHECK_BUFFER_SIZE_IN_BYTE = 150;

    public static SpaceballDriver createSpaceballDriver(String string, int n) throws NoSuchPortException, PortInUseException, IOException, UnsupportedCommOperationException {
        SerialPort serialPort = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        SpaceballDriver spaceballDriver = null;
        try {
            serialPort = SpaceballDriver.openPort(string);
            inputStream = serialPort.getInputStream();
            outputStream = serialPort.getOutputStream();
            SpaceballDriver.pause(2000);
            spaceballDriver = SpaceballTypeDetector.detectType(string, serialPort, inputStream, outputStream);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            if (serialPort != null) {
                serialPort.close();
            }
            throw unsupportedCommOperationException;
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (serialPort != null) {
                serialPort.close();
            }
            throw iOException;
        }
        return spaceballDriver;
    }

    private static SpaceballDriver detectType(String string, SerialPort serialPort, InputStream inputStream, OutputStream outputStream) throws IOException {
        SpaceballDriver spaceballDriver;
        byte[] byArray = new byte[2];
        SpaceballPacket.createSimpleRequestPacket(byArray, 0, (byte)34);
        outputStream.write(byArray);
        SpaceballDriver.pause(500);
        byte[] byArray2 = new byte[150];
        int n = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 1000L;
        while (n < 150 && l < l2) {
            if (inputStream.available() > 0) {
                n += inputStream.read(byArray2, n, 150 - n);
            }
            l = System.currentTimeMillis();
        }
        String string2 = new String(byArray2, 0, 150);
        while (inputStream.available() > 0) {
            inputStream.read(byArray2);
        }
        if (string2.indexOf("Spaceball") != -1) {
            spaceballDriver = string2.indexOf("4000 FLX") != -1 ? new Spaceball4000Driver(serialPort, inputStream, outputStream) : new Spaceball3003Driver(serialPort, inputStream, outputStream);
        } else {
            throw new IOException("Cannot detect supported Spaceball device on port " + string);
        }
        return spaceballDriver;
    }
}

