/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.j3d.geom.CharacterData;
import org.j3d.geom.TriangulationUtils;
import org.j3d.util.CharHashMap;

public class CharacterCreator {
    private static final float[] FACE_NORMAL = new float[]{0.0f, 0.0f, -1.0f};
    private final Font font;
    private final double flatness;
    private TriangulationUtils triangulator;
    private FontRenderContext fontContext;
    private CharHashMap charDataMap;
    private float[] newCoords;
    private float[] charCoords;
    private int[] charIndex;
    private int[] triOutputIndex;
    private char[] sourceChar;

    public CharacterCreator(Font font, double d) {
        this.font = font;
        this.flatness = d;
        this.fontContext = new FontRenderContext(null, true, true);
        this.charDataMap = new CharHashMap();
        this.newCoords = new float[6];
        this.charCoords = new float[1024];
        this.charIndex = new int[512];
        this.triOutputIndex = new int[512];
        this.triangulator = new TriangulationUtils();
        this.sourceChar = new char[1];
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontContext;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void createCharacterTriangles(char[] cArray, int n, ArrayList arrayList) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (this.charDataMap.containsKey(cArray[n2])) continue;
            ++n3;
        }
        if (n3 != 0) {
            n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (this.charDataMap.containsKey(cArray[n2])) continue;
                this.createNewGlyph(cArray[n2]);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            arrayList.add(this.charDataMap.get(cArray[n2]));
        }
    }

    private void createNewGlyph(char c) {
        int n;
        this.sourceChar[0] = c;
        GlyphVector glyphVector = this.font.createGlyphVector(this.fontContext, this.sourceChar);
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        double d = rectangle2D.getX() + 0.5 * rectangle2D.getWidth();
        double d2 = rectangle2D.getY() + 0.5 * rectangle2D.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(-d, -d2);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(d, -d2);
        CharacterData characterData = new CharacterData();
        Rectangle2D rectangle2D2 = glyphVector.getLogicalBounds();
        float f = 1.0f / (float)rectangle2D2.getHeight();
        characterData.bounds = new Rectangle2D.Float((float)rectangle2D2.getX() * f, (float)rectangle2D2.getY() * f, (float)rectangle2D2.getWidth() * f, 1.0f);
        characterData.scale = f;
        if (Character.isWhitespace(c)) {
            characterData.numIndex = 0;
            this.charDataMap.put(c, characterData);
            return;
        }
        Shape shape = glyphVector.getOutline();
        PathIterator pathIterator = shape.getPathIterator(affineTransform, this.flatness / (double)f);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        int n6 = 0;
        int n7 = 0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(this.newCoords)) {
                case 0: {
                    float[] fArray;
                    if (this.charCoords.length < n4 + 2) {
                        fArray = new float[n4 + 256];
                        System.arraycopy(this.charCoords, 0, fArray, 0, n4);
                        this.charCoords = fArray;
                    }
                    if (n4 == 0) {
                        this.charCoords[n4++] = this.newCoords[0] * f;
                        this.charCoords[n4++] = this.newCoords[1] * f;
                        this.charCoords[n4++] = 0.0f;
                        n2 = 1;
                        break;
                    }
                    if (n6 > n3) {
                        int n8 = n6 - n7;
                        System.arraycopy(this.charCoords, n7, this.charCoords, n4, n8);
                        System.arraycopy(this.charCoords, n6, this.charCoords, n7 + 3, n4 - n6 + n8 + 3);
                        n4 += 3;
                        ++n2;
                        n6 = n3;
                    }
                    if (this.isInsideEvenOdd(this.newCoords[0] * f, this.newCoords[1] * f, this.charCoords, n3, n2)) {
                        n6 = n4;
                        n7 = this.findClosestPoint(this.newCoords[0] * f, this.newCoords[1] * f, this.charCoords, n3, n2);
                        this.charCoords[n4++] = this.newCoords[0] * f;
                        this.charCoords[n4++] = this.newCoords[1] * f;
                        this.charCoords[n4++] = 0.0f;
                        ++n2;
                        break;
                    }
                    if (this.triOutputIndex.length < n2 * 3) {
                        this.triOutputIndex = new int[n2 * 3];
                    }
                    if ((n = this.triangulator.triangulateConcavePolygon(this.charCoords, n3, n2, this.triOutputIndex, FACE_NORMAL)) > 0) {
                        n *= 3;
                        int n9 = 0;
                        while (n9 < n) {
                            int n10 = n9++;
                            this.triOutputIndex[n10] = this.triOutputIndex[n10] / 3;
                        }
                        if (this.charIndex.length < n5 + n) {
                            int[] nArray = new int[n5 + n];
                            System.arraycopy(this.charIndex, 0, nArray, 0, n5);
                            this.charIndex = nArray;
                        }
                        System.arraycopy(this.triOutputIndex, 0, this.charIndex, n5, n);
                        n5 += n;
                    } else if (n < 0) {
                        System.out.println("can't tesselate '" + c + "'");
                    }
                    this.charCoords[n4++] = this.newCoords[0] * f;
                    this.charCoords[n4++] = this.newCoords[1] * f;
                    this.charCoords[n4++] = 0.0f;
                    n3 = n4 - 3;
                    n2 = 1;
                    break;
                }
                case 1: {
                    float[] fArray;
                    if (this.charCoords.length < n4 + 2) {
                        fArray = new float[n4 + 256];
                        System.arraycopy(this.charCoords, 0, fArray, 0, n4);
                        this.charCoords = fArray;
                    }
                    this.charCoords[n4++] = this.newCoords[0] * f;
                    this.charCoords[n4++] = this.newCoords[1] * f;
                    this.charCoords[n4++] = 0.0f;
                    ++n2;
                    break;
                }
            }
            pathIterator.next();
        }
        if (n6 > n3) {
            int n11 = n6 - n7;
            System.arraycopy(this.charCoords, n7, this.charCoords, n4, n11);
            System.arraycopy(this.charCoords, n6, this.charCoords, n7 + 3, n4 - n6 + n11 + 3);
            n4 += 3;
            ++n2;
        }
        if (this.triOutputIndex.length < n2 * 3) {
            this.triOutputIndex = new int[n2 * 3];
        }
        if ((n = this.triangulator.triangulateConcavePolygon(this.charCoords, n3, n2, this.triOutputIndex, FACE_NORMAL)) > 0) {
            n *= 3;
            int n12 = 0;
            while (n12 < n) {
                int n13 = n12++;
                this.triOutputIndex[n13] = this.triOutputIndex[n13] / 3;
            }
            if (this.charIndex.length < n5 + n) {
                int[] nArray = new int[n5 + n];
                System.arraycopy(this.charIndex, 0, nArray, 0, n5);
                this.charIndex = nArray;
            }
            System.arraycopy(this.triOutputIndex, 0, this.charIndex, n5, n);
            n5 += n;
        } else if (n < 0) {
            System.out.println("can't tesselate '" + c + "'");
        }
        for (int i = 0; i < n5 / 3; ++i) {
            int n14 = this.charIndex[i * 3];
            this.charIndex[i * 3] = this.charIndex[i * 3 + 2];
            this.charIndex[i * 3 + 2] = n14;
        }
        characterData.coordinates = this.createFloatBuffer(n4);
        characterData.coordinates.put(this.charCoords, 0, n4);
        characterData.coordIndex = this.createIntBuffer(n5);
        characterData.coordIndex.put(this.charIndex, 0, n5);
        characterData.numIndex = n5;
        this.charDataMap.put(c, characterData);
    }

    private FloatBuffer createFloatBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }

    private IntBuffer createIntBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        return intBuffer;
    }

    private boolean isInsideEvenOdd(float f, float f2, float[] fArray, int n, int n2) {
        boolean bl = false;
        int n3 = n2 - 1;
        int n4 = 0;
        while (n4 < n2) {
            if ((fArray[n + n4 * 3 + 1] <= f2 && f2 < fArray[n + n3 * 3 + 1] || fArray[n + n3 * 3 + 1] <= f2 && f2 < fArray[n + n4 * 3 + 1]) && f < (fArray[n + n3 * 3] - fArray[n + n4 * 3]) * (f2 - fArray[n + n4 * 3 + 1]) / (fArray[n + n3 * 3 + 1] - fArray[n + n4 * 3 + 1]) + fArray[n + n4 * 3]) {
                bl = !bl;
            }
            n3 = n4++;
        }
        return bl;
    }

    private int findClosestPoint(float f, float f2, float[] fArray, int n, int n2) {
        float f3 = f - fArray[n];
        float f4 = f2 - fArray[n + 1];
        float f5 = f3 * f3 + f4 * f4;
        int n3 = n;
        for (int i = 1; i < n2; ++i) {
            f3 = f - fArray[n + i * 3];
            f4 = f2 - fArray[n + i * 3 + 1];
            float f6 = f3 * f3 + f4 * f4;
            if (!(f6 < f5)) continue;
            f5 = f6;
            n3 = n + i * 3;
        }
        return n3;
    }
}

