/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class ConeGenerator
extends GeometryGenerator {
    private static final int DEFAULT_FACETS = 16;
    private float coneHeight;
    private float bottomRadius;
    private boolean useBottom;
    private int facetCount;
    private float[] baseCoordinates;
    private int numBaseValues;
    private float[] texCoordinates2D;
    private int numTexCoords2D;
    private float[] texCoordinates3D;
    private int numTexCoords3D;
    private boolean baseChanged;
    private boolean facetsChanged;

    public ConeGenerator() {
        this(2.0f, 1.0f, 16, true);
    }

    public ConeGenerator(float f, float f2) {
        this(f, f2, 16, true);
    }

    public ConeGenerator(float f, float f2, int n) {
        this(f, f2, n, true);
    }

    public ConeGenerator(float f, float f2, boolean bl) {
        this(f, f2, 16, bl);
    }

    public ConeGenerator(float f, float f2, int n, boolean bl) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Radius is negative or zero");
        }
        this.facetCount = n;
        this.coneHeight = f;
        this.bottomRadius = f2;
        this.useBottom = bl;
        this.baseChanged = true;
        this.facetsChanged = true;
    }

    public float[] getDimensions() {
        return new float[]{this.coneHeight, this.bottomRadius};
    }

    public boolean hasBottom() {
        return this.useBottom;
    }

    public void setDimensions(float f, float f2, boolean bl) {
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Radius is negative or zero");
        }
        this.coneHeight = f;
        this.bottomRadius = f2;
        this.baseChanged = true;
        if (this.useBottom != bl) {
            this.facetsChanged = true;
        }
        this.useBottom = bl;
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (this.facetCount != n) {
            this.baseChanged = true;
            this.facetsChanged = true;
        }
        this.facetCount = n;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        int n2 = this.useBottom ? 2 : 1;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.facetCount * 3 * n2;
                break;
            }
            case 2: {
                n = this.facetCount * 4 * n2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n = (this.facetCount + 1) * 2;
                if (!this.useBottom) break;
                n += this.facetCount + 2;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            case 8: {
                this.indexedTriangleFans(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n2 = this.facetCount * 4 + (this.useBottom ? this.facetCount * 4 : 0);
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n2];
        } else if (geometryData.indexes.length < n2) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n2);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.facetCount;
        while (--n5 >= 0) {
            n = n3;
            nArray[n3++] = n4++;
            nArray[n3++] = n4++;
            nArray[n3++] = n4 + 1;
            nArray[n3++] = n4;
        }
        if (!this.useBottom) {
            return;
        }
        n5 = this.facetCount + 1 << 1;
        ++n4;
        n = this.facetCount;
        while (--n >= 0) {
            nArray[n3++] = n4++;
            nArray[n3++] = n5;
            nArray[n3++] = n5;
            nArray[n3++] = n4 + 1;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 3;
        if (this.useBottom) {
            n <<= 1;
        }
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount;
        while (--n4 >= 0) {
            nArray[n2++] = n3++;
            nArray[n2++] = n3++;
            nArray[n2++] = n3 + 1;
        }
        if (!this.useBottom) {
            return;
        }
        n4 = n3++;
        int n5 = this.facetCount + 1;
        while (--n5 >= 0) {
            nArray[n2++] = n3 + 1;
            nArray[n2++] = n4;
            nArray[n2++] = n3++;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n3 = (this.facetCount + 1) * 2;
        if (this.useBottom) {
            n3 <<= 1;
        }
        int n4 = n2 = this.useBottom ? 2 : 1;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n3];
        } else if (geometryData.indexes.length < n3) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n3);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n2];
        } else if (geometryData.stripCounts.length < n2) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n2);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n3;
        geometryData.numStrips = n2;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n <= this.facetCount; ++n) {
            nArray[n5++] = n6++;
            nArray[n5++] = n6++;
        }
        nArray2[0] = this.facetCount + 1 << 1;
        if (!this.useBottom) {
            return;
        }
        n = n6 + 2;
        n6 = geometryData.vertexCount - 1;
        int n7 = this.facetCount + 1;
        while (--n7 >= 0) {
            nArray[n5++] = n;
            nArray[n5++] = n6--;
        }
        nArray2[1] = this.facetCount + 1 << 1;
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n2 = this.facetCount * 3 + (this.useBottom ? this.facetCount + 2 : 0);
        int n3 = this.facetCount + (this.useBottom ? 1 : 0);
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n2];
        } else if (geometryData.indexes.length < n2) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n2);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n3];
        } else if (geometryData.stripCounts.length < n3) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n3);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n2;
        geometryData.numStrips = n3;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.facetCount; ++n) {
            nArray[n4++] = n5++;
            nArray[n4++] = n5++;
            nArray[n4++] = n5 + 1;
            nArray2[n] = 3;
        }
        if (this.useBottom) {
            n = n5 + 2;
            nArray[n4++] = n;
            nArray2[n3 - 1] = this.facetCount + 2;
            n5 = geometryData.vertexCount - 1;
            int n6 = this.facetCount + 1;
            while (--n6 >= 0) {
                nArray[n4++] = n5--;
            }
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.coneHeight / 2.0f;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[n4++];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4++];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
        }
        if (this.useBottom) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
            }
        }
    }

    private void generateIndexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        float f = this.coneHeight / 2.0f;
        int n4 = this.facetCount + 1;
        while (--n4 >= 0) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[n3++];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n3++];
        }
        if (this.useBottom) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            n3 = 0;
            n4 = this.facetCount + 1;
            while (--n4 >= 0) {
                fArray[n2++] = this.baseCoordinates[n3++];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n3++];
            }
        }
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        n = 0;
        int n3 = this.facetCount;
        while (--n3 >= 0) {
            Vector3f vector3f = this.createFaceNormal(geometryData.coordinates, n + 3, n, n + 6);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n + 3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n + 6);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            n += 9;
        }
        if (!this.useBottom) {
            return;
        }
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = -1.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -1.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -1.0f;
            fArray[n2++] = 0.0f;
        }
    }

    private void generateIndexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData) * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = this.facetCount + 1;
        while (--n3 >= 0) {
            Vector3f vector3f = this.createFaceNormal(geometryData.coordinates, n2 + 3, n2, n2 + 9);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
        }
        if (!this.useBottom) {
            return;
        }
        fArray[n2++] = 0.0f;
        fArray[n2++] = -1.0f;
        fArray[n2++] = 0.0f;
        n3 = this.facetCount + 1;
        while (--n3 >= 0) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = -1.0f;
            fArray[n2++] = 0.0f;
        }
    }

    private void generateUnindexedTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3 = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n3];
        } else if (geometryData.textureCoordinates.length < n3) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n3);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.recalc2DTexture();
        int n4 = 0;
        for (n2 = 0; n2 < this.facetCount; ++n2) {
            n = n2 * 4;
            fArray[n4++] = this.texCoordinates2D[n];
            fArray[n4++] = this.texCoordinates2D[n + 1];
            fArray[n4++] = this.texCoordinates2D[n + 2];
            fArray[n4++] = this.texCoordinates2D[n + 3];
            fArray[n4++] = this.texCoordinates2D[n + 6];
            fArray[n4++] = this.texCoordinates2D[n + 7];
        }
        if (!this.useBottom) {
            return;
        }
        int n5 = (this.facetCount + 1) * 4;
        for (n2 = 0; n2 < this.facetCount; ++n2) {
            n = n2 * 2 + n5 + 2;
            fArray[n4++] = this.texCoordinates2D[n];
            fArray[n4++] = this.texCoordinates2D[n + 1];
            fArray[n4++] = this.texCoordinates2D[n5];
            fArray[n4++] = this.texCoordinates2D[n5 + 1];
            fArray[n4++] = this.texCoordinates2D[n + 2];
            fArray[n4++] = this.texCoordinates2D[n + 3];
        }
    }

    private void generateIndexedTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.recalc2DTexture();
        System.arraycopy(this.texCoordinates2D, 0, geometryData.textureCoordinates, 0, this.numTexCoords2D);
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regenerateBase() {
        if (!this.baseChanged) {
            return;
        }
        this.baseChanged = false;
        this.numBaseValues = (this.facetCount + 1) * 2;
        if (this.baseCoordinates == null || this.numBaseValues > this.baseCoordinates.length) {
            this.baseCoordinates = new float[this.numBaseValues];
        }
        double d = Math.PI * 2 / (double)this.facetCount;
        int n = 0;
        double d2 = 1.5707963267948966 - Math.PI / (double)(this.facetCount / 2);
        int n2 = this.facetCount;
        while (--n2 >= 0) {
            double d3 = d * (double)n2;
            float f = (float)((double)this.bottomRadius * Math.cos(d3 - d2));
            float f2 = (float)((double)this.bottomRadius * Math.sin(d3 - d2));
            this.baseCoordinates[n++] = f;
            this.baseCoordinates[n++] = f2;
        }
        this.baseCoordinates[n++] = this.baseCoordinates[0];
        this.baseCoordinates[n++] = this.baseCoordinates[1];
    }

    private void recalc2DTexture() {
        int n;
        if (!this.facetsChanged) {
            return;
        }
        this.facetsChanged = false;
        int n2 = this.facetCount + 1 << 1;
        if (this.useBottom) {
            n2 += this.facetCount + 1 << 1;
        }
        if (this.texCoordinates2D == null || n2 * 2 > this.texCoordinates2D.length) {
            this.texCoordinates2D = new float[n2 * 2];
        }
        float f = 1.0f / (float)this.facetCount;
        float f2 = (float)(Math.PI * 2 / (double)this.facetCount);
        int n3 = 0;
        float[] fArray = new float[this.facetCount + 1];
        float[] fArray2 = new float[this.facetCount + 1];
        for (n = 0; n < this.facetCount; ++n) {
            float f3 = (float)n * f;
            this.texCoordinates2D[n3++] = f3;
            this.texCoordinates2D[n3++] = 1.0f;
            this.texCoordinates2D[n3++] = f3;
            this.texCoordinates2D[n3++] = 0.0f;
            float f4 = (float)n * f2;
            fArray[n] = (float)(0.5 - (double)this.bottomRadius * Math.cos(f4) / 2.0);
            fArray2[n] = (float)(0.5 - (double)this.bottomRadius * Math.sin(f4) / 2.0);
        }
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 0.0f;
        fArray[this.facetCount] = fArray[0];
        fArray2[this.facetCount] = fArray2[0];
        if (this.useBottom) {
            this.texCoordinates2D[n3++] = 0.5f;
            this.texCoordinates2D[n3++] = 0.5f;
            for (n = 0; n <= this.facetCount; ++n) {
                this.texCoordinates2D[n3++] = fArray[n];
                this.texCoordinates2D[n3++] = fArray2[n];
            }
        }
        this.numTexCoords2D = n3;
    }
}

