/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import java.text.NumberFormat;

public class GeometryData
implements Cloneable {
    public static final int TRIANGLES = 1;
    public static final int QUADS = 2;
    public static final int TRIANGLE_STRIPS = 3;
    public static final int TRIANGLE_FANS = 4;
    public static final int INDEXED_QUADS = 5;
    public static final int INDEXED_TRIANGLES = 6;
    public static final int INDEXED_TRIANGLE_STRIPS = 7;
    public static final int INDEXED_TRIANGLE_FANS = 8;
    public static final int LINES = 9;
    public static final int LINE_STRIPS = 10;
    public static final int INDEXED_LINES = 11;
    public static final int INDEXED_LINE_STRIPS = 12;
    public static final int NORMAL_DATA = 2;
    public static final int TEXTURE_2D_DATA = 4;
    public static final int TEXTURE_3D_DATA = 8;
    public int geometryType = 0;
    public int geometrySubType;
    public int geometryComponents;
    public int vertexCount;
    public float[] coordinates;
    public float[] normals;
    public int indexesCount;
    public int[] indexes;
    public int numStrips;
    public int[] stripCounts;
    public float[] textureCoordinates;
    public float[] colors;
    public int[] normalIndexes;
    public int[] texCoordIndexes;
    public int[] colorIndexes;

    public void prettyPrint() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(3);
        boolean bl = (this.geometryComponents & 4) == 0;
        System.out.println();
        for (int i = 0; i < this.vertexCount; ++i) {
            System.out.print(i);
            System.out.print(" v: ");
            System.out.print(numberFormat.format(this.coordinates[i * 3]));
            System.out.print(' ');
            System.out.print(numberFormat.format(this.coordinates[i * 3 + 1]));
            System.out.print(' ');
            System.out.print(numberFormat.format(this.coordinates[i * 3 + 2]));
            if (this.normals != null) {
                System.out.print(", n: ");
                System.out.print(numberFormat.format(this.normals[i * 3]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.normals[i * 3 + 1]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.normals[i * 3 + 2]));
            }
            if (this.colors != null) {
                System.out.print(", c: ");
                System.out.print(numberFormat.format(this.colors[i * 3]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.colors[i * 3 + 1]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.colors[i * 3 + 2]));
            }
            if (this.textureCoordinates != null) {
                if (bl) {
                    System.out.print(", t: ");
                    System.out.print(numberFormat.format(this.textureCoordinates[i * 3]));
                    System.out.print(' ');
                    System.out.print(numberFormat.format(this.textureCoordinates[i * 3 + 1]));
                    System.out.print(' ');
                    System.out.print(numberFormat.format(this.textureCoordinates[i * 3 + 2]));
                } else {
                    System.out.print(", t: ");
                    System.out.print(numberFormat.format(this.textureCoordinates[i * 2]));
                    System.out.print(' ');
                    System.out.print(numberFormat.format(this.textureCoordinates[i * 2 + 1]));
                }
            }
            System.out.println();
        }
    }

    public Object clone() {
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = this.geometryType;
        geometryData.geometrySubType = this.geometrySubType;
        geometryData.geometryComponents = this.geometryComponents;
        geometryData.vertexCount = this.vertexCount;
        if (this.coordinates != null) {
            geometryData.coordinates = new float[this.coordinates.length];
            System.arraycopy(this.coordinates, 0, geometryData.coordinates, 0, this.coordinates.length);
        }
        if (this.normals != null) {
            geometryData.normals = new float[this.normals.length];
            System.arraycopy(this.normals, 0, geometryData.normals, 0, this.normals.length);
        }
        geometryData.indexesCount = this.indexesCount;
        if (this.indexes != null) {
            geometryData.indexes = new int[this.indexes.length];
            System.arraycopy(this.indexes, 0, geometryData.indexes, 0, this.indexes.length);
        }
        geometryData.numStrips = this.numStrips;
        if (this.stripCounts != null) {
            geometryData.stripCounts = new int[this.stripCounts.length];
            System.arraycopy(this.stripCounts, 0, geometryData.stripCounts, 0, this.stripCounts.length);
        }
        if (this.textureCoordinates != null) {
            geometryData.textureCoordinates = new float[this.textureCoordinates.length];
            System.arraycopy(this.textureCoordinates, 0, geometryData.textureCoordinates, 0, this.textureCoordinates.length);
        }
        if (this.colors != null) {
            geometryData.colors = new float[this.colors.length];
            System.arraycopy(this.colors, 0, geometryData.colors, 0, this.colors.length);
        }
        if (this.normalIndexes != null) {
            geometryData.normalIndexes = new int[this.normalIndexes.length];
            System.arraycopy(this.normalIndexes, 0, geometryData.normalIndexes, 0, this.normalIndexes.length);
        }
        if (this.texCoordIndexes != null) {
            geometryData.texCoordIndexes = new int[this.texCoordIndexes.length];
            System.arraycopy(this.texCoordIndexes, 0, geometryData.texCoordIndexes, 0, this.texCoordIndexes.length);
        }
        if (this.colorIndexes != null) {
            geometryData.colorIndexes = new int[this.colorIndexes.length];
            System.arraycopy(this.colorIndexes, 0, geometryData.colorIndexes, 0, this.colorIndexes.length);
        }
        return geometryData;
    }
}

