/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.CylinderGenerator;
import org.j3d.geom.GeometryData;

public class Cylinder
extends Shape3D {
    private static final float DEFAULT_HEIGHT = 2.0f;
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private CylinderGenerator generator;
    private GeometryData data = new GeometryData();

    public Cylinder() {
        this(2.0f, 1.0f, 16, null);
    }

    public Cylinder(Appearance appearance) {
        this(2.0f, 1.0f, 16, appearance);
    }

    public Cylinder(int n) {
        this(2.0f, 1.0f, n, null);
    }

    public Cylinder(float f, float f2) {
        this(f, f2, 16, null);
    }

    public Cylinder(int n, Appearance appearance) {
        this(2.0f, 1.0f, n, appearance);
    }

    public Cylinder(float f, float f2, Appearance appearance) {
        this(f, f2, 16, appearance);
    }

    public Cylinder(float f, float f2, int n, Appearance appearance) {
        this.data.geometryType = 3;
        this.data.geometryComponents = 2;
        this.generator = new CylinderGenerator(f, f2, n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n2, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setCapability(13);
        this.setAppearance(appearance);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setDimensions(float f, float f2) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setDimensions(f, f2, true);
        this.generator.generate(this.data);
        int n = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }

    public void setFacetCount(int n) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setFacetCount(n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleStripArray triangleStripArray = new TriangleStripArray(this.data.vertexCount, n2, this.data.stripCounts);
        triangleStripArray.setCoordinates(0, this.data.coordinates);
        triangleStripArray.setNormals(0, this.data.normals);
        triangleStripArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleStripArray);
    }
}

