/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.navigation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.Timer;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.renderer.java3d.navigation.FrameUpdateListener;

public class ViewpointTransition
implements ActionListener {
    private View view;
    private TransformGroup viewTg;
    private Timer timer;
    private int totalTimeMS;
    private long epochEndTime;
    private double alfa;
    private int timerDelay = 0;
    private Point3d eye = new Point3d();
    private Point3d eye1 = new Point3d();
    private Point3d eye2 = new Point3d();
    private Point3d center = new Point3d();
    private Point3d center1 = new Point3d();
    private Point3d center2 = new Point3d();
    private Vector3d up = new Vector3d();
    private Vector3d up1 = new Vector3d();
    private Vector3d up2 = new Vector3d();
    private Vector3d location1 = new Vector3d();
    private Vector3d location2 = new Vector3d();
    private Vector3d direction1 = new Vector3d();
    private Vector3d direction2 = new Vector3d();
    private Transform3D previousFrameTx = new Transform3D();
    private Transform3D currentTx = new Transform3D();
    private Transform3D destinationTx = new Transform3D();
    private FrameUpdateListener updateListener;

    public ViewpointTransition() {
        this.timer = new Timer(100, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        Timer.setLogTimers(false);
        this.timer.setCoalesce(true);
        this.timer.stop();
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.updateListener = frameUpdateListener;
    }

    public void transitionTo(View view, TransformGroup transformGroup, Transform3D transform3D, int n) {
        this.view = view;
        this.viewTg = transformGroup;
        this.destinationTx = new Transform3D(transform3D);
        this.totalTimeMS = n;
        this.epochEndTime = System.currentTimeMillis() + (long)n;
        this.timer.start();
        transformGroup.getTransform(this.currentTx);
        this.currentTx.get(this.location1);
        this.eye1.set((Tuple3d)this.location1);
        this.direction1.set(0.0, 0.0, -1.0);
        this.currentTx.transform(this.direction1);
        this.center1.add((Tuple3d)this.eye1, (Tuple3d)this.direction1);
        this.up1.set(0.0, 1.0, 0.0);
        this.currentTx.transform(this.up1);
        this.destinationTx.get(this.location2);
        this.eye2.set((Tuple3d)this.location2);
        this.direction2.set(0.0, 0.0, -1.0);
        this.destinationTx.transform(this.direction2);
        this.center2.add((Tuple3d)this.eye2, (Tuple3d)this.direction2);
        this.up2.set(0.0, 1.0, 0.0);
        this.destinationTx.transform(this.up2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.viewTg.getTransform(this.previousFrameTx);
        if (this.currentTx.equals(this.previousFrameTx)) {
            this.timerDelay = 10 + (int)this.view.getLastFrameDuration() / 2;
            this.timer.setDelay(this.timerDelay);
            this.alfa = 1.0 - (double)(this.epochEndTime - System.currentTimeMillis()) / (double)this.totalTimeMS;
            if (this.alfa > 1.0) {
                this.alfa = 1.0;
            }
            this.eye.interpolate((Tuple3d)this.eye1, (Tuple3d)this.eye2, this.alfa);
            this.center.interpolate((Tuple3d)this.center1, (Tuple3d)this.center2, this.alfa);
            this.up.interpolate((Tuple3d)this.up1, (Tuple3d)this.up2, this.alfa);
            this.currentTx.lookAt(this.eye, this.center, this.up);
            this.currentTx.invert();
            this.currentTx.normalize();
            try {
                this.viewTg.setTransform(this.currentTx);
            }
            catch (Exception exception) {
                System.out.println("Transition stopping due to invalid value");
                this.currentTx.set(this.destinationTx);
                this.viewTg.setTransform(this.currentTx);
                this.alfa = 9.0;
            }
            if (this.updateListener != null) {
                this.updateListener.viewerPositionUpdated(this.currentTx);
            }
        } else {
            this.alfa = 9.0;
        }
        if (this.alfa >= 1.0) {
            this.timer.stop();
            if (this.updateListener != null) {
                this.updateListener.transitionEnded(this.currentTx);
            }
        }
    }
}

