/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import org.j3d.device.input.spaceball.ComponentInputDevice;
import org.j3d.device.input.spaceball.OnDemandInputDevice;

public class Keyboard6DInputDevice
extends OnDemandInputDevice
implements KeyListener,
ComponentInputDevice {
    private static final int[][] itsIncrements = new int[][]{{0, 1}, {0, -1}, {1, 1}, {1, -1}, {2, 1}, {2, -1}, {3, 1}, {3, -1}, {4, 1}, {4, -1}, {5, 1}, {5, -1}};
    private final char[] itsTransformationKeys;
    private final char[] itsButtonKeys;
    private final int[] itsValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsDeltaValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsButtonValues;
    private final int[] itsTempButtonValues;

    public Keyboard6DInputDevice() {
        this(new char[]{'d', 's', 'e', 'x', 'c', 'f', 'i', 'm', 'k', 'j', 'u', 'o'}, new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'});
    }

    public Keyboard6DInputDevice(char[] cArray, char[] cArray2) {
        this.itsTransformationKeys = cArray;
        this.itsButtonKeys = cArray2;
        this.itsButtonValues = new int[cArray2.length];
        this.itsTempButtonValues = new int[cArray2.length];
        this.setScale(new double[]{0.01, 0.01, 0.01, 0.01, 0.01, 0.01});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = -1;
        int n2 = this.itsTransformationKeys.length;
        int n3 = 0;
        while (n3 < n2) {
            if (c == this.itsTransformationKeys[n3]) {
                n = n3;
            }
            ++n3;
        }
        if (n >= 0) {
            Keyboard6DInputDevice keyboard6DInputDevice = this;
            synchronized (keyboard6DInputDevice) {
                int n4 = itsIncrements[n][0];
                this.itsValues[n4] = this.itsValues[n4] + itsIncrements[n][1];
            }
            this.postStimulus();
        } else {
            n = -1;
            int n5 = this.itsButtonKeys.length;
            int n6 = 0;
            while (n6 < n5) {
                if (c == this.itsButtonKeys[n6]) {
                    n = n6;
                }
                ++n6;
            }
            if (n >= 0) {
                Keyboard6DInputDevice keyboard6DInputDevice = this;
                synchronized (keyboard6DInputDevice) {
                    this.itsButtonValues[n] = 1;
                }
                this.postStimulus();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        int n = this.itsButtonKeys.length;
        this.setSensor(new Sensor((InputDevice)this, 30, n));
        Keyboard6DInputDevice keyboard6DInputDevice = this;
        synchronized (keyboard6DInputDevice) {
            int n2 = 0;
            while (n2 < 6) {
                this.itsValues[n2] = 0;
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                this.itsButtonValues[n3] = 0;
                ++n3;
            }
        }
        return super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollAndProcessInput() {
        int n = this.itsButtonValues.length;
        Keyboard6DInputDevice keyboard6DInputDevice = this;
        synchronized (keyboard6DInputDevice) {
            int n2 = 0;
            while (n2 < 6) {
                this.itsDeltaValues[n2] = this.itsValues[n2];
                this.itsValues[n2] = 0;
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                this.itsTempButtonValues[n3] = this.itsButtonValues[n3];
                this.itsButtonValues[n3] = 0;
                ++n3;
            }
        }
        this.setDeltaDeviceInput(this.itsDeltaValues, this.itsTempButtonValues);
    }

    public void attachToComponent(Component component) {
        component.addKeyListener(this);
    }

    public void removeFromComponent(Component component) {
        component.removeKeyListener(this);
    }
}

