/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import org.j3d.device.input.spaceball.ComponentInputDevice;
import org.j3d.device.input.spaceball.OnDemandInputDevice;

public class MouseInputDevice
extends OnDemandInputDevice
implements MouseListener,
MouseMotionListener,
ComponentInputDevice {
    protected final int[] itsCurrentValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsStartValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsDeltaValues = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] itsButtonValues = new int[]{0, 0, 0};
    private final int[] itsTempButtonValues = new int[]{0, 0, 0};

    public MouseInputDevice() {
        this.setScale(0, 0.005);
        this.setScale(1, 0.005);
    }

    public void attachToComponent(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void removeFromComponent(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        MouseInputDevice mouseInputDevice = this;
        synchronized (mouseInputDevice) {
            if (mouseEvent.getModifiers() == 16) {
                this.itsStartValues[0] = mouseEvent.getX();
                this.itsStartValues[1] = mouseEvent.getY();
                this.itsCurrentValues[0] = mouseEvent.getX();
                this.itsCurrentValues[1] = mouseEvent.getY();
                this.itsButtonValues[0] = 1;
            }
            if (mouseEvent.getModifiers() == 8) {
                this.itsButtonValues[1] = 1;
            }
            if (mouseEvent.getModifiers() == 4) {
                this.itsButtonValues[2] = 1;
            }
        }
        this.postStimulus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        MouseInputDevice mouseInputDevice = this;
        synchronized (mouseInputDevice) {
            if (mouseEvent.getModifiers() == 16) {
                this.itsButtonValues[0] = 0;
            }
            if (mouseEvent.getModifiers() == 8) {
                this.itsButtonValues[1] = 0;
            }
            if (mouseEvent.getModifiers() == 4) {
                this.itsButtonValues[2] = 0;
            }
        }
        this.postStimulus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            MouseInputDevice mouseInputDevice = this;
            synchronized (mouseInputDevice) {
                this.itsCurrentValues[0] = mouseEvent.getX();
                this.itsCurrentValues[1] = mouseEvent.getY();
            }
            this.postStimulus();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() {
        this.setSensor(new Sensor((InputDevice)this, 30, 3));
        MouseInputDevice mouseInputDevice = this;
        synchronized (mouseInputDevice) {
            int n = 0;
            while (n < 6) {
                this.itsStartValues[n] = 0;
                this.itsCurrentValues[n] = 0;
                ++n;
            }
            this.itsTempButtonValues[0] = 0;
            this.itsTempButtonValues[1] = 0;
            this.itsTempButtonValues[2] = 0;
        }
        return super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollAndProcessInput() {
        MouseInputDevice mouseInputDevice = this;
        synchronized (mouseInputDevice) {
            int n = 0;
            while (n < 6) {
                this.itsDeltaValues[n] = this.itsCurrentValues[n] - this.itsStartValues[n];
                this.itsStartValues[n] = this.itsCurrentValues[n];
                ++n;
            }
            this.itsTempButtonValues[0] = this.itsButtonValues[0];
            this.itsTempButtonValues[1] = this.itsButtonValues[1];
            this.itsTempButtonValues[2] = this.itsButtonValues[2];
        }
        this.itsDeltaValues[1] = -this.itsDeltaValues[1];
        this.setDeltaDeviceInput(this.itsDeltaValues, this.itsTempButtonValues);
    }
}

