/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.j3d.device.input.spaceball.driver.SpaceballPacket;

public abstract class SpaceballDriver {
    protected final int[] itsPositionData = new int[]{0, 0, 0, 0, 0, 0, 0};
    protected final int[] itsButtonData = new int[20];
    protected final byte[] itsWriteBuffer = new byte[30];
    private final byte[] itsReadBuffer = new byte[60];
    private static final int WRITE_BUFFER_SIZE_IN_BYTE = 30;
    private static final int READ_BUFFER_SIZE_IN_BYTE = 60;
    private static final int MAX_NUM_OF_BUTTONS = 20;
    private static final int[] INIT_BUTTON_DATA = new int[20];
    private SerialPort itsSerialPort = null;
    private InputStream itsInputStream = null;
    private OutputStream itsOutputStream = null;
    private int itsNumOfButtons = 0;
    private int itsCurrentReadBufferOffset = 0;
    private int itsResponseFlag = 0;
    private int itsPacketTerminator = 0;

    public SpaceballDriver(SerialPort serialPort, InputStream inputStream, OutputStream outputStream, int n) {
        this.itsSerialPort = serialPort;
        this.itsInputStream = inputStream;
        this.itsOutputStream = outputStream;
        this.itsPacketTerminator = n;
    }

    public void close() throws IOException {
        if (this.itsInputStream != null) {
            this.itsInputStream.close();
        }
        if (this.itsOutputStream != null) {
            this.itsOutputStream.close();
        }
        if (this.itsSerialPort != null) {
            this.itsSerialPort.close();
        }
        this.itsSerialPort = null;
        this.itsInputStream = null;
        this.itsOutputStream = null;
    }

    public abstract void enableDevice(int var1) throws IOException;

    public abstract void disableDevice(int var1) throws IOException;

    public void read() throws IOException {
        int n = this.itsInputStream.available();
        int n2 = this.itsCurrentReadBufferOffset;
        int n3 = this.itsPacketTerminator;
        byte[] byArray = this.itsReadBuffer;
        while (n > 0) {
            int n4 = this.itsInputStream.read(byArray, n2, 60 - n2);
            n2 = this.decode(byArray, n4 + n2, n3);
            n -= n4;
        }
        this.itsCurrentReadBufferOffset = n2;
    }

    public int getNumOfButtons() {
        return this.itsNumOfButtons;
    }

    public SerialPort getSerialPort() {
        return this.itsSerialPort;
    }

    public void getLastPositionValues(int[] nArray) {
        int n = nArray.length;
        System.arraycopy(this.itsPositionData, 1, nArray, 0, n);
    }

    public void getLastButtonValues(int[] nArray) {
        int n = nArray.length;
        System.arraycopy(this.itsButtonData, 0, nArray, 0, n);
        System.arraycopy(INIT_BUTTON_DATA, 0, this.itsButtonData, 0, this.itsNumOfButtons);
    }

    public void emitPatternedBeep(char[] cArray) throws IOException {
        int n = SpaceballPacket.createPatternedBeepPacket(this.itsWriteBuffer, 0, cArray);
        this.write(this.itsWriteBuffer, 0, n);
    }

    public void resetDevice(int n) throws IOException {
        int n2 = SpaceballPacket.createSimpleRequestPacket(this.itsWriteBuffer, 0, (byte)64);
        this.write(this.itsWriteBuffer, 0, n2);
        this.waitForResponse(n, 64, "reset device");
    }

    protected abstract void dispatch(byte[] var1, int var2, int var3, int var4);

    public void processRequestResponse(int n) {
        if (n == this.itsResponseFlag) {
            this.itsResponseFlag = 0;
        }
    }

    protected void setNumOfButtons(int n) {
        this.itsNumOfButtons = n;
    }

    public void processError(int n, String string) {
        System.err.println("Spaceball (TM) driver: " + string);
    }

    public void processDeviceInfoResponse(int n, int n2, String string) {
        this.processRequestResponse(n);
        System.out.println(string);
    }

    public void processEchoResponse(byte[] byArray) {
        this.processRequestResponse(37);
    }

    public static SerialPort openPort(String string) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
        if (commPortIdentifier.getPortType() != 1) {
            throw new UnsupportedCommOperationException("Spaceball (TM) driver: " + string + " is not a serial port.");
        }
        CommPort commPort = commPortIdentifier.open("Java Spaceball (TM) driver", 2000);
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    protected final void write(byte[] byArray, int n, int n2) throws IOException {
        this.itsOutputStream.write(this.itsWriteBuffer, n, n2);
        this.itsOutputStream.flush();
    }

    protected final void waitForResponse(int n, int n2, String string) throws IOException {
        this.itsResponseFlag = n2;
        long l = System.currentTimeMillis() + (long)n;
        boolean bl = System.currentTimeMillis() > l;
        while (!bl && this.itsResponseFlag != 0) {
            this.read();
            boolean bl2 = bl = System.currentTimeMillis() > l;
        }
        if (bl) {
            throw new IOException("Spaceball (TM) driver: Timeout without response (" + string + ").");
        }
    }

    protected static void printBuffer(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            String string = Integer.toHexString(byArray[n2]);
            System.out.print(string + " ");
            ++n2;
        }
        System.out.println();
    }

    public static void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    private int decode(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = SpaceballDriver.searchForPacketEnd(byArray, 0, n, n2);
        while (n5 > 0) {
            n3 = byArray[n4];
            int n6 = n5 - n4;
            this.dispatch(byArray, n4, n6, n3);
            n4 = n5 + 1;
            n5 = SpaceballDriver.searchForPacketEnd(byArray, n4, n, n2);
        }
        n3 = n - n4;
        if (n3 > 0) {
            System.arraycopy(byArray, n4, byArray, 0, n3);
        }
        return n3;
    }

    private static int searchForPacketEnd(byte[] byArray, int n, int n2, int n3) {
        while (n < n2 && byArray[n] != n3) {
            ++n;
        }
        return n == n2 ? -1 : n;
    }
}

