/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.GeometryData;

public class IntersectionUtils {
    private Point3d wkPoint = new Point3d();
    private Vector3d wkVec = new Vector3d();
    private Vector3d v0 = new Vector3d();
    private Vector3d v1 = new Vector3d();
    private Vector3d normal = new Vector3d();
    private Vector3d diffVec = new Vector3d();
    private Point3d pickStart;
    private Vector3d pickDir;
    private float[] workingCoords;
    private int[] workingStrips;
    private int[] workingIndicies;
    private float[] working2dCoords;
    private float[] wkPolygon = new float[12];
    private Transform3D reverseTx = new Transform3D();

    public IntersectionUtils() {
        this.pickStart = new Point3d();
        this.pickDir = new Vector3d();
    }

    public void clear() {
        this.workingCoords = null;
        this.working2dCoords = null;
        this.workingStrips = null;
        this.workingIndicies = null;
    }

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, GeometryData geometryData, Transform3D transform3D, Point3d point3d2, boolean bl) {
        boolean bl2 = false;
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        switch (geometryData.geometryType) {
            case 1: {
                bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 3, point3d2, bl);
                break;
            }
            case 2: {
                bl2 = this.rayQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 4, point3d2, bl);
                break;
            }
            case 3: {
                bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 4: {
                bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 5: {
                bl2 = this.rayIndexedQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
                break;
            }
            case 6: {
                bl2 = this.rayIndexedTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
            }
        }
        if (bl2) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, GeometryArray geometryArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        Object object = geometryArray.getUserData();
        if (object instanceof GeometryData) {
            return this.rayUnknownGeometry(point3d, vector3d, f, (GeometryData)object, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof TriangleArray) {
            return this.rayTriangleArray(point3d, vector3d, f, (TriangleArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof QuadArray) {
            return this.rayQuadArray(point3d, vector3d, f, (QuadArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof TriangleStripArray) {
            return this.rayTriangleStripArray(point3d, vector3d, f, (TriangleStripArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof TriangleFanArray) {
            return this.rayTriangleFanArray(point3d, vector3d, f, (TriangleFanArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof IndexedTriangleArray) {
            return this.rayIndexedTriangleArray(point3d, vector3d, f, (IndexedTriangleArray)geometryArray, transform3D, point3d2, bl);
        }
        if (geometryArray instanceof IndexedQuadArray) {
            return this.rayIndexedQuadArray(point3d, vector3d, f, (IndexedQuadArray)geometryArray, transform3D, point3d2, bl);
        }
        return false;
    }

    public boolean rayTriangleArray(Point3d point3d, Vector3d vector3d, float f, TriangleArray triangleArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!triangleArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = triangleArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = triangleArray.getVertexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        triangleArray.getCoordinates(0, this.workingCoords);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, n2 / 3, point3d2, bl);
        if (bl2) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayQuadArray(Point3d point3d, Vector3d vector3d, float f, QuadArray quadArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!quadArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = quadArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = quadArray.getVertexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        quadArray.getCoordinates(0, this.workingCoords);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, n2 / 4, point3d2, bl);
        if (bl2) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayTriangleStripArray(Point3d point3d, Vector3d vector3d, float f, TriangleStripArray triangleStripArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!triangleStripArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = triangleStripArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = triangleStripArray.getVertexCount();
        int n3 = triangleStripArray.getNumStrips();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingStrips == null || this.workingStrips.length != n3) {
            this.workingStrips = new int[n3];
        }
        triangleStripArray.getCoordinates(0, this.workingCoords);
        triangleStripArray.getStripVertexCounts(this.workingStrips);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingStrips, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayTriangleFanArray(Point3d point3d, Vector3d vector3d, float f, TriangleFanArray triangleFanArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!triangleFanArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        int n = triangleFanArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = triangleFanArray.getVertexCount();
        int n3 = triangleFanArray.getNumStrips();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingStrips == null || this.workingStrips.length != n3) {
            this.workingStrips = new int[n3];
        }
        triangleFanArray.getCoordinates(0, this.workingCoords);
        triangleFanArray.getStripVertexCounts(this.workingStrips);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingStrips, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayIndexedTriangleArray(Point3d point3d, Vector3d vector3d, float f, IndexedTriangleArray indexedTriangleArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!indexedTriangleArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        if (!indexedTriangleArray.getCapability(9)) {
            throw new IllegalStateException("Not allowed to read indexes");
        }
        int n = indexedTriangleArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = indexedTriangleArray.getVertexCount();
        int n3 = indexedTriangleArray.getIndexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingIndicies == null || this.workingIndicies.length != n3) {
            this.workingIndicies = new int[n3];
        }
        indexedTriangleArray.getCoordinates(0, this.workingCoords);
        indexedTriangleArray.getCoordinateIndices(0, this.workingIndicies);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayIndexedTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingIndicies, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayIndexedQuadArray(Point3d point3d, Vector3d vector3d, float f, IndexedQuadArray indexedQuadArray, Transform3D transform3D, Point3d point3d2, boolean bl) {
        if (!indexedQuadArray.getCapability(0)) {
            throw new IllegalStateException("Not allowed to read coordinates");
        }
        if (!indexedQuadArray.getCapability(9)) {
            throw new IllegalStateException("Not allowed to read indexes");
        }
        int n = indexedQuadArray.getVertexFormat();
        if ((n & 0x100) != 0) {
            throw new IllegalArgumentException("We can't handle interleaved geometry yet");
        }
        int n2 = indexedQuadArray.getVertexCount();
        int n3 = indexedQuadArray.getIndexCount();
        if (this.workingCoords == null || this.workingCoords.length != n2 * 3) {
            this.workingCoords = new float[n2 * 3];
        }
        if (this.workingIndicies == null || this.workingIndicies.length != n3) {
            this.workingIndicies = new int[n3];
        }
        indexedQuadArray.getCoordinates(0, this.workingCoords);
        indexedQuadArray.getCoordinateIndices(0, this.workingIndicies);
        this.reverseTx.invert(transform3D);
        this.transformPicks(this.reverseTx, point3d, vector3d);
        boolean bl2 = this.rayIndexedQuadArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingIndicies, n3, point3d2, bl);
        if (bl2 && !bl) {
            transform3D.transform(point3d2);
        }
        return bl2;
    }

    public boolean rayTriangleArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2, boolean bl) {
        if (fArray.length < n * 9) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = -1.0;
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(fArray, n2 * 9, this.wkPolygon, 0, 9);
            if (this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) {
                this.diffVec.sub((Tuple3d)point3d, (Tuple3d)this.wkPoint);
                double d2 = this.diffVec.lengthSquared();
                if (d == -1.0 || d2 < d) {
                    d = d2;
                    point3d2.set((Tuple3d)this.wkPoint);
                    if (bl) break;
                }
            }
            ++n2;
        }
        return d != -1.0;
    }

    public boolean rayQuadArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2, boolean bl) {
        if (fArray.length < n * 12) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = -1.0;
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(fArray, n2 * 12, this.wkPolygon, 0, 12);
            if (this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 4, this.wkPoint)) {
                this.diffVec.sub((Tuple3d)point3d, (Tuple3d)this.wkPoint);
                double d2 = this.diffVec.lengthSquared();
                if (d == -1.0 || d2 < d) {
                    d = d2;
                    point3d2.set((Tuple3d)this.wkPoint);
                    if (bl) break;
                }
            }
            ++n2;
        }
        return d != -1.0;
    }

    public boolean rayTriangleStripArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            n2 += nArray[n3];
        }
        if (fArray.length < n2 * 3) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = -1.0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < nArray[n5] - 2) {
                System.arraycopy(fArray, n4 + n6 * 3, this.wkPolygon, 0, 9);
                if (this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) {
                    this.diffVec.sub((Tuple3d)point3d, (Tuple3d)this.wkPoint);
                    double d2 = this.diffVec.lengthSquared();
                    if (d == -1.0 || d2 < d) {
                        d = d2;
                        point3d2.set((Tuple3d)this.wkPoint);
                        if (bl) break;
                    }
                }
                ++n6;
            }
            n4 += nArray[n5] * 3;
            ++n5;
        }
        return d != -1.0;
    }

    public boolean rayTriangleFanArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            n2 += nArray[n3];
        }
        if (fArray.length < n2 * 3) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = -1.0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            this.wkPolygon[0] = fArray[n4];
            this.wkPolygon[1] = fArray[n4 + 1];
            this.wkPolygon[2] = fArray[n4 + 2];
            int n6 = 1;
            while (n6 < nArray[n5] - 2) {
                this.wkPolygon[3] = fArray[n4 + n6 * 3];
                this.wkPolygon[4] = fArray[n4 + n6 * 3 + 1];
                this.wkPolygon[5] = fArray[n4 + n6 * 3 + 2];
                this.wkPolygon[6] = fArray[n4 + n6 * 3 + 3];
                this.wkPolygon[7] = fArray[n4 + n6 * 3 + 4];
                this.wkPolygon[8] = fArray[n4 + n6 * 3 + 5];
                if (this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) {
                    this.diffVec.sub((Tuple3d)point3d, (Tuple3d)this.wkPoint);
                    double d2 = this.diffVec.lengthSquared();
                    if (d == -1.0 || d2 < d) {
                        d = d2;
                        point3d2.set((Tuple3d)this.wkPoint);
                        if (bl) break;
                    }
                }
                ++n6;
            }
            n4 += nArray[n5] * 3;
            ++n5;
        }
        return d != -1.0;
    }

    public boolean rayIndexedTriangleArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = -1.0;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2++];
            int n4 = nArray[n2++];
            int n5 = nArray[n2++];
            this.wkPolygon[0] = fArray[n3++];
            this.wkPolygon[1] = fArray[n3++];
            this.wkPolygon[2] = fArray[n3];
            this.wkPolygon[3] = fArray[n4++];
            this.wkPolygon[4] = fArray[n4++];
            this.wkPolygon[5] = fArray[n4];
            this.wkPolygon[6] = fArray[n5++];
            this.wkPolygon[7] = fArray[n5++];
            this.wkPolygon[8] = fArray[n5];
            if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 3, this.wkPoint)) continue;
            this.diffVec.sub((Tuple3d)point3d, (Tuple3d)this.wkPoint);
            double d2 = this.diffVec.lengthSquared();
            if (d != -1.0 && !(d2 < d)) continue;
            d = d2;
            point3d2.set((Tuple3d)this.wkPoint);
            if (bl) break;
        }
        return d != -1.0;
    }

    public boolean rayIndexedQuadArray(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int[] nArray, int n, Point3d point3d2, boolean bl) {
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[8];
        }
        double d = -1.0;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2++];
            int n4 = nArray[n2++];
            int n5 = nArray[n2++];
            int n6 = nArray[n2++];
            this.wkPolygon[0] = fArray[n3++];
            this.wkPolygon[1] = fArray[n3++];
            this.wkPolygon[2] = fArray[n3];
            this.wkPolygon[3] = fArray[n4++];
            this.wkPolygon[4] = fArray[n4++];
            this.wkPolygon[5] = fArray[n4];
            this.wkPolygon[6] = fArray[n5++];
            this.wkPolygon[7] = fArray[n5++];
            this.wkPolygon[8] = fArray[n5];
            this.wkPolygon[9] = fArray[n6++];
            this.wkPolygon[10] = fArray[n6++];
            this.wkPolygon[11] = fArray[n6];
            if (!this.rayPolygonChecked(point3d, vector3d, f, this.wkPolygon, 4, this.wkPoint)) continue;
            this.diffVec.sub((Tuple3d)point3d, (Tuple3d)this.wkPoint);
            double d2 = this.diffVec.lengthSquared();
            if (d != -1.0 && !(d2 < d)) continue;
            d = d2;
            point3d2.set((Tuple3d)this.wkPoint);
            if (bl) break;
        }
        return d != -1.0;
    }

    public boolean rayPolygon(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2) {
        if (fArray.length < n * 2) {
            throw new IllegalArgumentException("coords too small for numCoords");
        }
        if (this.working2dCoords == null || this.working2dCoords.length < n * 2) {
            this.working2dCoords = new float[n * 2];
        }
        return this.rayPolygonChecked(point3d, vector3d, f, fArray, n, point3d2);
    }

    private boolean rayPolygonChecked(Point3d point3d, Vector3d vector3d, float f, float[] fArray, int n, Point3d point3d2) {
        int n2;
        this.v0.x = fArray[3] - fArray[0];
        this.v0.y = fArray[4] - fArray[1];
        this.v0.z = fArray[5] - fArray[2];
        this.v1.x = fArray[6] - fArray[3];
        this.v1.y = fArray[7] - fArray[4];
        this.v1.z = fArray[8] - fArray[5];
        this.normal.cross(this.v0, this.v1);
        if (this.normal.lengthSquared() == 0.0) {
            return false;
        }
        double d = this.normal.dot(vector3d);
        if (d == 0.0) {
            return false;
        }
        this.wkVec.x = fArray[0];
        this.wkVec.y = fArray[1];
        this.wkVec.z = fArray[2];
        double d2 = this.normal.dot(this.wkVec);
        this.wkVec.set((Tuple3d)point3d);
        double d3 = this.normal.dot(this.wkVec);
        double d4 = (d2 - d3) / d;
        if (d4 < 0.0) {
            return false;
        }
        point3d2.x = point3d.x + vector3d.x * d4;
        point3d2.y = point3d.y + vector3d.y * d4;
        point3d2.z = point3d.z + vector3d.z * d4;
        if (f != 0.0f && point3d.distance(point3d2) > (double)f) {
            return false;
        }
        double d5 = this.normal.x >= 0.0 ? this.normal.x : -this.normal.x;
        double d6 = this.normal.y >= 0.0 ? this.normal.y : -this.normal.y;
        double d7 = this.normal.z >= 0.0 ? this.normal.z : -this.normal.z;
        int n3 = d5 > d6 ? 0 : 1;
        if (n3 == 0) {
            if (d5 < d7) {
                n3 = 2;
            }
        } else if (d6 < d7) {
            n3 = 2;
        }
        int n4 = 2 * n - 1;
        switch (n3) {
            case 0: {
                n2 = n;
                while (--n2 >= 0) {
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 2] - (float)point3d2.z;
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 1] - (float)point3d2.y;
                }
                break;
            }
            case 1: {
                n2 = n;
                while (--n2 >= 0) {
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 2] - (float)point3d2.z;
                    this.working2dCoords[n4--] = fArray[n2 * 3] - (float)point3d2.x;
                }
                break;
            }
            case 2: {
                n2 = n;
                while (--n2 >= 0) {
                    this.working2dCoords[n4--] = fArray[n2 * 3 + 1] - (float)point3d2.y;
                    this.working2dCoords[n4--] = fArray[n2 * 3] - (float)point3d2.x;
                }
                break;
            }
        }
        int n5 = 0;
        int n6 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        n2 = 0;
        while (n2 < n) {
            n4 = (n2 + 1) % n;
            int n7 = n2 * 2;
            int n8 = n4 * 2;
            int n9 = n2 * 2 + 1;
            int n10 = n4 * 2 + 1;
            int n11 = (double)this.working2dCoords[n10] < 0.0 ? -1 : 1;
            if (n6 != n11) {
                float f2;
                if ((double)this.working2dCoords[n7] > 0.0 && (double)this.working2dCoords[n8] > 0.0) {
                    ++n5;
                } else if (((double)this.working2dCoords[n7] > 0.0 || (double)this.working2dCoords[n8] > 0.0) && (f2 = this.working2dCoords[n7] - this.working2dCoords[n9] * (this.working2dCoords[n8] - this.working2dCoords[n7]) / (this.working2dCoords[n10] - this.working2dCoords[n9])) > 0.0f) {
                    ++n5;
                }
                n6 = n11;
            }
            ++n2;
        }
        return n5 % 2 == 1;
    }

    private void transformPicks(Transform3D transform3D, Point3d point3d, Vector3d vector3d) {
        transform3D.transform(point3d, this.pickStart);
        transform3D.transform(vector3d, this.pickDir);
    }
}

