/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;

public class NormalUtils {
    private static NormalUtils sharedInstance;
    private Vector3f normal;
    private Vector3f v0 = new Vector3f();
    private Vector3f v1 = new Vector3f();

    public NormalUtils() {
        this.normal = new Vector3f();
    }

    public NormalUtils getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new NormalUtils();
        }
        return sharedInstance;
    }

    public void negate(float[] fArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            fArray[n2] = -fArray[n2++];
            fArray[n2] = -fArray[n2++];
            fArray[n2] = -fArray[n2++];
            ++n3;
        }
    }

    public void negate(float[][] fArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            fArray[n2][0] = -fArray[n2][0];
            fArray[n2][1] = -fArray[n2][1];
            fArray[n2][2] = -fArray[n2][2];
            ++n2;
        }
    }

    public void negate(float[] fArray, int n, float[] fArray2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            fArray2[n2] = -fArray[n2++];
            fArray2[n2] = -fArray[n2++];
            fArray2[n2] = -fArray[n2++];
            ++n3;
        }
    }

    public void translate(float[][] fArray, int n, float[][] fArray2) {
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2][0] = -fArray[n2][0];
            fArray2[n2][1] = -fArray[n2][1];
            fArray2[n2][2] = -fArray[n2][2];
            ++n2;
        }
    }

    public void createFaceNormal(float[] fArray, int n, int n2, int n3, float[] fArray2, int n4) {
        this.v0.x = fArray[n2] - fArray[n];
        this.v0.y = fArray[n2 + 1] - fArray[n + 1];
        this.v0.z = fArray[n2 + 2] - fArray[n + 2];
        this.v1.x = fArray[n] - fArray[n3];
        this.v1.y = fArray[n + 1] - fArray[n3 + 1];
        this.v1.z = fArray[n + 2] - fArray[n3 + 2];
        this.normal.cross(this.v0, this.v1);
        this.normal.normalize();
        fArray2[n4] = this.normal.x;
        fArray2[n4 + 1] = this.normal.y;
        fArray2[n4 + 2] = this.normal.z;
    }

    public void createFaceNormal(float[][] fArray, int n, int n2, int n3, float[][] fArray2, int n4) {
        this.v0.x = fArray[n2][0] - fArray[n][0];
        this.v0.y = fArray[n2][1] - fArray[n][1];
        this.v0.z = fArray[n2][2] - fArray[n][2];
        this.v1.x = fArray[n][0] - fArray[n3][0];
        this.v1.y = fArray[n][1] - fArray[n3][1];
        this.v1.z = fArray[n][2] - fArray[n3][2];
        this.normal.cross(this.v0, this.v1);
        this.normal.normalize();
        fArray2[n4][0] = this.normal.x;
        fArray2[n4][1] = this.normal.y;
        fArray2[n4][2] = this.normal.z;
    }

    public void createRadialNormal(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray[n];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + 2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 != 0.0) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            fArray2[n2] = f * f4;
            fArray2[n2 + 1] = f2 * f4;
            fArray2[n2 + 2] = f3 * f4;
        } else {
            fArray2[n2] = 0.0f;
            fArray2[n2 + 1] = 0.0f;
            fArray2[n2 + 2] = 0.0f;
        }
    }

    public void createRadialNormal(float[][] fArray, int n, float[][] fArray2, int n2) {
        float f = fArray[n][0];
        float f2 = fArray[n][1];
        float f3 = fArray[n][2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 != 0.0) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            fArray2[n2][0] = f * f4;
            fArray2[n2][1] = f2 * f4;
            fArray2[n2][2] = f3 * f4;
        } else {
            fArray2[n2][0] = 0.0f;
            fArray2[n2][1] = 0.0f;
            fArray2[n2][2] = 0.0f;
        }
    }

    public void createRadialNormal(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        float f = fArray[n] - fArray2[n2];
        float f2 = fArray[n + 1] - fArray2[n2 + 1];
        float f3 = fArray[n + 2] - fArray2[n2 + 2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 != 0.0) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            fArray3[n3] = f * f4;
            fArray3[n3 + 1] = f2 * f4;
            fArray3[n3 + 2] = f3 * f4;
        } else {
            fArray3[n3] = 0.0f;
            fArray3[n3 + 1] = 0.0f;
            fArray3[n3 + 2] = 0.0f;
        }
    }

    public void createRadialNormal(float[][] fArray, int n, float[][] fArray2, int n2, float[][] fArray3, int n3) {
        float f = fArray[n][0] - fArray2[n2][0];
        float f2 = fArray[n][1] - fArray2[n2][1];
        float f3 = fArray[n][2] - fArray2[n2][2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 != 0.0) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            fArray3[n3][0] = f * f4;
            fArray3[n3][1] = f2 * f4;
            fArray3[n3][2] = f3 * f4;
        } else {
            fArray3[n3][0] = 0.0f;
            fArray3[n3][1] = 0.0f;
            fArray3[n3][2] = 0.0f;
        }
    }
}

