/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;

public class RasterTextLabel
extends Shape3D {
    private static final String CANT_CHANGE_MSG = "Attempting to make a change to a label that was not originally configured to be dynamic";
    private static final Color CLEAR_COLOR = new Color(0, 0, 0, 0);
    private static final int BORDER_INSETS = 2;
    private Color textColor;
    private Color borderColor;
    private Color backgroundColor;
    private Font labelFont;
    private Raster raster;
    private ImageComponent2D component;
    private boolean adjustImageSize = false;
    private boolean isDynamic;
    private BufferedImage textImage;
    private int imageWidth;
    private int imageHeight;

    public RasterTextLabel() {
        this(null, null, true, true, 0.0f, 0.0f, 0.0f, null, null);
    }

    public RasterTextLabel(String string, Color color) {
        this(string, color, false, true, 0.0f, 0.0f, 0.0f, null, null);
    }

    public RasterTextLabel(String string, Color color, boolean bl) {
        this(string, color, bl, false, 0.0f, 0.0f, 0.0f, null, null);
    }

    public RasterTextLabel(String string, Color color, boolean bl, boolean bl2) {
        this(string, color, bl, bl2, 0.0f, 0.0f, 0.0f, null, null);
    }

    public RasterTextLabel(String string, Color color, boolean bl, float f, float f2, float f3) {
        this(string, color, bl, false, f, f2, f3, null, null);
    }

    public RasterTextLabel(String string, Color color, boolean bl, boolean bl2, float f, float f2, float f3) {
        this(string, color, bl, bl2, f, f2, f3, null, null);
    }

    public RasterTextLabel(String string, Color color, boolean bl, boolean bl2, float f, float f2, float f3, Color color2, Font font) {
        this.textColor = color != null ? color : Color.white;
        this.borderColor = color2;
        this.labelFont = font;
        this.isDynamic = bl2;
        Appearance appearance = new Appearance();
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setAlphaTestFunction(6);
        if (bl) {
            renderingAttributes.setDepthBufferEnable(false);
            renderingAttributes.setDepthBufferWriteEnable(false);
        }
        appearance.setRenderingAttributes(renderingAttributes);
        this.setAppearance(appearance);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics graphics = bufferedImage.getGraphics();
        FontMetrics fontMetrics = this.labelFont == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.labelFont);
        int n = 0;
        int n2 = 0;
        if (string == null) {
            this.raster = new Raster();
            this.raster.setPosition(new Point3f(f, f2, f3));
        } else {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.dispose();
            bufferedImage.flush();
            bufferedImage = null;
            n = (int)rectangle2D.getWidth();
            n2 = (int)rectangle2D.getHeight();
            int n3 = fontMetrics.getMaxAscent();
            if (color2 != null) {
                n += 6;
                n2 += 6;
            }
            this.textImage = new BufferedImage(n, n2, 2);
            graphics = this.textImage.getGraphics();
            this.renderImage(graphics, string, n, n2, n3);
            graphics.dispose();
            this.component = new ImageComponent2D(2, this.textImage);
            this.raster = new Raster(new Point3f(f, f2, f3), 1, 0, 0, n, n2, this.component, null);
            if (!bl2) {
                this.component = null;
                this.textImage = null;
            }
        }
        if (bl2) {
            this.component.setCapability(3);
            this.raster.setCapability(9);
            this.raster.setCapability(5);
            this.raster.clearCapabilityIsFrequent(5);
        }
        this.setGeometry((Geometry)this.raster);
    }

    public void setText(String string) throws IllegalStateException {
        if (!this.isDynamic) {
            throw new IllegalStateException(CANT_CHANGE_MSG);
        }
        this.updateText(string);
    }

    public void setText(String string, boolean bl) throws IllegalStateException {
        if (!this.isDynamic) {
            throw new IllegalStateException(CANT_CHANGE_MSG);
        }
        if (bl) {
            this.textImage = null;
        }
        this.updateText(string);
    }

    public void setText(String string, Color color) throws IllegalStateException {
        if (!this.isDynamic) {
            throw new IllegalStateException(CANT_CHANGE_MSG);
        }
        this.textColor = color != null ? color : Color.white;
        this.updateText(string);
    }

    public void setText(String string, Color color, boolean bl) throws IllegalStateException {
        if (!this.isDynamic) {
            throw new IllegalStateException(CANT_CHANGE_MSG);
        }
        if (bl) {
            this.textImage = null;
        }
        this.textColor = color != null ? color : Color.white;
        this.updateText(string);
    }

    public void fixSize(boolean bl) throws IllegalStateException {
        if (!this.isDynamic) {
            throw new IllegalStateException(CANT_CHANGE_MSG);
        }
        this.adjustImageSize = bl;
    }

    public void crop() throws IllegalStateException {
        if (!this.isDynamic) {
            throw new IllegalStateException(CANT_CHANGE_MSG);
        }
        this.textImage = null;
    }

    private void updateText(String string) {
        if (string == null) {
            this.raster.setSize(0, 0);
            return;
        }
        int n = 0;
        int n2 = 0;
        FontMetrics fontMetrics = null;
        Graphics graphics = null;
        if (this.textImage == null) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            graphics = bufferedImage.getGraphics();
            fontMetrics = this.labelFont == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.labelFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.dispose();
            bufferedImage.flush();
            n = (int)rectangle2D.getWidth();
            n2 = (int)rectangle2D.getHeight();
            if (this.borderColor != null) {
                n += 6;
                n2 += 6;
            }
            this.textImage = new BufferedImage(n, n2, 2);
            graphics = this.textImage.createGraphics();
            this.renderImage(graphics, string, n, n2, fontMetrics.getAscent());
            this.component = new ImageComponent2D(2, this.textImage);
            this.component.setCapability(3);
            this.raster.setSize(n, n2);
            this.raster.setImage(this.component);
        } else if (this.adjustImageSize) {
            graphics = this.textImage.getGraphics();
            fontMetrics = this.labelFont == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.labelFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            n = (int)rectangle2D.getWidth();
            n2 = (int)rectangle2D.getHeight();
            if (this.borderColor != null) {
                n += 6;
                n2 += 6;
            }
            if (n > this.textImage.getWidth(null) || n2 > this.textImage.getHeight(null)) {
                this.textImage.flush();
                this.textImage = new BufferedImage(n, n2, 2);
                graphics = this.textImage.createGraphics();
                fontMetrics = this.labelFont == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.labelFont);
                this.renderImage(graphics, string, n, n2, fontMetrics.getAscent());
                this.component = new ImageComponent2D(2, this.textImage);
                this.component.setCapability(3);
                this.raster.setSize(n, n2);
                this.raster.setImage(this.component);
            } else {
                this.renderImage(graphics, string, n, n2, fontMetrics.getAscent());
                this.component.set(this.textImage);
                this.raster.setSize(n, n2);
            }
        } else {
            graphics = this.textImage.createGraphics();
            fontMetrics = this.labelFont == null ? graphics.getFontMetrics() : graphics.getFontMetrics(this.labelFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            n = (int)rectangle2D.getWidth();
            n2 = (int)rectangle2D.getHeight();
            if (this.borderColor != null) {
                n += 6;
                n2 += 6;
            }
            this.renderImage(graphics, string, n, n2, fontMetrics.getAscent());
            this.component.set(this.textImage);
            this.raster.setSize(n, n2);
        }
        graphics.dispose();
    }

    private void renderImage(Graphics graphics, String string, int n, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setColor(CLEAR_COLOR);
        graphics2D.fillRect(0, 0, this.imageWidth, this.imageHeight);
        if (this.borderColor != null) {
            graphics2D.setColor(this.borderColor);
            graphics2D.drawRect(0, 0, n - 1, n2 - 1);
            graphics2D.setColor(this.textColor);
            graphics2D.setFont(this.labelFont);
            graphics2D.drawString(string, 3, n3 + 2 + 1);
        } else {
            graphics2D.setColor(this.textColor);
            graphics2D.setFont(this.labelFont);
            graphics2D.drawString(string, 0, n3);
        }
        this.imageWidth = n;
        this.imageHeight = n2;
    }
}

