/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class TorusGenerator
extends GeometryGenerator {
    private static final float DEFAULT_INNER_RADIUS = 0.25f;
    private static final float DEFAULT_OUTER_RADIUS = 1.0f;
    private static final int DEFAULT_INNER_FACETS = 16;
    private static final int DEFAULT_OUTER_FACETS = 16;
    private float innerRadius;
    private float outerRadius;
    private int innerFacetCount;
    private int outerFacetCount;
    private float[] shapeCoordinates;
    private int numShapeValues;
    private boolean shapeChanged;
    private float[] oradiusCoordinates;

    public TorusGenerator() {
        this(0.25f, 1.0f, 16, 16);
    }

    public TorusGenerator(float f, float f2) {
        this(f, f2, 16, 16);
    }

    public TorusGenerator(int n, int n2) {
        this(0.25f, 1.0f, n, n2);
    }

    public TorusGenerator(float f, float f2, int n, int n2) {
        if (n < 4 || n2 < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Inner facets not / 2");
        }
        this.innerRadius = f;
        this.outerRadius = f2;
        this.innerFacetCount = n;
        this.outerFacetCount = n2;
        this.shapeChanged = true;
    }

    public float[] getDimensions() {
        return new float[]{this.innerRadius, this.outerRadius};
    }

    public void setDimensions(float f, float f2) {
        if (this.innerRadius != f || this.outerRadius != f2) {
            this.shapeChanged = true;
            this.innerRadius = f;
            this.outerRadius = f2;
        }
    }

    public void setFacetCount(int n, int n2) {
        if (n < 4 || n2 < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Inner facets not / 2");
        }
        this.innerFacetCount = n;
        this.outerFacetCount = n2;
        this.shapeChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.innerFacetCount * this.outerFacetCount * 6;
                break;
            }
            case 2: {
                n = this.innerFacetCount * this.outerFacetCount * 4;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n4 = geometryData.vertexCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n4;
        int n5 = 0;
        int n6 = this.innerFacetCount / 2;
        int n7 = this.outerFacetCount - 1;
        int n8 = 0;
        while (n8 < n6) {
            n3 = n8 * this.innerFacetCount;
            n2 = 0;
            while (n2 < n7) {
                n = n2 + n3;
                nArray[n5++] = n + this.outerFacetCount;
                nArray[n5++] = n;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + this.outerFacetCount + 1;
                ++n2;
            }
            n = n2 + n3;
            nArray[n5++] = n + this.outerFacetCount;
            nArray[n5++] = n;
            nArray[n5++] = n3;
            nArray[n5++] = n3 + this.outerFacetCount;
            ++n8;
        }
        n8 = n6 + 1;
        while (n8 <= n6 * 2) {
            n3 = n8 * this.innerFacetCount;
            n2 = 0;
            while (n2 < n7) {
                n = n2 + n3;
                nArray[n5++] = n;
                nArray[n5++] = n + this.outerFacetCount;
                nArray[n5++] = n + this.outerFacetCount + 1;
                nArray[n5++] = n + 1;
                ++n2;
            }
            n = n2 + n3;
            nArray[n5++] = n;
            nArray[n5++] = n + this.outerFacetCount;
            nArray[n5++] = n3 + this.outerFacetCount;
            nArray[n5++] = n3;
            ++n8;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n4 = geometryData.vertexCount * 6;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n4;
        int n5 = 0;
        int n6 = this.innerFacetCount / 2;
        int n7 = this.outerFacetCount - 1;
        int n8 = 0;
        while (n8 < n6) {
            n3 = n8 * this.innerFacetCount;
            n2 = 0;
            while (n2 < n7) {
                n = n2 + n3;
                nArray[n5++] = n + this.outerFacetCount;
                nArray[n5++] = n;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + this.outerFacetCount + 1;
                nArray[n5++] = n + this.outerFacetCount;
                ++n2;
            }
            n = n2 + n3;
            nArray[n5++] = n + this.outerFacetCount;
            nArray[n5++] = n;
            nArray[n5++] = n3;
            nArray[n5++] = n3;
            nArray[n5++] = n3 + this.outerFacetCount;
            nArray[n5++] = n + this.outerFacetCount;
            ++n8;
        }
        n8 = n6 + 1;
        while (n8 <= n6 * 2) {
            n3 = n8 * this.innerFacetCount;
            n2 = 0;
            while (n2 < n7) {
                n = n2 + n3;
                nArray[n5++] = n;
                nArray[n5++] = n + this.outerFacetCount;
                nArray[n5++] = n + this.outerFacetCount + 1;
                nArray[n5++] = n + this.outerFacetCount + 1;
                nArray[n5++] = n + 1;
                nArray[n5++] = n;
                ++n2;
            }
            n = n2 + n3;
            nArray[n5++] = n;
            nArray[n5++] = n + this.outerFacetCount;
            nArray[n5++] = n3 + this.outerFacetCount;
            nArray[n5++] = n3 + this.outerFacetCount;
            nArray[n5++] = n3;
            nArray[n5++] = n;
            ++n8;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.innerFacetCount;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.outerFacetCount + 1 << 1;
        int[] nArray = geometryData.stripCounts;
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n4 = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
        int n5 = this.innerFacetCount;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n5];
        } else if (geometryData.stripCounts.length < n5) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n5);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n4;
        geometryData.numStrips = n5;
        int n6 = 0;
        int n7 = this.innerFacetCount / 2;
        int n8 = 0;
        while (n8 < n7) {
            n3 = n8 * this.innerFacetCount;
            nArray2[n8] = this.outerFacetCount + 1 << 1;
            n2 = 0;
            while (n2 < this.outerFacetCount) {
                n = n2 + n3;
                nArray[n6++] = n + this.outerFacetCount;
                nArray[n6++] = n;
                ++n2;
            }
            nArray[n6++] = n3 + this.outerFacetCount;
            nArray[n6++] = n3;
            ++n8;
        }
        n8 = n7;
        while (n8 < n7 * 2) {
            n3 = (n8 + 1) * this.innerFacetCount;
            nArray2[n8] = this.outerFacetCount + 1 << 1;
            n2 = 0;
            while (n2 < this.outerFacetCount) {
                n = n2 + n3;
                nArray[n6++] = n;
                nArray[n6++] = n + this.outerFacetCount;
                ++n2;
            }
            nArray[n6++] = n3;
            nArray[n6++] = n3 + this.outerFacetCount;
            ++n8;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.innerFacetCount * this.outerFacetCount * 6;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.generateShape();
        int n2 = this.innerFacetCount / 2;
        int n3 = this.outerFacetCount * 3;
        int n4 = this.outerFacetCount - 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            int n8 = n6 * n3;
            int n9 = 0;
            while (n9 < n4) {
                n7 = n9 * 3 + n8;
                fArray[n5++] = this.shapeCoordinates[n7 + n3];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 2];
                fArray[n5++] = this.shapeCoordinates[n7];
                fArray[n5++] = this.shapeCoordinates[n7 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + 2];
                fArray[n5++] = this.shapeCoordinates[n7 + 3];
                fArray[n5++] = this.shapeCoordinates[n7 + 4];
                fArray[n5++] = this.shapeCoordinates[n7 + 5];
                fArray[n5++] = this.shapeCoordinates[n7 + 3];
                fArray[n5++] = this.shapeCoordinates[n7 + 4];
                fArray[n5++] = this.shapeCoordinates[n7 + 5];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 3];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 4];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 5];
                fArray[n5++] = this.shapeCoordinates[n7 + n3];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 2];
                ++n9;
            }
            n7 = n9 * 3 + n8;
            fArray[n5++] = this.shapeCoordinates[n7 + n3];
            fArray[n5++] = this.shapeCoordinates[n7 + n3 + 1];
            fArray[n5++] = this.shapeCoordinates[n7 + n3 + 2];
            fArray[n5++] = this.shapeCoordinates[n7];
            fArray[n5++] = this.shapeCoordinates[n7 + 1];
            fArray[n5++] = this.shapeCoordinates[n7 + 2];
            fArray[n5++] = this.shapeCoordinates[n8];
            fArray[n5++] = this.shapeCoordinates[n8 + 1];
            fArray[n5++] = this.shapeCoordinates[n8 + 2];
            fArray[n5++] = this.shapeCoordinates[n8];
            fArray[n5++] = this.shapeCoordinates[n8 + 1];
            fArray[n5++] = this.shapeCoordinates[n8 + 2];
            fArray[n5++] = this.shapeCoordinates[n8 + n3];
            fArray[n5++] = this.shapeCoordinates[n8 + n3 + 1];
            fArray[n5++] = this.shapeCoordinates[n8 + n3 + 2];
            fArray[n5++] = this.shapeCoordinates[n7 + n3];
            fArray[n5++] = this.shapeCoordinates[n7 + n3 + 1];
            fArray[n5++] = this.shapeCoordinates[n7 + n3 + 2];
            ++n6;
        }
        int n10 = n5;
        n6 = 0;
        while (n6 < n10) {
            fArray[n5++] = fArray[n6 + 6];
            fArray[n5++] = -fArray[n6 + 7];
            fArray[n5++] = fArray[n6 + 8];
            fArray[n5++] = fArray[n6 + 3];
            fArray[n5++] = -fArray[n6 + 4];
            fArray[n5++] = fArray[n6 + 5];
            fArray[n5++] = fArray[n6 + 0];
            fArray[n5++] = -fArray[n6 + 1];
            fArray[n5++] = fArray[n6 + 2];
            fArray[n5++] = fArray[n6 + 15];
            fArray[n5++] = -fArray[n6 + 16];
            fArray[n5++] = fArray[n6 + 17];
            fArray[n5++] = fArray[n6 + 12];
            fArray[n5++] = -fArray[n6 + 13];
            fArray[n5++] = fArray[n6 + 14];
            fArray[n5++] = fArray[n6 + 9];
            fArray[n5++] = -fArray[n6 + 10];
            fArray[n5++] = fArray[n6 + 11];
            n6 += 18;
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.innerFacetCount * this.outerFacetCount * 4;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.generateShape();
        int n2 = this.innerFacetCount / 2;
        int n3 = this.outerFacetCount * 3;
        int n4 = this.outerFacetCount - 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            int n8 = n6 * n3;
            int n9 = 0;
            while (n9 < n4) {
                n7 = n9 * 3 + n8;
                fArray[n5++] = this.shapeCoordinates[n7 + n3];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 2];
                fArray[n5++] = this.shapeCoordinates[n7];
                fArray[n5++] = this.shapeCoordinates[n7 + 1];
                fArray[n5++] = this.shapeCoordinates[n7 + 2];
                fArray[n5++] = this.shapeCoordinates[n7 + 3];
                fArray[n5++] = this.shapeCoordinates[n7 + 4];
                fArray[n5++] = this.shapeCoordinates[n7 + 5];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 3];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 4];
                fArray[n5++] = this.shapeCoordinates[n7 + n3 + 5];
                ++n9;
            }
            n7 = n9 * 3 + n8;
            fArray[n5++] = this.shapeCoordinates[n7 + n3];
            fArray[n5++] = this.shapeCoordinates[n7 + n3 + 1];
            fArray[n5++] = this.shapeCoordinates[n7 + n3 + 2];
            fArray[n5++] = this.shapeCoordinates[n7];
            fArray[n5++] = this.shapeCoordinates[n7 + 1];
            fArray[n5++] = this.shapeCoordinates[n7 + 2];
            fArray[n5++] = this.shapeCoordinates[n8];
            fArray[n5++] = this.shapeCoordinates[n8 + 1];
            fArray[n5++] = this.shapeCoordinates[n8 + 2];
            fArray[n5++] = this.shapeCoordinates[n8 + n3];
            fArray[n5++] = this.shapeCoordinates[n8 + n3 + 1];
            fArray[n5++] = this.shapeCoordinates[n8 + n3 + 2];
            ++n6;
        }
        int n10 = n5;
        n6 = 0;
        while (n6 < n10) {
            fArray[n5++] = fArray[n6 + 3];
            fArray[n5++] = -fArray[n6 + 4];
            fArray[n5++] = fArray[n6 + 5];
            fArray[n5++] = fArray[n6];
            fArray[n5++] = -fArray[n6 + 1];
            fArray[n5++] = fArray[n6 + 2];
            fArray[n5++] = fArray[n6 + 9];
            fArray[n5++] = -fArray[n6 + 10];
            fArray[n5++] = fArray[n6 + 11];
            fArray[n5++] = fArray[n6 + 6];
            fArray[n5++] = -fArray[n6 + 7];
            fArray[n5++] = fArray[n6 + 8];
            n6 += 12;
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.generateShape();
        int n2 = this.innerFacetCount / 2;
        int n3 = this.outerFacetCount * 3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n3;
            int n7 = 0;
            while (n7 < this.outerFacetCount) {
                int n8 = n7 * 3 + n6;
                fArray[n4++] = this.shapeCoordinates[n8 + n3];
                fArray[n4++] = this.shapeCoordinates[n8 + n3 + 1];
                fArray[n4++] = this.shapeCoordinates[n8 + n3 + 2];
                fArray[n4++] = this.shapeCoordinates[n8];
                fArray[n4++] = this.shapeCoordinates[n8 + 1];
                fArray[n4++] = this.shapeCoordinates[n8 + 2];
                ++n7;
            }
            fArray[n4++] = this.shapeCoordinates[n6 + n3];
            fArray[n4++] = this.shapeCoordinates[n6 + n3 + 1];
            fArray[n4++] = this.shapeCoordinates[n6 + n3 + 2];
            fArray[n4++] = this.shapeCoordinates[n6];
            fArray[n4++] = this.shapeCoordinates[n6 + 1];
            fArray[n4++] = this.shapeCoordinates[n6 + 2];
            ++n5;
        }
        int n9 = n4;
        n5 = 0;
        while (n5 < n9) {
            fArray[n4++] = fArray[n5 + 3];
            fArray[n4++] = -fArray[n5 + 4];
            fArray[n4++] = fArray[n5 + 5];
            fArray[n4++] = fArray[n5];
            fArray[n4++] = -fArray[n5 + 1];
            fArray[n4++] = fArray[n5 + 2];
            n5 += 6;
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.generateShape();
        System.arraycopy(this.shapeCoordinates, 0, geometryData.coordinates, 0, this.numShapeValues);
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = this.outerFacetCount * 4;
        int n5 = 0;
        while (n5 < n) {
            Vector3f vector3f;
            n3 = 0;
            int n6 = this.outerFacetCount;
            while (--n6 > 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 + 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 + 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 + 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n3 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            ++n5;
        }
        int n7 = n2;
        n5 = 0;
        while (n5 < n7) {
            fArray[n2++] = fArray[n5 + 6];
            fArray[n2++] = -fArray[n5 + 7];
            fArray[n2++] = fArray[n5 + 8];
            fArray[n2++] = fArray[n5 + 3];
            fArray[n2++] = -fArray[n5 + 4];
            fArray[n2++] = fArray[n5 + 5];
            fArray[n2++] = fArray[n5 + 0];
            fArray[n2++] = -fArray[n5 + 1];
            fArray[n2++] = fArray[n5 + 2];
            fArray[n2++] = fArray[n5 + 15];
            fArray[n2++] = -fArray[n5 + 16];
            fArray[n2++] = fArray[n5 + 17];
            fArray[n2++] = fArray[n5 + 12];
            fArray[n2++] = -fArray[n5 + 13];
            fArray[n2++] = fArray[n5 + 14];
            fArray[n2++] = fArray[n5 + 9];
            fArray[n2++] = -fArray[n5 + 10];
            fArray[n2++] = fArray[n5 + 11];
            n5 += 18;
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = this.outerFacetCount * 4;
        int n5 = 0;
        while (n5 < n) {
            n3 = 0;
            Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            int n6 = this.outerFacetCount;
            while (--n6 > 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 += 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                fArray[n2 + 6] = vector3f.x;
                fArray[n2 + 7] = vector3f.y;
                fArray[n2 + 8] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n2 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            ++n5;
        }
        int n7 = n2;
        n5 = 0;
        while (n5 < n7) {
            fArray[n2++] = fArray[n5 + 3];
            fArray[n2++] = -fArray[n5 + 4];
            fArray[n2++] = fArray[n5 + 5];
            fArray[n2++] = fArray[n5];
            fArray[n2++] = -fArray[n5 + 1];
            fArray[n2++] = fArray[n5 + 2];
            fArray[n2++] = fArray[n5 + 9];
            fArray[n2++] = -fArray[n5 + 10];
            fArray[n2++] = fArray[n5 + 11];
            fArray[n2++] = fArray[n5 + 6];
            fArray[n2++] = -fArray[n5 + 7];
            fArray[n2++] = fArray[n5 + 8];
            n5 += 12;
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = this.outerFacetCount * 4;
        int n5 = 0;
        while (n5 < n) {
            Vector3f vector3f;
            n3 = 0;
            int n6 = this.outerFacetCount;
            while (--n6 >= 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n3 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            ++n5;
        }
        int n7 = n2;
        n5 = 0;
        while (n5 < n7) {
            fArray[n2++] = fArray[n5 + 3];
            fArray[n2++] = -fArray[n5 + 4];
            fArray[n2++] = fArray[n5 + 5];
            fArray[n2++] = fArray[n5];
            fArray[n2++] = -fArray[n5 + 1];
            fArray[n2++] = fArray[n5 + 2];
            n5 += 6;
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        int n2 = this.innerFacetCount / 2;
        float[] fArray = geometryData.normals;
        int n3 = 0;
        float[] fArray2 = new float[3];
        int n4 = 0;
        int n5 = 0;
        while (n5 <= n2) {
            n4 = 0;
            n = this.outerFacetCount;
            while (--n >= 0) {
                Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n3, this.oradiusCoordinates, n4);
                fArray[n3++] = vector3f.x;
                fArray[n3++] = vector3f.y;
                fArray[n3++] = vector3f.z;
                n4 += 3;
            }
            ++n5;
        }
        int n6 = n3;
        System.arraycopy(fArray, 0, fArray, n6, n6);
        n = geometryData.vertexCount * 3 - 2;
        while (n > n6) {
            fArray[n] = -fArray[n];
            n -= 3;
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateShape() {
        if (!this.shapeChanged) {
            return;
        }
        this.shapeChanged = false;
        int n = (this.innerFacetCount * this.outerFacetCount + this.outerFacetCount * 2) * 3;
        if (this.shapeCoordinates == null || n > this.shapeCoordinates.length) {
            this.shapeCoordinates = new float[n];
            this.oradiusCoordinates = new float[this.outerFacetCount * 3];
        }
        this.numShapeValues = n;
        double d = Math.PI * 2 * (double)this.outerRadius / (double)this.outerFacetCount;
        float f = (float)(d / (double)this.outerRadius);
        d = Math.PI * 2 * (double)this.innerRadius / (double)this.innerFacetCount;
        float f2 = (float)(d / (double)this.innerRadius);
        int n2 = this.innerFacetCount / 2;
        int n3 = 0;
        float f3 = this.outerRadius + this.innerRadius;
        float[] fArray = new float[this.outerFacetCount];
        float[] fArray2 = new float[this.outerFacetCount];
        int n4 = 0;
        while (n4 < this.outerFacetCount) {
            fArray[n4] = (float)Math.cos(f * (float)n4);
            fArray2[n4] = (float)Math.sin(f * (float)n4);
            this.shapeCoordinates[n3] = f3 * fArray[n4];
            this.shapeCoordinates[n3 + 1] = 0.0f;
            this.shapeCoordinates[n3 + 2] = -f3 * fArray2[n4];
            this.oradiusCoordinates[n3++] = this.outerRadius * fArray[n4];
            this.oradiusCoordinates[n3++] = 0.0f;
            this.oradiusCoordinates[n3++] = -this.outerRadius * fArray2[n4];
            ++n4;
        }
        int n5 = 1;
        while (n5 < n2) {
            f3 = this.outerRadius + this.innerRadius * (float)Math.cos(f2 * (float)n5);
            float f4 = this.innerRadius * (float)Math.sin(f2 * (float)n5);
            n4 = 0;
            while (n4 < this.outerFacetCount) {
                this.shapeCoordinates[n3++] = f3 * fArray[n4];
                this.shapeCoordinates[n3++] = f4;
                this.shapeCoordinates[n3++] = -f3 * fArray2[n4];
                ++n4;
            }
            ++n5;
        }
        f3 = this.outerRadius - this.innerRadius;
        n4 = 0;
        while (n4 < this.outerFacetCount) {
            this.shapeCoordinates[n3++] = f3 * fArray[n4];
            this.shapeCoordinates[n3++] = 0.0f;
            this.shapeCoordinates[n3++] = -f3 * fArray2[n4];
            ++n4;
        }
        int n6 = n3;
        System.arraycopy(this.shapeCoordinates, 0, this.shapeCoordinates, n6, n6);
        n4 = this.shapeCoordinates.length - 2;
        while (n4 > n6) {
            this.shapeCoordinates[n4] = -this.shapeCoordinates[n4];
            n4 -= 3;
        }
    }
}

