/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Vector3d;
import org.j3d.geom.overlay.AWTEventBehavior;
import org.j3d.geom.overlay.InteractiveOverlay;
import org.j3d.geom.overlay.Overlay;
import org.j3d.geom.overlay.UpdateControlBehavior;
import org.j3d.geom.overlay.UpdateManager;

public class OverlayManager
extends BranchGroup
implements ComponentListener {
    private static double CONSOLE_Z = 20.0;
    private UpdateManager updateManager;
    private AWTEventBehavior awtBehavior;
    private TransformGroup consoleTG;
    private BranchGroup windows;
    private Transform3D planeOffset;
    private Transform3D worldTransform;
    private Dimension canvasDim;
    private Dimension checkDim;
    private Canvas3D canvas3D;
    private ArrayList overlays;

    public OverlayManager(Canvas3D canvas3D) {
        this(canvas3D, null);
    }

    public OverlayManager(Canvas3D canvas3D, UpdateManager updateManager) {
        this.canvas3D = canvas3D;
        canvas3D.addComponentListener((ComponentListener)this);
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(Double.POSITIVE_INFINITY);
        if (updateManager == null) {
            UpdateControlBehavior updateControlBehavior = new UpdateControlBehavior();
            updateControlBehavior.setSchedulingBounds((Bounds)boundingSphere);
            this.addChild((Node)updateControlBehavior);
            this.updateManager = updateControlBehavior;
        } else {
            this.updateManager = updateManager;
        }
        this.consoleTG = new TransformGroup();
        this.consoleTG.setCapability(18);
        this.addChild((Node)this.consoleTG);
        this.awtBehavior = new AWTEventBehavior();
        this.awtBehavior.setEnable(false);
        this.awtBehavior.setSchedulingBounds((Bounds)boundingSphere);
        this.addChild((Node)this.awtBehavior);
        this.overlays = new ArrayList();
        this.canvasDim = new Dimension();
        this.checkDim = new Dimension();
        this.planeOffset = new Transform3D();
        this.worldTransform = new Transform3D();
        this.windows = new BranchGroup();
        this.windows.setCapability(14);
        this.windows.setCapability(13);
        this.consoleTG.addChild((Node)this.windows);
    }

    public void viewChanged() {
        this.componentResized(null);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.canvas3D.getSize();
        View view = this.canvas3D.getView();
        double d = view != null ? view.getFieldOfView() : 0.785398;
        int n = this.overlays.size();
        int n2 = 0;
        while (n2 < n) {
            Overlay overlay = (Overlay)this.overlays.get(n2);
            overlay.setComponentDetails(dimension, d);
            ++n2;
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void initialize() {
        int n = this.overlays.size();
        int n2 = 0;
        while (n2 < n) {
            Overlay overlay = (Overlay)this.overlays.get(n2);
            overlay.initialize();
            ++n2;
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public void setUpdateManager(UpdateManager updateManager) {
        if (this.updateManager instanceof UpdateControlBehavior) {
            ((UpdateControlBehavior)this.updateManager).setEnable(false);
        }
        this.updateManager = updateManager;
    }

    public void setPosition(Overlay overlay, int n, int n2) {
        overlay.setLocation(n, n2);
    }

    public void newFrame(Transform3D transform3D) {
        if (this.overlays.size() == 0) {
            return;
        }
        this.checkScreenSize();
        this.worldTransform.set(transform3D);
        this.worldTransform.mul(this.planeOffset);
        this.consoleTG.setTransform(this.worldTransform);
    }

    public void addOverlay(Overlay overlay) {
        Dimension dimension = this.canvas3D.getSize();
        View view = this.canvas3D.getView();
        double d = view != null ? view.getFieldOfView() : 0.785398;
        overlay.setUpdateManager(this.updateManager);
        overlay.setComponentDetails(dimension, d);
        if (overlay instanceof InteractiveOverlay) {
            if (!this.awtBehavior.getEnable()) {
                this.awtBehavior.setEnable(true);
            }
            ((InteractiveOverlay)overlay).setInputRequester(this.awtBehavior);
        }
        this.overlays.add(overlay);
        this.windows.addChild((Node)overlay.getRoot());
    }

    public void removeOverlay(Overlay overlay) {
        if (this.overlays.remove(overlay)) {
            if (overlay instanceof InteractiveOverlay) {
                ((InteractiveOverlay)overlay).setInputRequester(null);
            }
            BranchGroup branchGroup = overlay.getRoot();
            branchGroup.detach();
            if (this.overlays.size() == 0) {
                this.awtBehavior.setEnable(false);
            }
        }
    }

    public void clearOverlays() {
        int n = this.overlays.size();
        int n2 = 0;
        while (n2 < n) {
            Overlay overlay = (Overlay)this.overlays.get(n2);
            if (overlay instanceof InteractiveOverlay) {
                ((InteractiveOverlay)overlay).setInputRequester(null);
            }
            BranchGroup branchGroup = overlay.getRoot();
            branchGroup.detach();
            if (this.overlays.size() == 0) {
                this.awtBehavior.setEnable(false);
            }
            ++n2;
        }
        this.overlays.clear();
    }

    private void calcImagePlate() {
        double d = this.canvas3D.getView().getFieldOfView();
        double d2 = 2.0 * CONSOLE_Z * Math.tan(d * 0.5);
        Dimension dimension = this.canvas3D.getSize();
        this.canvasDim.setSize(dimension);
        if (this.canvasDim.width != 0) {
            double d3 = d2 / dimension.getWidth();
            double d4 = dimension.getHeight() * d3;
            Vector3d vector3d = new Vector3d(-d2 / 2.0, -d4 / 2.0, -CONSOLE_Z);
            this.planeOffset.setTranslation(vector3d);
            this.planeOffset.setScale(d3);
            this.consoleTG.setTransform(this.planeOffset);
        }
        this.checkDim.setSize(this.canvas3D.getSize());
    }

    private void checkScreenSize() {
        this.canvas3D.getSize(this.checkDim);
    }
}

