/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class OverlayUtilities {
    private static final int[] BITS_3COMP = new int[]{8, 8, 8};
    private static final int[] BITS_4COMP = new int[]{8, 8, 8, 8};

    public static BufferedImage createBufferedImage(Dimension dimension, boolean bl) {
        int n = bl ? 3 : 1;
        int[] nArray = bl ? BITS_4COMP : BITS_3COMP;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, bl, false, n, 0);
        WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(dimension.width, dimension.height);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    public static List subdivide(Dimension dimension, int n, int n2) {
        List list = OverlayUtilities.components(dimension.width, n, n2);
        List list2 = OverlayUtilities.components(dimension.height, n, n2);
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = list2.size();
        int n8 = list.size();
        n3 = 0;
        while (n3 < n7) {
            n4 = 0;
            n5 = 0;
            while (n4 < n8) {
                arrayList.add(new Rectangle(n5, n6, (Integer)list.get(n4), (Integer)list2.get(n3)));
                n5 += ((Integer)list.get(n4)).intValue();
                ++n4;
            }
            n6 += ((Integer)list2.get(n3)).intValue();
            ++n3;
        }
        return arrayList;
    }

    public static List components(int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (n > 0) {
            int n4 = Math.min(OverlayUtilities.optimalPower(n, n2, n3), n);
            arrayList.add(new Integer(n4));
            n -= n4;
        }
        return arrayList;
    }

    public static int optimalPower(int n, int n2, int n3) {
        int n4 = 1;
        n = Math.min(n, n3);
        while (n4 * 2 - n <= n2) {
            n4 <<= 1;
        }
        return n4;
    }

    public static int smallestPower(int n) {
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        return n2;
    }
}

