/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.media.j3d.BoundingBox;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFunction;

public class BoundingBoxParticleFunction
implements ParticleFunction {
    private Point3d position = new Point3d();
    private Point3d lowerCorner = new Point3d();
    private Point3d upperCorner = new Point3d();
    private BoundingBox boundingBox;
    private boolean enabled;

    public BoundingBoxParticleFunction(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        boundingBox.getLower(this.lowerCorner);
        boundingBox.getUpper(this.upperCorner);
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean newFrame() {
        return true;
    }

    public boolean apply(Particle particle) {
        particle.getPosition((Tuple3d)this.position);
        if (!this.boundingBox.intersect(this.position)) {
            if (this.position.x > this.upperCorner.x) {
                this.position.x = this.upperCorner.x;
            }
            if (this.position.y > this.upperCorner.y) {
                this.position.y = this.upperCorner.y;
            }
            if (this.position.z > this.upperCorner.z) {
                this.position.z = this.upperCorner.z;
            }
            if (this.position.x < this.lowerCorner.x) {
                this.position.x = this.lowerCorner.x;
            }
            if (this.position.y < this.lowerCorner.y) {
                this.position.y = this.lowerCorner.y;
            }
            if (this.position.z < this.lowerCorner.z) {
                this.position.z = this.lowerCorner.z;
            }
        }
        particle.setPosition((float)this.position.x, (float)this.position.y, (float)this.position.z);
        return true;
    }
}

