/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;

public class MaxAgePointForceEmitter
implements ParticleInitializer {
    private static final int DELTA_LIMIT = 5;
    private int lifetime;
    private int particlesPerMs;
    private float[] origin;
    private float[] color;
    private float force;
    private float variation;
    private double initialMass;
    private double surfaceArea;
    private float[] initialVelocity;
    private int zeroDeltaCounter;

    public MaxAgePointForceEmitter(int n, int n2, float[] fArray, float[] fArray2, float f, float f2) {
        this.lifetime = n;
        this.particlesPerMs = n2 / n;
        this.origin = new float[3];
        this.origin[0] = fArray[0];
        this.origin[1] = fArray[1];
        this.origin[2] = fArray[2];
        this.color = new float[4];
        this.color[0] = fArray2[0];
        this.color[1] = fArray2[1];
        this.color[2] = fArray2[2];
        this.color[3] = fArray2[3];
        this.force = f;
        this.variation = f2;
        this.initialMass = 1.0E-7;
        this.surfaceArea = 4.0E-4;
        this.initialVelocity = new float[3];
    }

    public int numParticlesToCreate(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.zeroDeltaCounter == 5) {
                    n2 = 1;
                    this.zeroDeltaCounter = 0;
                    break;
                }
                ++this.zeroDeltaCounter;
                break;
            }
            default: {
                this.zeroDeltaCounter = 0;
                n2 = this.particlesPerMs * n;
            }
        }
        return n2;
    }

    public boolean initialize(Particle particle) {
        float f = 1.0f - (float)Math.random() * this.variation;
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3] * f);
        f = 1.0f - (float)Math.random() * this.variation;
        particle.setCycleTime((int)((float)this.lifetime * f));
        particle.setPositionAndPrevious(this.origin[0], this.origin[1], this.origin[2]);
        f = 1.0f - (float)Math.random() * this.variation;
        float f2 = f * this.force * (float)Math.random();
        float f3 = f * this.force * (float)Math.random();
        float f4 = f * this.force * (float)Math.random();
        particle.resultantForce.set((double)f2, (double)f3, (double)f4);
        particle.velocity.set(0.0, 0.0, 0.0);
        return true;
    }

    public void setPosition(float f, float f2, float f3) {
        this.origin[0] = f;
        this.origin[1] = f2;
        this.origin[2] = f3;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
    }

    public void setMass(double d) {
        this.initialMass = d;
    }

    public void setVelocity(float f, float f2, float f3) {
        this.initialVelocity[0] = f;
        this.initialVelocity[1] = f2;
        this.initialVelocity[2] = f3;
    }
}

